/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttBudgetSubjectsController"})
public class TtBudgetSubjectsController {
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtBudgetSubjectsEntity> getEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtBudgetSubjectsEntity ttBudgetSubjectsEntity = this.ttBudgetSubjectsService.getEntity(id, null);
        ajaxJson.setObj((Object)ttBudgetSubjectsEntity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtBudgetSubjectsEntity ttBudgetSubjectsEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtBudgetSubjectsEntity> pageInfo = this.ttBudgetSubjectsService.getMaiList(ttBudgetSubjectsEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getAccountMaiListPage"})
    @ResponseBody
    public List<TtBudgetSubjectsEntity> getAccountMaiListPage(HttpServletRequest request, TtBudgetSubjectsEntity ttBudgetSubjectsEntity, String applyBudgetSubjectsCode) {
        List<TtBudgetSubjectsEntity> list = this.ttBudgetSubjectsService.getAccountMaiList(ttBudgetSubjectsEntity, applyBudgetSubjectsCode);
        return list;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtBudgetSubjectsEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttBudgetSubjectsService.update(entity, ajaxJson) : this.ttBudgetSubjectsService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"stop"})
    @ResponseBody
    public AjaxJson stop(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttBudgetSubjectsService.startOrStop(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"deleteSubject"})
    public AjaxJson deleteSubject(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttBudgetSubjectsService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"start"})
    @ResponseBody
    public AjaxJson start(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttBudgetSubjectsService.startOrStop(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"getListByCodes"})
    public AjaxJson<TtBudgetSubjectsEntity> getListByCodes(@RequestParam(value="budgetSubjectsCodes") List<String> budgetSubjectsCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtBudgetSubjectsEntity> list = this.ttBudgetSubjectsService.getBudgetSubjects(budgetSubjectsCodes);
        ajaxJson.setList(list);
        return ajaxJson;
    }
}

