/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.travel.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.travel.dao.TtTravelCostDao;
import com.biz.eisp.budget.travel.entity.TtTravelCostEntity;
import com.biz.eisp.budget.travel.service.TtTravelCostService;
import com.biz.eisp.budget.travel.vo.TtTravelCostVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttTravelCostService")
@Transactional
public class TtTravelCostServiceImpl
extends BaseServiceImpl<TtTravelCostEntity>
implements TtTravelCostService {
    @Autowired
    private TtTravelCostDao ttTravelCostDao;

    @Override
    public PageInfo<TtTravelCostVo> findTtTravelCostPage(TtTravelCostVo entity, Page page) {
        Example example = new Example(TtTravelCostEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActSubclassCode())) {
            criteria.andEqualTo("actSubclassCode", (Object)entity.getActSubclassCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getActSubclassName())) {
            criteria.andLike("actSubclassName", "%" + entity.getActSubclassName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getPositionLevel())) {
            criteria.andEqualTo("positionLevel", (Object)entity.getPositionLevel());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getAreaLevel())) {
            criteria.andEqualTo("areaLevel", (Object)entity.getAreaLevel());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttTravelCostDao.selectByExample(example), (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtTravelCostServiceImpl.class)
    public boolean delete(String id) {
        int i = this.ttTravelCostDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public TtTravelCostEntity getTtTravelCostEntity(String id) {
        return (TtTravelCostEntity)this.ttTravelCostDao.selectByPrimaryKey(id);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtTravelCostServiceImpl.class)
    public void save(TtTravelCostVo vo) {
        TtTravelCostEntity entity = null;
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(vo);
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            this.insertSelective(entity);
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtTravelCostServiceImpl.class)
    public void update(TtTravelCostVo vo) {
        TtTravelCostEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getEntity(vo);
            this.updateByPrimaryKeySelective(entity);
        }
    }

    private TtTravelCostEntity getEntity(TtTravelCostVo vo) {
        TtTravelCostEntity entity = new TtTravelCostEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setActSubclassCode(vo.getActSubclassCode());
        entity.setActSubclassName(vo.getActSubclassName());
        entity.setAreaLevel(vo.getAreaLevel());
        entity.setPositionLevel(vo.getPositionLevel());
        entity.setCeilingPrice(vo.getCeilingPrice());
        return entity;
    }
}

