/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.income.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.income.dao.TtIncomeBudgetDao;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.IncomeGetMaiListAuthExpand;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttIncomeBudgetService")
@Transactional
public class TtIncomeBudgetServiceImpl
extends BaseServiceImpl<TtIncomeBudgetEntity>
implements TtIncomeBudgetService {
    @Autowired
    private TtIncomeBudgetDao ttIncomeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private IncomeGetMaiListAuthExpand incomeGetMaiListAuthExpand;

    @Override
    public void updateBudgetSubjectsName(String budgetSubjectsName, String budgetSubjectsCode) {
        this.ttIncomeBudgetDao.updateBudgetSubjectsName(budgetSubjectsName, budgetSubjectsCode);
    }

    @Override
    public PageInfo<TtIncomeBudgetEntity> getMaiList(TtIncomeBudgetEntity entity, Page page) {
        List authEntities;
        StringBuffer buffer = new StringBuffer();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        Object flag = null;
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true)))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String expandSql;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            String temp = SqlUtil.setSqlIn500((List)codes, (String)"a.budget_depart_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append("  a.budget_depart_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("customer")) {
                        List<String> custCodes;
                        List customerEntities;
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("customer");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrgDown(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList<String>();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrg(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("40")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPosDown(userRedis.getPosId(), userRedis.getPosCode()), (boolean)true);
                            custCodes = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPos(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        }
                        buffer.append(")");
                    }
                    if (this.incomeGetMaiListAuthExpand != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.incomeGetMaiListAuthExpand.getMaiListAuth(auMap, userRedis, flagOr, buffer)))) {
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.ttIncomeBudgetDao.getMaiList(entity, aUsql), (Page)page);
    }

    @Override
    public TtIncomeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtIncomeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttIncomeBudgetDao.selectByExample(example)))) {
            return (TtIncomeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson update(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson save(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.income_budget.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttIncomeBudgetDao.insertSelective(entity);
        this.ttBudgutDetailService.incomeFeeBudgutDetail(entity.getBudgetCode(), ConstantEnum.BudgetUesdTypeEnum.INIT.getValue(), entity.getInitAmount(), "\u65b0\u589e");
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtIncomeBudgetEntity entity = new TtIncomeBudgetEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }
}

