/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.auditinfo.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.attachment.dao.BudgetAttachmentDao;
import com.biz.eisp.budget.attachment.entity.BudgetAttachmentEntity;
import com.biz.eisp.budget.auditinfo.dao.TtAuditInfoDao;
import com.biz.eisp.budget.auditinfo.entity.TtAuditInfoEntity;
import com.biz.eisp.budget.auditinfo.service.TtAuditInfoService;
import com.biz.eisp.budget.auditinfo.vo.AuditInfoRespVo;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDetailDao;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttAuditInfoService")
@Transactional
public class TtAuditInfoServiceImpl
extends BaseServiceImpl<TtAuditInfoEntity>
implements TtAuditInfoService {
    @Autowired
    private TtAuditInfoDao ttAuditInfoDao;
    @Autowired
    private BudgetAttachmentDao budgetAttachmentDao;
    @Autowired
    private TtCostTypeFineDetailDao ttCostTypeFineDetailDao;
    @Autowired
    private TtCostTypeFineService TtCostTypeFineService;

    @Override
    public PageInfo<TtAuditInfoEntity> getMaiList(TtAuditInfoEntity ttAuditInfoEntity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttAuditInfoDao.findTtAuditInfoList(ttAuditInfoEntity), (Page)page);
    }

    @Override
    public List<TtAuditInfoEntity> findTtAuditInfoList(TtAuditInfoEntity ttAuditInfoEntity) {
        return this.ttAuditInfoDao.findTtAuditInfoList(ttAuditInfoEntity);
    }

    @Override
    public TtAuditInfoEntity getEntity(String id) {
        TtAuditInfoEntity entity = new TtAuditInfoEntity();
        Example mExample = new Example(BudgetAttachmentEntity.class);
        Example.Criteria mCriteria = mExample.createCriteria();
        mCriteria.andEqualTo("businessKey", (Object)id);
        List budgetAttachmentEntitys = this.budgetAttachmentDao.selectByExample(mExample);
        entity = (TtAuditInfoEntity)this.ttAuditInfoDao.selectByPrimaryKey(id);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)budgetAttachmentEntitys)) {
            Object json = JSON.toJSON((Object)budgetAttachmentEntitys);
            entity.setMlamJson(json.toString());
        }
        return entity;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtAuditInfoServiceImpl.class)
    public AjaxJson save(TtAuditInfoEntity ttAuditInfoEntity, AjaxJson ajaxJson) {
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        int i = this.ttAuditInfoDao.insertSelective(ttAuditInfoEntity);
        if (i > 0 && StringUtil.isNotEmpty((CharSequence)ttAuditInfoEntity.getMlamJson())) {
            List mlamEntityList = JSON.parseArray((String)ttAuditInfoEntity.getMlamJson(), BudgetAttachmentEntity.class);
            ArrayList<BudgetAttachmentEntity> mlamList = new ArrayList<BudgetAttachmentEntity>();
            for (BudgetAttachmentEntity mlamEntity : mlamEntityList) {
                if (StringUtil.isEmpty((String)mlamEntity.getVurlPath())) continue;
                mlamEntity.setBusinessKey(ttAuditInfoEntity.getId());
                mlamList.add(mlamEntity);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(mlamList)) {
                this.budgetAttachmentDao.insertList(mlamList);
            }
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtAuditInfoServiceImpl.class)
    public AjaxJson update(TtAuditInfoEntity ttAuditInfoEntity, AjaxJson ajaxJson) {
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        int i = this.ttAuditInfoDao.updateByPrimaryKeySelective(ttAuditInfoEntity);
        if (i > 0) {
            Example mExample = new Example(BudgetAttachmentEntity.class);
            Example.Criteria mCriteria = mExample.createCriteria();
            mCriteria.andEqualTo("businessKey", (Object)ttAuditInfoEntity.getId());
            this.budgetAttachmentDao.deleteByExample(mExample);
            if (StringUtil.isNotEmpty((CharSequence)ttAuditInfoEntity.getMlamJson())) {
                List mlamEntityList = JSON.parseArray((String)ttAuditInfoEntity.getMlamJson(), BudgetAttachmentEntity.class);
                ArrayList<BudgetAttachmentEntity> mlamList = new ArrayList<BudgetAttachmentEntity>();
                for (BudgetAttachmentEntity mlamEntity : mlamEntityList) {
                    if (StringUtil.isEmpty((String)mlamEntity.getVurlPath())) continue;
                    mlamEntity.setBusinessKey(ttAuditInfoEntity.getId());
                    mlamList.add(mlamEntity);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(mlamList)) {
                    this.budgetAttachmentDao.insertList(mlamList);
                }
            }
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtAuditInfoServiceImpl.class)
    public boolean delete(String id) {
        int i = this.ttAuditInfoDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public AuditInfoRespVo getAuditInfoRespVoByFineCode(String fineCode, String type) {
        AuditInfoRespVo auditInfoRespVo = new AuditInfoRespVo();
        TtCostTypeFineEntity ttCostTypeFineEntity = this.TtCostTypeFineService.getFineEntity("", fineCode);
        if (StringUtil.equals((String)type, (String)ConstantEnum.YesNoEnum.ONE.getValue())) {
            if (ttCostTypeFineEntity != null) {
                auditInfoRespVo.setFineCode(ttCostTypeFineEntity.getFineCode());
                auditInfoRespVo.setFineName(ttCostTypeFineEntity.getFineName());
                Example exampleAll = new Example(TtCostTypeFineDetailEntity.class);
                Example.Criteria criteriaAll = exampleAll.createCriteria();
                criteriaAll.andIn("fineCode", Arrays.asList(fineCode.split(",")));
                criteriaAll.andEqualTo("type", (Object)"audit_material");
                List details = this.ttCostTypeFineDetailDao.selectByExample(exampleAll);
                ArrayList auditInfoEntitys = new ArrayList();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)details)) {
                    details.forEach(item -> {
                        TtAuditInfoEntity query = new TtAuditInfoEntity();
                        query.setCode(item.getCode());
                        List<TtAuditInfoEntity> ttAuditInfoEntitys = this.findTtAuditInfoList(query);
                        if (CollectionUtil.listNotEmptyNotSizeZero(ttAuditInfoEntitys)) {
                            auditInfoEntitys.add(ttAuditInfoEntitys.get(0));
                        }
                    });
                }
                auditInfoRespVo.setAuditInfoEntitys(auditInfoEntitys);
            }
        } else {
            List dictDatas = DictUtil.getDictList((String)"audit_material");
            ArrayList auditInfoEntitys = new ArrayList();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)dictDatas)) {
                dictDatas.forEach(item -> {
                    TtAuditInfoEntity query = new TtAuditInfoEntity();
                    query.setCode(item.getDictCode());
                    List<TtAuditInfoEntity> ttAuditInfoEntitys = this.findTtAuditInfoList(query);
                    if (CollectionUtil.listNotEmptyNotSizeZero(ttAuditInfoEntitys)) {
                        auditInfoEntitys.add(ttAuditInfoEntitys.get(0));
                    }
                });
            }
            auditInfoRespVo.setAuditInfoEntitys(auditInfoEntitys);
            auditInfoRespVo.setFineCode(ttCostTypeFineEntity.getFineCode());
            auditInfoRespVo.setFineName(ttCostTypeFineEntity.getFineName());
        }
        return auditInfoRespVo;
    }
}

