/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.config.dao.TtBudgetSubjectsDao;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttBudgetSubjectsService")
@Transactional
public class TtBudgetSubjectsServiceImpl
extends BaseServiceImpl<TtBudgetSubjectsEntity>
implements TtBudgetSubjectsService {
    @Autowired
    private TtBudgetSubjectsDao ttBudgetSubjectsDao;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;
    @Autowired
    private TtIncomeBudgetService ttIncomeBudgetService;

    @Override
    public PageInfo<TtBudgetSubjectsEntity> getMaiList(TtBudgetSubjectsEntity entity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.getTtBudgetSubjectsList(entity), (Page)page);
    }

    @Override
    public List<TtBudgetSubjectsEntity> getTtBudgetSubjectsList(TtBudgetSubjectsEntity entity) {
        Example example = new Example(TtBudgetSubjectsEntity.class);
        example.orderBy("budgetSubjectsCode");
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            entity.setEnableStatus(StringUtil.remove((String)entity.getEnableStatus(), (String)","));
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsCode())) {
            criteria.andLike("budgetSubjectsCode", "%" + entity.getBudgetSubjectsCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsName())) {
            criteria.andLike("budgetSubjectsName", "%" + entity.getBudgetSubjectsName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsTypeCode())) {
            criteria.andEqualTo("subjectsTypeCode", (Object)entity.getSubjectsTypeCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsTypeName())) {
            criteria.andLike("subjectsTypeName", "%" + entity.getSubjectsTypeName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsGroupCode())) {
            criteria.andEqualTo("subjectsGroupCode", (Object)entity.getSubjectsGroupCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsGroupName())) {
            criteria.andLike("subjectsGroupName", "%" + entity.getSubjectsGroupName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsErpCode())) {
            criteria.andLike("budgetSubjectsErpCode", "%" + entity.getBudgetSubjectsErpCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getIsBudgetControl())) {
            criteria.andEqualTo("isBudgetControl", (Object)entity.getIsBudgetControl());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getIsFiscalContinue())) {
            criteria.andEqualTo("isFiscalContinue", (Object)entity.getIsFiscalContinue());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getNotes())) {
            criteria.andLike("notes", "%" + entity.getNotes() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCreateName())) {
            criteria.andLike("createName", "%" + entity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getUpdateName())) {
            criteria.andLike("updateName", "%" + entity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + entity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + entity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + entity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + entity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + entity.getExtChar5() + "%");
        }
        return this.ttBudgetSubjectsDao.selectByExample(example);
    }

    @Override
    public List<TtBudgetSubjectsEntity> getAccountMaiList(TtBudgetSubjectsEntity entity, String applyBudgetSubjectsCode) {
        List<TtBudgetSubjectsEntity> list = this.getTtBudgetSubjectsList(entity);
        Iterator<TtBudgetSubjectsEntity> it = list.iterator();
        while (it.hasNext()) {
            TtBudgetSubjectsEntity obj = it.next();
            if (!StringUtil.equals((String)obj.getBudgetSubjectsCode(), (String)applyBudgetSubjectsCode)) continue;
            it.remove();
        }
        return list;
    }

    @Override
    public TtBudgetSubjectsEntity getEntity(String id, String budgetSubjectsCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetSubjectsCode)) {
            return null;
        }
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetSubjectsCode)) {
            criteria.andEqualTo("budgetSubjectsCode", (Object)budgetSubjectsCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttBudgetSubjectsDao.selectByExample(example)))) {
            return (TtBudgetSubjectsEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtBudgetSubjectsServiceImpl.class)
    public AjaxJson save(TtBudgetSubjectsEntity entity, AjaxJson ajaxJson) {
        this.ttBudgetSubjectsDao.insertSelective(entity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtBudgetSubjectsServiceImpl.class)
    public AjaxJson update(TtBudgetSubjectsEntity entity, AjaxJson ajaxJson) {
        this.ttBudgetSubjectsDao.updateByPrimaryKeySelective(entity);
        this.ttCostTypeCategoriesService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        this.ttCostTypeFineService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        this.ttFeeBudgetService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        this.ttIncomeBudgetService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        return ajaxJson;
    }

    @Override
    public AjaxJson startOrStop(String id, AjaxJson ajaxJson, String type) {
        TtBudgetSubjectsEntity entity = new TtBudgetSubjectsEntity();
        entity.setId(id);
        entity.setEnableStatus(type);
        this.ttBudgetSubjectsDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public boolean delete(String id) {
        int i = this.ttBudgetSubjectsDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public List<TtBudgetSubjectsEntity> getBudgetSubjects(List<String> budgetSubjectsCodes) {
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("budgetSubjectsCode", budgetSubjectsCodes);
        return this.selectExample(example);
    }

    @Override
    public ValidForm checkBudgetSubjectsCodeRepeat(String id, String param) {
        ValidForm validForm = new ValidForm();
        if (StringUtil.isBlank((CharSequence)param)) {
            return validForm;
        }
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetSubjectsCode", (Object)param);
        if (StringUtil.isNotBlank((CharSequence)id)) {
            criteria.andNotEqualTo("id", (Object)id);
            List list = this.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                validForm.setInfo("\u7f16\u7801\u91cd\u590d");
                validForm.setStatus("N");
            }
        } else {
            List list = this.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                validForm.setInfo("\u7f16\u7801\u91cd\u590d");
                validForm.setStatus("N");
            }
        }
        return validForm;
    }
}

