/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.budget.config.dao.TtCostTypeCategoriesFineDao;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesFineEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesFineService;
import com.biz.eisp.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttCostTypeCategoriesFineService")
@Transactional(rollbackFor={Exception.class})
public class TtCostTypeCategoriesFineServiceImpl
extends BaseServiceImpl<TtCostTypeCategoriesFineEntity>
implements TtCostTypeCategoriesFineService {
    @Autowired
    private TtCostTypeCategoriesFineDao ttCostTypeCategoriesFineDao;

    @Override
    public void relevanceFine(List<TtCostTypeFineEntity> addList, List<TtCostTypeFineEntity> delList, TtCostTypeCategoriesEntity entity) {
        String categoriesCode = entity.getCategoriesCode();
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            ArrayList costTypeCategoriesFineEntityList = new ArrayList(addList.size());
            addList.forEach(dataItem -> {
                TtCostTypeCategoriesFineEntity categoriesFineEntity = new TtCostTypeCategoriesFineEntity();
                categoriesFineEntity.setCategoriesCode(categoriesCode);
                categoriesFineEntity.setFineCode(dataItem.getFineCode());
                costTypeCategoriesFineEntityList.add(categoriesFineEntity);
            });
            this.ttCostTypeCategoriesFineDao.insertList(costTypeCategoriesFineEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(delList)) {
            Example exampleDel = new Example(TtCostTypeCategoriesFineEntity.class);
            Example.Criteria criteria = exampleDel.createCriteria();
            List fineCodes = delList.stream().map(TtCostTypeFineEntity::getFineCode).collect(Collectors.toList());
            criteria.andEqualTo("categoriesCode", (Object)categoriesCode);
            criteria.andIn("fineCode", fineCodes);
            this.ttCostTypeCategoriesFineDao.deleteByExample(exampleDel);
        }
    }

    @Override
    public List<TtCostTypeCategoriesFineEntity> findListByfineCodeOrcategoriesCode(String fineCode, String categoriesCode) {
        TtCostTypeCategoriesFineEntity entity = new TtCostTypeCategoriesFineEntity();
        entity.setFineCode(fineCode);
        entity.setCategoriesCode(categoriesCode);
        return this.select(entity);
    }
}

