/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.auditinfo.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.budget.auditinfo.entity.TtAuditInfoEntity;
import com.biz.eisp.budget.auditinfo.service.TtAuditInfoService;
import com.biz.eisp.budget.auditinfo.vo.AuditInfoRespVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttAuditInfoController"})
public class TtAuditInfoController
extends ImpExpController {
    @Autowired
    private TtAuditInfoService ttAuditInfoService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtAuditInfoEntity> getEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAuditInfoEntity entity = this.ttAuditInfoService.getEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtAuditInfoEntity ttAuditInfoEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtAuditInfoEntity> pageInfo = this.ttAuditInfoService.getMaiList(ttAuditInfoEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtAuditInfoEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttAuditInfoService.update(entity, ajaxJson) : this.ttAuditInfoService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"getAuditMaterialDict"})
    @ResponseBody
    public List<KnlDictDataEntity> getAuditMaterialDict(HttpServletRequest request, KnlDictDataEntity knlDictDataEntity) {
        List knlDictDataEntitys = DictUtil.getDictList((String)"audit_material");
        String dictCode = knlDictDataEntity.getDictCode();
        String dictValue = knlDictDataEntity.getDictValue();
        if (StringUtil.isEmpty((String)dictCode) && StringUtil.isEmpty((String)dictValue)) {
            return knlDictDataEntitys;
        }
        ArrayList<KnlDictDataEntity> result = new ArrayList<KnlDictDataEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)knlDictDataEntitys)) {
            for (KnlDictDataEntity dictData : knlDictDataEntitys) {
                if (StringUtil.isEmpty((String)dictCode)) {
                    dictCode = "";
                }
                if (StringUtil.isEmpty((String)dictValue)) {
                    dictValue = "";
                }
                if (dictData.getDictCode().indexOf(knlDictDataEntity.getDictCode()) == -1 || dictData.getDictValue().indexOf(knlDictDataEntity.getDictValue()) == -1) continue;
                result.add(knlDictDataEntity);
            }
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"delete"})
    public AjaxJson deleteTtAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttAuditInfoService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @GetMapping(value={"getAuditInfoRespVoByFineCode"})
    public AjaxJson<AuditInfoRespVo> getAuditInfoRespVoByFineCode(@RequestParam(value="fineCode", required=false) String fineCode, @RequestParam(value="type", required=false) String type) {
        AjaxJson j = new AjaxJson();
        AuditInfoRespVo auditInfoRespVo = this.ttAuditInfoService.getAuditInfoRespVoByFineCode(fineCode, type);
        j.setObj((Object)auditInfoRespVo);
        return j;
    }

    @GetMapping(value={"getTtAuditInfoEntitysByFineCodes"})
    public AjaxJson<TtAuditInfoEntity> getTtAuditInfoEntitysByFineCodes(@RequestParam(value="fineCodes", required=true) Set<String> fineCodes) {
        AjaxJson j = new AjaxJson();
        List<TtAuditInfoEntity> entitys = this.ttAuditInfoService.getTtAuditInfoEntitysByFineCodes(fineCodes);
        j.setObjList(entitys);
        return j;
    }

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        return new AjaxJson();
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        return new AjaxJson();
    }
}

