/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.service.impl;

import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.tags.FormTags;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.dao.TtCostTypeCategoriesDao;
import com.biz.eisp.budget.config.dao.TtCostTypeCategoriesExtendDao;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDao;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDetailDao;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesExtendEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.CategoriesChooseTypeListPageExtend;
import com.biz.eisp.budget.config.service.ChooseTypeListOverExtend;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesFineService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.config.vo.CostTypeCategoriesBudgetVo;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttCostTypeCategoriesService")
@Transactional
public class TtCostTypeCategoriesServiceImpl
extends BaseServiceImpl<TtCostTypeCategoriesEntity>
implements TtCostTypeCategoriesService {
    @Autowired
    private TtCostTypeCategoriesDao ttCostTypeCategoriesDao;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtCostTypeCategoriesFineService ttCostTypeCategoriesFineService;
    @Autowired
    private TtCostTypeFineDetailDao ttCostTypeFineDetailDao;
    @Autowired
    private TtCostTypeCategoriesExtendDao ttCostTypeCategoriesExtendDao;
    @Autowired
    private TmOrgFeign tmOrgFeign;
    @Autowired
    private TtCostTypeFineDao ttCostTypeFineDao;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;
    @Autowired(required=false)
    private CategoriesChooseTypeListPageExtend categoriesChooseTypeListPageExtend;
    @Autowired(required=false)
    private ChooseTypeListOverExtend chooseTypeListOverExtend;

    @Override
    public PageInfo<TtCostTypeCategoriesEntity> getMaiList(TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity, Page page) {
        Example example = new Example(TtCostTypeCategoriesEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getCategoriesCode())) {
            criteria.andLike("categoriesCode", "%" + ttCostTypeCategoriesEntity.getCategoriesCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getCategoriesName())) {
            criteria.andLike("categoriesName", "%" + ttCostTypeCategoriesEntity.getCategoriesName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getBusinessFeeCode())) {
            criteria.andEqualTo("businessFeeCode", (Object)ttCostTypeCategoriesEntity.getBusinessFeeCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getBusinessFeeName())) {
            criteria.andLike("businessFeeName", "%" + ttCostTypeCategoriesEntity.getBusinessFeeName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getFinancialFeeCode())) {
            criteria.andLike("financialFeeCode", "%" + ttCostTypeCategoriesEntity.getFinancialFeeCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getFinancialFeeName())) {
            criteria.andLike("financialFeeName", "%" + ttCostTypeCategoriesEntity.getFinancialFeeName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getBudgetSubjectsCode())) {
            criteria.andLike("budgetSubjectsCode", "%" + ttCostTypeCategoriesEntity.getBudgetSubjectsCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getBudgetSubjectsName())) {
            criteria.andLike("budgetSubjectsName", "%" + ttCostTypeCategoriesEntity.getBudgetSubjectsName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)ttCostTypeCategoriesEntity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getCreateName())) {
            criteria.andLike("createName", "%" + ttCostTypeCategoriesEntity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getUpdateName())) {
            criteria.andLike("updateName", "%" + ttCostTypeCategoriesEntity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + ttCostTypeCategoriesEntity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + ttCostTypeCategoriesEntity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + ttCostTypeCategoriesEntity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + ttCostTypeCategoriesEntity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCostTypeCategoriesEntity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + ttCostTypeCategoriesEntity.getExtChar5() + "%");
        }
        example.setOrderByClause(" categories_code desc ");
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeCategoriesDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TtCostTypeCategoriesEntity> chooseTypeListPage(TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity, List<String> budgetCodes, Page page) {
        budgetCodes.add("_");
        StringBuffer stringBuffer = new StringBuffer();
        UserRedis userRedis = UserUtils.getUser();
        if (this.categoriesChooseTypeListPageExtend != null) {
            String sql = this.categoriesChooseTypeListPageExtend.chooseTypeListPage(budgetCodes, userRedis);
            stringBuffer.append(sql);
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeCategoriesDao.chooseTypeListPage(ttCostTypeCategoriesEntity, budgetCodes, stringBuffer.toString()), (Page)page);
    }

    @Override
    public List<TtCostTypeCategoriesEntity> chooseTypeList(TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity, List<String> budgetCodes) {
        if (this.chooseTypeListOverExtend != null) {
            return this.chooseTypeListOverExtend.chooseTypeList(ttCostTypeCategoriesEntity, budgetCodes);
        }
        return this.chooseTypeListNormal(ttCostTypeCategoriesEntity, budgetCodes);
    }

    @Override
    public List<TtCostTypeCategoriesEntity> chooseTypeListNormal(TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity, List<String> budgetCodes) {
        return this.ttCostTypeCategoriesDao.chooseTypeByBudgetList(ttCostTypeCategoriesEntity, budgetCodes);
    }

    @Override
    public TtCostTypeCategoriesEntity getCategoriesEntity(String id, String categoriesCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)categoriesCode)) {
            return null;
        }
        Example example = new Example(TtCostTypeCategoriesEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)categoriesCode)) {
            criteria.andEqualTo("categoriesCode", (Object)categoriesCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttCostTypeCategoriesDao.selectByExample(example)))) {
            Example exampleDetail = new Example(TtCostTypeFineDetailEntity.class);
            Example.Criteria criteriaDetail = exampleDetail.createCriteria();
            criteriaDetail.andEqualTo("fineCode", (Object)((TtCostTypeCategoriesEntity)list.get(0)).getCategoriesCode());
            criteriaDetail.andEqualTo("typeName", (Object)"\u5927\u7c7b\u53ef\u9009\u7ec4\u7ec7");
            List detailEntities = this.ttCostTypeFineDetailDao.selectByExample(exampleDetail);
            ArrayList tags = new ArrayList();
            detailEntities.forEach(item -> {
                FormTags formTags = new FormTags();
                formTags.setCode(item.getCode());
                formTags.setName(item.getName());
                tags.add(formTags);
            });
            ((TtCostTypeCategoriesEntity)list.get(0)).setOrgFormTags(tags);
            Example exampleOrgType = new Example(TtCostTypeFineDetailEntity.class);
            Example.Criteria criteriaOrgType = exampleOrgType.createCriteria();
            criteriaOrgType.andEqualTo("fineCode", (Object)((TtCostTypeCategoriesEntity)list.get(0)).getCategoriesCode());
            criteriaOrgType.andEqualTo("typeName", (Object)"\u5927\u7c7b\u53ef\u9009\u7ec4\u7ec7\u7c7b\u578b");
            List orgTypeEntities = this.ttCostTypeFineDetailDao.selectByExample(exampleOrgType);
            ArrayList orgtags = new ArrayList();
            orgTypeEntities.forEach(item -> {
                FormTags formTags = new FormTags();
                formTags.setCode(item.getCode());
                formTags.setName(item.getName());
                orgtags.add(formTags);
            });
            ((TtCostTypeCategoriesEntity)list.get(0)).setOrgTypeFormTags(orgtags);
            return (TtCostTypeCategoriesEntity)list.get(0);
        }
        return null;
    }

    @Override
    public AjaxJson stopOrstartCategories(String id, AjaxJson ajaxJson, String type) {
        TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity = new TtCostTypeCategoriesEntity();
        ttCostTypeCategoriesEntity.setId(id);
        ttCostTypeCategoriesEntity.setEnableStatus(type);
        this.ttCostTypeCategoriesDao.updateByPrimaryKeySelective(ttCostTypeCategoriesEntity);
        TtCostTypeCategoriesEntity entity = (TtCostTypeCategoriesEntity)this.ttCostTypeCategoriesDao.selectByPrimaryKey(id);
        List<TtCostTypeFineEntity> fines = this.ttCostTypeFineService.getFinesByCategoriesCode(entity.getCategoriesCode());
        fines.forEach(item -> this.ttCostTypeFineService.update((TtCostTypeFineEntity)item, ajaxJson));
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtCostTypeCategoriesServiceImpl.class)
    public AjaxJson save(TtCostTypeCategoriesEntity entity, AjaxJson ajaxJson) {
        TtCostTypeFineDetailEntity[] orgTypeEntities;
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setCategoriesCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_categories.name()));
        this.ttCostTypeCategoriesDao.insertSelective(entity);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((CharSequence)entity.getFineIds())) {
            for (String id : entity.getFineIds().split(",")) {
                if (!StringUtil.isNotEmpty((CharSequence)id)) continue;
                map.put(id, id);
            }
        }
        this.relevanceFine(entity, map);
        TtCostTypeFineDetailEntity[] entities = (TtCostTypeFineDetailEntity[])JsonPropertyUtil.toObject((String)entity.getOrgJson(), TtCostTypeFineDetailEntity[].class);
        if (entities != null && entities.length > 0) {
            List<TtCostTypeFineDetailEntity> listEntity = Arrays.asList(entities);
            listEntity.forEach(detail -> {
                detail.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                detail.setFineCode(entity.getCategoriesCode());
                detail.setTypeName("\u5927\u7c7b\u53ef\u9009\u7ec4\u7ec7");
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(listEntity)) {
                this.ttCostTypeFineDetailDao.batchInsertList(listEntity);
            }
        }
        if ((orgTypeEntities = (TtCostTypeFineDetailEntity[])JsonPropertyUtil.toObject((String)entity.getOrgTypeJson(), TtCostTypeFineDetailEntity[].class)) != null && orgTypeEntities.length > 0) {
            List<TtCostTypeFineDetailEntity> listEntity = Arrays.asList(orgTypeEntities);
            listEntity.forEach(detail -> {
                detail.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                detail.setFineCode(entity.getCategoriesCode());
                detail.setTypeName("\u5927\u7c7b\u53ef\u9009\u7ec4\u7ec7\u7c7b\u578b");
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(listEntity)) {
                this.ttCostTypeFineDetailDao.batchInsertList(listEntity);
            }
        }
        this.doExtendJson(entity);
        return ajaxJson;
    }

    private void doExtendJson(TtCostTypeCategoriesEntity entity) {
        String extendJson = entity.getExtendJson();
        Example example = new Example(TtCostTypeCategoriesExtendEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)extendJson)) {
            criteria.andEqualTo("categoriesCode", (Object)entity.getCategoriesCode());
            List entities = this.ttCostTypeCategoriesExtendDao.selectByExample(example);
            HashMap mapIdEntity = entities.stream().collect(Collectors.toMap(TtCostTypeCategoriesExtendEntity::getId, account -> account));
            mapIdEntity = mapIdEntity == null ? new HashMap() : mapIdEntity;
            ArrayList<TtCostTypeCategoriesExtendEntity> addList = new ArrayList<TtCostTypeCategoriesExtendEntity>();
            ArrayList updateList = new ArrayList();
            ArrayList deleteList = new ArrayList();
            List tempArr = JsonPropertyUtil.toArray((String)entity.getExtendJson(), TtCostTypeCategoriesExtendEntity.class);
            List list = tempArr = tempArr == null ? new ArrayList() : tempArr;
            if (CollectionUtil.listNotEmptyNotSizeZero((List)tempArr)) {
                Map<String, TtCostTypeCategoriesExtendEntity> mapIdFrom = tempArr.stream().collect(Collectors.toMap(TtCostTypeCategoriesExtendEntity::getId, account -> account));
                entities.forEach(item -> {
                    if (!mapIdFrom.containsKey(item.getId())) {
                        deleteList.add(item);
                    }
                });
                for (TtCostTypeCategoriesExtendEntity item2 : tempArr) {
                    item2.setCategoriesCode(entity.getCategoriesCode());
                    if (mapIdEntity.containsKey(item2.getId())) {
                        BeanUtils.copyProperties((Object)item2, mapIdEntity.get(item2.getId()));
                        updateList.add(mapIdEntity.get(item2.getId()));
                        continue;
                    }
                    item2.setId(null);
                    addList.add(item2);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
                    deleteList.forEach(item -> this.ttCostTypeCategoriesExtendDao.deleteByPrimaryKey(item.getId()));
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
                    addList.forEach(item -> this.ttCostTypeCategoriesExtendDao.insertSelective(item));
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
                    updateList.forEach(item -> this.ttCostTypeCategoriesExtendDao.updateByPrimaryKeySelective(item));
                }
            } else {
                criteria.andEqualTo("categoriesCode", (Object)entity.getCategoriesCode());
                this.ttCostTypeCategoriesExtendDao.deleteByExample(example);
            }
        } else {
            criteria.andEqualTo("categoriesCode", (Object)entity.getCategoriesCode());
            this.ttCostTypeCategoriesExtendDao.deleteByExample(example);
        }
    }

    private void relevanceFine(TtCostTypeCategoriesEntity entity, Map<String, String> mapIds) {
        List<TtCostTypeFineEntity> fines = this.ttCostTypeFineService.getFinesByCategoriesCode(entity.getCategoriesCode());
        ArrayList<TtCostTypeFineEntity> addList = new ArrayList<TtCostTypeFineEntity>();
        ArrayList<TtCostTypeFineEntity> deleteList = new ArrayList<TtCostTypeFineEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero(fines)) {
            fines.forEach(item -> {
                if (mapIds.containsKey(item.getId())) {
                    mapIds.remove(item.getId());
                } else {
                    deleteList.add((TtCostTypeFineEntity)item);
                }
            });
        }
        if (!mapIds.isEmpty()) {
            Example example = new Example(TtCostTypeFineEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("id", mapIds.keySet());
            List<TtCostTypeFineEntity> fineEntities = this.ttCostTypeFineService.getFinesByCategoriesCode(example);
            addList.addAll(fineEntities);
        }
        this.ttCostTypeCategoriesFineService.relevanceFine(addList, deleteList, entity);
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtCostTypeCategoriesServiceImpl.class)
    public AjaxJson update(TtCostTypeCategoriesEntity entity, AjaxJson ajaxJson) {
        TtCostTypeFineDetailEntity[] orgTypeEntities;
        this.ttCostTypeCategoriesDao.updateByPrimaryKeySelective(entity);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((CharSequence)entity.getFineIds())) {
            for (String id : entity.getFineIds().split(",")) {
                if (!StringUtil.isNotEmpty((CharSequence)id)) continue;
                map.put(id, id);
            }
        }
        this.relevanceFine(entity, map);
        Example example = new Example(TtCostTypeFineDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("fineCode", (Object)entity.getCategoriesCode());
        this.ttCostTypeFineDetailDao.deleteByExample(example);
        TtCostTypeFineDetailEntity[] entities = (TtCostTypeFineDetailEntity[])JsonPropertyUtil.toObject((String)entity.getOrgJson(), TtCostTypeFineDetailEntity[].class);
        if (entities != null && entities.length > 0) {
            List<TtCostTypeFineDetailEntity> listEntity = Arrays.asList(entities);
            if (CollectionUtil.listNotEmptyNotSizeZero(listEntity)) {
                listEntity.forEach(detail -> {
                    detail.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                    detail.setFineCode(entity.getCategoriesCode());
                    detail.setTypeName("\u5927\u7c7b\u53ef\u9009\u7ec4\u7ec7");
                });
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(listEntity)) {
                this.ttCostTypeFineDetailDao.batchInsertList(listEntity);
            }
        }
        if ((orgTypeEntities = (TtCostTypeFineDetailEntity[])JsonPropertyUtil.toObject((String)entity.getOrgTypeJson(), TtCostTypeFineDetailEntity[].class)) != null && orgTypeEntities.length > 0) {
            List<TtCostTypeFineDetailEntity> listEntity = Arrays.asList(orgTypeEntities);
            listEntity.forEach(detail -> {
                detail.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                detail.setFineCode(entity.getCategoriesCode());
                detail.setTypeName("\u5927\u7c7b\u53ef\u9009\u7ec4\u7ec7\u7c7b\u578b");
            });
            if (CollectionUtil.listNotEmptyNotSizeZero(listEntity)) {
                this.ttCostTypeFineDetailDao.batchInsertList(listEntity);
            }
        }
        this.doExtendJson(entity);
        return ajaxJson;
    }

    @Override
    public void updateBudgetSubjectsName(String budgetSubjectsName, String budgetSubjectsCode) {
        this.ttCostTypeCategoriesDao.updateBudgetSubjectsName(budgetSubjectsName, budgetSubjectsCode);
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtCostTypeCategoriesServiceImpl.class)
    public boolean delete(String id) {
        TtCostTypeCategoriesEntity entity = (TtCostTypeCategoriesEntity)this.ttCostTypeCategoriesDao.selectByPrimaryKey(id);
        int i = this.ttCostTypeCategoriesDao.deleteByPrimaryKey(id);
        if (i > 0) {
            this.relevanceFine(entity, new HashMap<String, String>());
            return true;
        }
        return false;
    }

    @Override
    public List<TtCostTypeCategoriesEntity> findListByCodes(List<String> codes) {
        codes.add("_");
        Example example = new Example(TtCostTypeCategoriesEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("categoriesCode", codes);
        List entities = this.ttCostTypeCategoriesDao.selectByExample(example);
        entities = entities == null ? new ArrayList() : entities;
        return entities;
    }

    @Override
    public List<TtCostTypeFineEntity> findFineListByCodes(List<String> codes) {
        codes.add("_");
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("fineCode", codes);
        List entities = this.ttCostTypeFineDao.selectByExample(example);
        return entities;
    }

    @Override
    public List<TtCostTypeCategoriesEntity> getCategoriesListByBudgetCode(CostTypeCategoriesBudgetVo categoriesBudgetVo) {
        String budgetCode = categoriesBudgetVo.getBudgetCode();
        String orgCode = UserUtils.getUser().getOrgCode();
        TmOrgVo tmOrgVo = (TmOrgVo)this.tmOrgFeign.getOrgByIdOrCode("", orgCode).getObj();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'" + orgCode + "',");
        stringBuffer.append("'" + tmOrgVo.getOrgType() + "'");
        TtFeeBudgetEntity entity = this.ttFeeBudgetService.getEntity(null, budgetCode);
        List<Object> ttCostTypeCategoriesEntities = new ArrayList<TtCostTypeCategoriesEntity>();
        if (entity != null) {
            TtBudgetSubjectsEntity ttBudgetSubjectsEntity = this.ttBudgetSubjectsService.getEntity(null, entity.getBudgetSubjectsCode());
            if (ttBudgetSubjectsEntity == null) {
                throw new BusinessException("\u9884\u7b97\u5bf9\u5e94\u79d1\u76ee\u7f16\u7801:" + entity.getBudgetSubjectsCode() + "\u4e0d\u5b58\u5728");
            }
            Example example = new Example(TtCostTypeCategoriesEntity.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtil.isNotEmpty((CharSequence)ttBudgetSubjectsEntity.getBudgetSubjectsCode())) {
                criteria.andEqualTo("budgetSubjectsCode", (Object)ttBudgetSubjectsEntity.getBudgetSubjectsCode());
            }
            criteria.andCondition("  EXISTS ( select id from tt_cost_type_fine_detail where  fine_code = categories_code and code in ( " + stringBuffer + " ) ) ");
            ttCostTypeCategoriesEntities = this.selectExample(example);
        }
        return ttCostTypeCategoriesEntities;
    }
}

