/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.income.controller;

import com.biz.eisp.api.feign.MdmApiFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.income.dao.TtIncomeBudgetDao;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.budget.used.dao.TtBudgutDetailDao;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.product.TmProductVo;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/ttIncomeBudgetController"})
public class TtIncomeBudgetController {
    private static final Logger log = LoggerFactory.getLogger(TtIncomeBudgetController.class);
    @Autowired
    private MdmApiFeign mdmApiFeign;
    @Autowired
    private TtIncomeBudgetService ttIncomeBudgetService;
    @Autowired
    private TtBudgutDetailDao ttBudgutDetailDao;
    @Autowired
    private TtIncomeBudgetDao ttIncomeBudgetDao;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtIncomeBudgetEntity> getEntity(@RequestParam(value="id", required=false) String id, @RequestParam(value="budgetCode", required=false) String budgetCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtIncomeBudgetEntity entity = this.ttIncomeBudgetService.getEntity(id, budgetCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtIncomeBudgetEntity entity) {
        TmProductVo tmProductVo;
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((CharSequence)entity.getProductLevelId()) && (tmProductVo = (TmProductVo)this.mdmApiFeign.getTmProductEntity(entity.getProductLevelId(), "").getObj()) != null) {
            entity.setProductLevelCode(tmProductVo.getProductCode());
        }
        if (StringUtil.isNotBlank((CharSequence)request.getParameter("clickFunctionId_"))) {
            ThreadLocalUtil.setVal((String)request.getParameter("clickFunctionId_"));
        }
        PageInfo<TtIncomeBudgetEntity> pageInfo = this.ttIncomeBudgetService.getMaiList(entity, (Page)page);
        TtIncomeBudgetEntity sumEntity = new TtIncomeBudgetEntity();
        BigDecimal initAmount = BigDecimal.ZERO;
        BigDecimal saleNum = BigDecimal.ZERO;
        BigDecimal sumWeight = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            for (TtIncomeBudgetEntity incomeBudgetEntity : pageInfo.getList()) {
                BigDecimal entiyInitAmount = incomeBudgetEntity.getInitAmount() != null ? incomeBudgetEntity.getInitAmount() : BigDecimal.ZERO;
                BigDecimal entitySaleNum = StringUtil.isNotEmpty((CharSequence)incomeBudgetEntity.getExtChar1()) ? new BigDecimal(incomeBudgetEntity.getExtChar1()) : BigDecimal.ZERO;
                BigDecimal entityWeight = incomeBudgetEntity.getWeight() != null ? incomeBudgetEntity.getWeight() : BigDecimal.ZERO;
                initAmount = initAmount.add(entiyInitAmount);
                saleNum = saleNum.add(entitySaleNum);
                sumWeight = sumWeight.add(entityWeight);
            }
        }
        sumEntity.setInitAmount(initAmount);
        sumEntity.setExtChar1(saleNum.toString());
        sumEntity.setWeight(sumWeight);
        ArrayList<TtIncomeBudgetEntity> sumList = new ArrayList<TtIncomeBudgetEntity>();
        sumList.add(sumEntity);
        DataGrid dataGrid = new DataGrid(pageInfo);
        dataGrid.setFooter(sumList);
        return dataGrid;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtIncomeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttIncomeBudgetService.update(entity, ajaxJson) : this.ttIncomeBudgetService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public AjaxJson delete(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtIncomeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", Arrays.asList(ids));
        List list = this.ttIncomeBudgetDao.selectByExample(example);
        for (TtIncomeBudgetEntity entity : list) {
            if (!ConstantEnum.bpmStatus.APPROVAL.getValue().equals(entity.getApprovalStatus())) continue;
            ajaxJson.setMsg("\u9884\u7b97:" + entity.getBudgetCode() + "\u6b63\u53d1\u8d77\u53d8\u66f4\u6d41\u7a0b\u5ba1\u6279\uff0c\u4e0d\u80fd\u5220\u9664");
            return ajaxJson;
        }
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttIncomeBudgetService.delete(id, ajaxJson);
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"getSubjectsGroupData"})
    @ResponseBody
    public AjaxJson getSubjectsGroupData(String dictCode) {
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList<String> list = new ArrayList<String>();
        KnlDictDataEntity knlDictDataEntity = DictUtil.getDicData((String)"imcome_group", (String)dictCode);
        List dictListByParentId = null;
        if (knlDictDataEntity != null) {
            dictListByParentId = DictUtil.getDictListByParentId((String)knlDictDataEntity.getId());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(dictListByParentId)) {
            for (KnlDictDataEntity entity : dictListByParentId) {
                if (!StringUtil.isNotEmpty((CharSequence)entity.getDictCode())) continue;
                list.add(entity.getDictCode());
            }
        }
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @PostMapping(value={"updateNew"})
    AjaxJson updateNew(@RequestBody TtIncomeBudgetEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isNotEmpty((CharSequence)entity.getId())) {
            ajaxJson = this.ttIncomeBudgetService.updateNew(entity);
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u7f3a\u5931\u5b9e\u4f53Id");
        }
        return ajaxJson;
    }

    @PostMapping(value={"saveDetail"})
    AjaxJson saveDetail(@RequestBody List<TtBudgutDetailEntity> list) {
        AjaxJson ajaxJson = new AjaxJson();
        for (TtBudgutDetailEntity entity : list) {
            this.ttBudgutDetailDao.insert(entity);
        }
        return ajaxJson;
    }
}

