/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.income.service.impl;

import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.api.feign.TmRoleFeign;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.income.dao.TtIncomeBudgetDao;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.IncomeBudgetSaveOrUpdateValidate;
import com.biz.eisp.budget.income.service.IncomeGetMaiListAuthExpand;
import com.biz.eisp.budget.income.service.IncomeGetMaiListAuthReplaceExpand;
import com.biz.eisp.budget.income.service.TtIncomeBudgetDeleteExpand;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.role.TmRoleVo;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttIncomeBudgetService")
@Transactional
public class TtIncomeBudgetServiceImpl
extends BaseServiceImpl<TtIncomeBudgetEntity>
implements TtIncomeBudgetService {
    private static final Logger log = LoggerFactory.getLogger(TtIncomeBudgetServiceImpl.class);
    @Autowired
    private TtIncomeBudgetDao ttIncomeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private IncomeGetMaiListAuthExpand incomeGetMaiListAuthExpand;
    @Autowired(required=false)
    private IncomeGetMaiListAuthReplaceExpand incomeGetMaiListAuthReplaceExpand;
    @Autowired(required=false)
    private IncomeBudgetSaveOrUpdateValidate incomeBudgetSaveOrUpdateValidate;
    @Autowired(required=false)
    private TtIncomeBudgetDeleteExpand ttIncomeBudgetDeleteExpand;
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TmRoleFeign tmRoleFeign;

    @Override
    public void updateBudgetSubjectsName(String budgetSubjectsName, String budgetSubjectsCode) {
        this.ttIncomeBudgetDao.updateBudgetSubjectsName(budgetSubjectsName, budgetSubjectsCode);
    }

    @Override
    public PageInfo<TtIncomeBudgetEntity> getMaiList(TtIncomeBudgetEntity entity, Page page) {
        StringBuffer buffer = new StringBuffer();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        Object flag = null;
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && null == this.incomeGetMaiListAuthReplaceExpand) {
            List authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authEntities)) {
                buffer.append(" and (");
                List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                    if (!OperationConfig.checAll((List)authobjs)) {
                        String expandSql;
                        Map<Object, Object> auValMap;
                        List items;
                        HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                        authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                        boolean flagOr = false;
                        if (auMap.containsKey("org")) {
                            flagOr = true;
                            buffer.append(" (");
                            items = (List)auMap.get("org");
                            auValMap = new HashMap();
                            auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                            if (auValMap.containsKey("20")) {
                                List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                                String temp = SqlUtil.setSqlIn500((List)codes, (String)"a.budget_depart_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("30")) {
                                buffer.append("  a.budget_depart_code = '" + userRedis.getOrgCode() + "' ");
                            }
                            buffer.append(")");
                        }
                        if (auMap.containsKey("customer")) {
                            String temp;
                            List<String> custCodes;
                            List customerEntities;
                            if (flagOr) {
                                buffer.append(" or ");
                            }
                            flagOr = true;
                            buffer.append(" (");
                            items = (List)auMap.get("customer");
                            auValMap = new HashMap();
                            auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                            if (auValMap.containsKey("20")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrgDown(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                                custCodes = new ArrayList<String>();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("30")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrg(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                                custCodes = new ArrayList();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("40")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPosDown(userRedis.getPosId(), userRedis.getPosCode()), (boolean)true);
                                custCodes = new ArrayList();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("50")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPos(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                                custCodes = new ArrayList();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            }
                            buffer.append(")");
                        }
                        if (this.incomeGetMaiListAuthExpand != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.incomeGetMaiListAuthExpand.getMaiListAuth(auMap, userRedis, flagOr, buffer)))) {
                            buffer.append(expandSql);
                        }
                    } else {
                        buffer.append(" 1=1");
                    }
                } else {
                    buffer.append("1=2");
                }
                buffer.append(" ) ");
            }
        } else if (null != this.incomeGetMaiListAuthReplaceExpand) {
            buffer.append(this.incomeGetMaiListAuthReplaceExpand.getMaiListAuth(entity, page));
        }
        if (userRedis != null) {
            Map dictMap = DictUtil.getDictMap((String)"buget_business_role");
            List positionVoList = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.getUserPositons(userRedis.getUsername(), userRedis.getId()));
            log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650:\u804c\u4f4d\u96c6\u5408" + positionVoList.toString() + "\u3010userName=" + userRedis.getUsername() + "<><>userId=" + userRedis.getId() + "\u3011");
            if (!dictMap.isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)positionVoList)) {
                ArrayList<String> posCodes = new ArrayList<String>();
                block0: for (TmPositionVo x : positionVoList) {
                    List roleVoList = ApiResultUtil.listResult((AjaxJson)this.tmRoleFeign.getRolesByUser(userRedis.getId(), userRedis.getUsername()));
                    log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650\uff1a\u89d2\u8272\u96c6\u5408" + roleVoList.toString());
                    for (TmRoleVo vo : roleVoList) {
                        KnlDictDataEntity dicEntity = (KnlDictDataEntity)dictMap.get(vo.getRoleCode());
                        if (null == dicEntity) continue;
                        posCodes.add(x.getPositionCode());
                        continue block0;
                    }
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(posCodes)) {
                    List customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPosCodes(posCodes));
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                        List custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                        buffer.append(" and ");
                        buffer.append(SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true));
                        log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650\uff1a\u5bf9\u63a5\u5ba2\u6237" + custCodes.toString());
                    } else {
                        log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650\uff1aelse");
                        if (buffer.length() == 0) {
                            buffer.append("and a.cust_code is null");
                        }
                    }
                }
            }
        }
        String aUsql = buffer.toString();
        log.error("\u6743\u9650\u9644\u52a0sql\uff1a" + aUsql);
        return PageAutoHelperUtil.generatePage(() -> this.ttIncomeBudgetDao.getMaiList(entity, aUsql), (Page)page);
    }

    @Override
    public List<TtIncomeBudgetEntity> sumAmount(TtIncomeBudgetEntity entity, Page page) {
        StringBuffer buffer = new StringBuffer();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        Object flag = null;
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && null == this.incomeGetMaiListAuthReplaceExpand) {
            List authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authEntities)) {
                buffer.append(" and (");
                List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                    if (!OperationConfig.checAll((List)authobjs)) {
                        String expandSql;
                        Map<Object, Object> auValMap;
                        List items;
                        HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                        authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                        boolean flagOr = false;
                        if (auMap.containsKey("org")) {
                            flagOr = true;
                            buffer.append(" (");
                            items = (List)auMap.get("org");
                            auValMap = new HashMap();
                            auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                            if (auValMap.containsKey("20")) {
                                List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                                String temp = SqlUtil.setSqlIn500((List)codes, (String)"a.budget_depart_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("30")) {
                                buffer.append("  a.budget_depart_code = '" + userRedis.getOrgCode() + "' ");
                            }
                            buffer.append(")");
                        }
                        if (auMap.containsKey("customer")) {
                            String temp;
                            List<String> custCodes;
                            List customerEntities;
                            if (flagOr) {
                                buffer.append(" or ");
                            }
                            flagOr = true;
                            buffer.append(" (");
                            items = (List)auMap.get("customer");
                            auValMap = new HashMap();
                            auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                            if (auValMap.containsKey("20")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrgDown(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                                custCodes = new ArrayList<String>();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("30")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrg(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                                custCodes = new ArrayList();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("40")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPosDown(userRedis.getPosId(), userRedis.getPosCode()), (boolean)true);
                                custCodes = new ArrayList();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            } else if (auValMap.containsKey("50")) {
                                customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPos(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                                custCodes = new ArrayList();
                                if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                    custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                                } else {
                                    custCodes.add("_");
                                }
                                temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                                buffer.append(temp);
                            }
                            buffer.append(")");
                        }
                        if (this.incomeGetMaiListAuthExpand != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.incomeGetMaiListAuthExpand.getMaiListAuth(auMap, userRedis, flagOr, buffer)))) {
                            buffer.append(expandSql);
                        }
                    } else {
                        buffer.append(" 1=1");
                    }
                } else {
                    buffer.append("1=2");
                }
                buffer.append(" ) ");
            }
        } else if (null != this.incomeGetMaiListAuthReplaceExpand) {
            buffer.append(this.incomeGetMaiListAuthReplaceExpand.getMaiListAuth(entity, page));
        }
        if (userRedis != null) {
            Map dictMap = DictUtil.getDictMap((String)"buget_business_role");
            List positionVoList = ApiResultUtil.listResult((AjaxJson)this.tmPositionFeign.getUserPositons(userRedis.getUsername(), userRedis.getId()));
            log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650:\u804c\u4f4d\u96c6\u5408" + positionVoList.toString() + "\u3010userName=" + userRedis.getUsername() + "<><>userId=" + userRedis.getId() + "\u3011");
            if (!dictMap.isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)positionVoList)) {
                ArrayList<String> posCodes = new ArrayList<String>();
                block0: for (TmPositionVo x : positionVoList) {
                    List roleVoList = ApiResultUtil.listResult((AjaxJson)this.tmRoleFeign.getRolesByUser(userRedis.getId(), userRedis.getUsername()));
                    log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650\uff1a\u89d2\u8272\u96c6\u5408" + roleVoList.toString());
                    for (TmRoleVo vo : roleVoList) {
                        KnlDictDataEntity dicEntity = (KnlDictDataEntity)dictMap.get(vo.getRoleCode());
                        if (null == dicEntity) continue;
                        posCodes.add(x.getPositionCode());
                        continue block0;
                    }
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(posCodes)) {
                    List customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPosCodes(posCodes));
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                        List custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                        buffer.append(" and ");
                        buffer.append(SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true));
                        log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650\uff1a\u5bf9\u63a5\u5ba2\u6237" + custCodes.toString());
                    } else {
                        log.error("\u4e1a\u52a1\u5458\u7279\u6b8a\u6570\u636e\u6743\u9650\uff1aelse");
                        if (buffer.length() == 0) {
                            buffer.append("and a.cust_code is null");
                        }
                    }
                }
            }
        }
        String aUsql = buffer.toString();
        log.error("\u6743\u9650\u9644\u52a0sql\uff1a" + aUsql);
        List<TtIncomeBudgetEntity> sumAmount = this.ttIncomeBudgetDao.sumAmount(entity, aUsql);
        return sumAmount;
    }

    @Override
    public TtIncomeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtIncomeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttIncomeBudgetDao.selectByExample(example)))) {
            return (TtIncomeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson update(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        if (this.incomeBudgetSaveOrUpdateValidate != null) {
            ajaxJson = this.incomeBudgetSaveOrUpdateValidate.validate(entity);
        }
        if (ajaxJson.isSuccess()) {
            this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
            if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
                this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson updateNew(TtIncomeBudgetEntity entity) {
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        return new AjaxJson();
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtIncomeBudgetServiceImpl.class)
    public AjaxJson save(TtIncomeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (this.incomeBudgetSaveOrUpdateValidate != null) {
            ajaxJson = this.incomeBudgetSaveOrUpdateValidate.validate(entity);
        }
        if (ajaxJson.isSuccess()) {
            entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.income_budget.name()));
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            entity.setIniExtChar1(entity.getExtChar1());
            entity.setIniSaleIncome(entity.getSaleIncome());
            entity.setIniBookedAmount(entity.getBookedAmount());
            entity.setIniBookedIncome(entity.getBookedInCome());
            entity.setIniSaleDiscountAmount(entity.getSaleDiscountAmount());
            entity.setIniSaleDiscountNoRate(entity.getSaleDiscountNoRate());
            entity.setIniWeight(entity.getWeight());
            entity.setApprovalStatus(ConstantEnum.bpmStatus.COMMIT.getValue());
            this.ttIncomeBudgetDao.insertSelective(entity);
            this.ttBudgutDetailService.incomeFeeBudgutDetail(entity.getBudgetCode(), ConstantEnum.BudgetUesdTypeEnum.INIT.getValue(), entity.getInitAmount(), "\u65b0\u589e");
            if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
                this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
            }
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        if (Objects.nonNull(this.ttIncomeBudgetDeleteExpand)) {
            return this.ttIncomeBudgetDeleteExpand.delete(id, ajaxJson);
        }
        TtIncomeBudgetEntity entity = (TtIncomeBudgetEntity)this.ttIncomeBudgetDao.selectByPrimaryKey(id);
        if (ConstantEnum.bpmStatus.APPROVAL.getValue().equals(entity.getApprovalStatus())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8be5\u9884\u7b97\u53d1\u8d77\u53d8\u66f4\u5ba1\u6279\u4e2d,\u4e0d\u80fd\u5220\u9664");
            return ajaxJson;
        }
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }
}

