/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BUDGET-\u9884\u7b97\u79d1\u76ee"}, description="BUDGET-\u9884\u7b97\u79d1\u76ee")
@RestController
@RequestMapping(value={"/ttBudgetSubjectsController"})
public class TtBudgetSubjectsController {
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtBudgetSubjectsEntity> getEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtBudgetSubjectsEntity ttBudgetSubjectsEntity = this.ttBudgetSubjectsService.getEntity(id, null);
        ajaxJson.setObj((Object)ttBudgetSubjectsEntity);
        return ajaxJson;
    }

    @GetMapping(value={"getEntityByIdOrCode"})
    public AjaxJson<TtBudgetSubjectsEntity> getEntityByIdOrCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="budgetSubjectsCode", required=false) String budgetSubjectsCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtBudgetSubjectsEntity ttBudgetSubjectsEntity = this.ttBudgetSubjectsService.getEntity(id, budgetSubjectsCode);
        ajaxJson.setObj((Object)ttBudgetSubjectsEntity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtBudgetSubjectsEntity ttBudgetSubjectsEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtBudgetSubjectsEntity> pageInfo = this.ttBudgetSubjectsService.getMaiList(ttBudgetSubjectsEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getList"})
    public DataGrid getList(HttpServletRequest request, TtBudgetSubjectsEntity entity) {
        EuPage page = new EuPage(request);
        entity.setEnableStatus("009");
        PageInfo<TtBudgetSubjectsEntity> pageInfo = this.ttBudgetSubjectsService.getMaiList(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getAccountMaiListPage"})
    @ResponseBody
    public List<TtBudgetSubjectsEntity> getAccountMaiListPage(HttpServletRequest request, TtBudgetSubjectsEntity ttBudgetSubjectsEntity, String applyBudgetSubjectsCode) {
        List<TtBudgetSubjectsEntity> list = this.ttBudgetSubjectsService.getAccountMaiList(ttBudgetSubjectsEntity, applyBudgetSubjectsCode);
        return list;
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtBudgetSubjectsEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttBudgetSubjectsService.update(entity, ajaxJson) : this.ttBudgetSubjectsService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"stop"})
    @ResponseBody
    public AjaxJson stop(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttBudgetSubjectsService.startOrStop(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"deleteSubject"})
    public AjaxJson deleteSubject(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttBudgetSubjectsService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"start"})
    @ResponseBody
    public AjaxJson start(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttBudgetSubjectsService.startOrStop(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"getListByCodes"})
    public AjaxJson<TtBudgetSubjectsEntity> getListByCodes(@RequestParam(value="budgetSubjectsCodes") List<String> budgetSubjectsCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtBudgetSubjectsEntity> list = this.ttBudgetSubjectsService.getBudgetSubjects(budgetSubjectsCodes);
        ajaxJson.setList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u68c0\u67e5\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u662f\u5426\u5b58\u5728\u91cd\u590d", notes="\u6839\u636e\u804c\u4f4dID\u6216\u8005\u804c\u4f4d\u7f16\u7801\u83b7\u53d6\u804c\u4f4d\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"checkBudgetSubjectsCodeRepeat"})
    public ValidForm checkBudgetSubjectsCodeRepeat(String id, String param) {
        ValidForm validForm = new ValidForm();
        try {
            validForm = this.ttBudgetSubjectsService.checkBudgetSubjectsCodeRepeat(id, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            validForm.setStatus("N");
        }
        return validForm;
    }
}

