/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.entity.BaseEntity;
import com.biz.eisp.base.utils.Globals;
import com.biz.eisp.base.utils.SysParamUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDao;
import com.biz.eisp.budget.config.dao.TtCostTypeFineDetailDao;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.CostFinegetActFineListExtend;
import com.biz.eisp.budget.config.service.TtCostTypeFineCodeExtend;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.config.service.TypeFinegetActFinesListByCatgeExtend;
import com.biz.eisp.budget.config.vo.ActFineVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.parameter.entity.KnlParameterManageEntity;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.biz.eisp.util.ReflectionUtils;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttCostTypeFineService")
@Transactional
public class TtCostTypeFineServiceImpl
extends BaseServiceImpl<TtCostTypeFineEntity>
implements TtCostTypeFineService {
    @Autowired
    private TtCostTypeFineDao ttCostTypeFineDao;
    @Autowired
    private TtCostTypeFineDetailDao ttCostTypeFineDetailDao;
    @Autowired(required=false)
    private TypeFinegetActFinesListByCatgeExtend typeFinegetActFinesListByCatgeExtend;
    @Autowired(required=false)
    private CostFinegetActFineListExtend costFinegetActFineListExtend;
    @Autowired(required=false)
    private TtCostTypeFineCodeExtend ttCostTypeFineCodeExtend;

    @Override
    public PageInfo<TtCostTypeFineEntity> getMaiList(TtCostTypeFineEntity ttCostTypeFineEntity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getMaiList(ttCostTypeFineEntity), (Page)page);
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getSelectFinePage(TtCostTypeFineEntity fineEntity, Page page) {
        KnlParameterManageEntity entity = SysParamUtil.getPatamByCode((String)"cost_type_fine");
        String multipleChoice = Globals.Y;
        if (entity != null) {
            if (StringUtil.isNotEmpty((CharSequence)entity.getParameterValue())) {
                multipleChoice = entity.getParameterValue();
            } else if (StringUtil.isNotEmpty((CharSequence)entity.getDefaultValue())) {
                multipleChoice = entity.getDefaultValue();
            }
        }
        fineEntity.setMultipleChoice(multipleChoice);
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getSelectFinePage(fineEntity), (Page)page);
    }

    @Override
    public TtCostTypeFineEntity getFineEntity(String id, String fineCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)fineCode)) {
            return null;
        }
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)fineCode)) {
            criteria.andEqualTo("fineCode", (Object)fineCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttCostTypeFineDao.selectByExample(example)))) {
            return (TtCostTypeFineEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<TtCostTypeFineEntity> getFineEntityByActMethodCodes(List<String> actMethodCodes) {
        if (CollectionUtils.isEmpty(actMethodCodes)) {
            return Lists.newArrayList();
        }
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("actMethodCode", actMethodCodes);
        return this.ttCostTypeFineDao.selectByExample(example);
    }

    @Override
    public AjaxJson deleteFineByCategories(String categoriesCode, AjaxJson ajaxJson) {
        Example example = new Example(TtCostTypeFineEntity.class);
        Example.Criteria criteria = example.createCriteria();
        TtCostTypeFineEntity ttCostTypeFineEntity = new TtCostTypeFineEntity();
        ttCostTypeFineEntity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        criteria.andEqualTo("categoriesCode", (Object)categoriesCode);
        this.ttCostTypeFineDao.updateByExampleSelective(ttCostTypeFineEntity, example);
        return ajaxJson;
    }

    @Override
    public AjaxJson stopOrStartFine(String id, AjaxJson ajaxJson, String type) {
        TtCostTypeFineEntity ttCostTypeFineEntity = new TtCostTypeFineEntity();
        ttCostTypeFineEntity.setId(id);
        ttCostTypeFineEntity.setEnableStatus(type);
        this.ttCostTypeFineDao.updateByPrimaryKeySelective(ttCostTypeFineEntity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtCostTypeFineServiceImpl.class)
    public AjaxJson save(TtCostTypeFineEntity entity, AjaxJson ajaxJson) {
        if (Objects.nonNull(this.ttCostTypeFineCodeExtend) && this.ttCostTypeFineCodeExtend.customBuildCode()) {
            entity.setFineCode(entity.getFineCode());
        } else {
            entity.setFineCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.act_fine.name()));
        }
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttCostTypeFineDao.insertSelective(entity);
        TtCostTypeFineEntity newEntity = (TtCostTypeFineEntity)this.ttCostTypeFineDao.selectByPrimaryKey(entity.getId());
        this.saveOrUpdateFineExpand(newEntity, entity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtCostTypeFineServiceImpl.class)
    public AjaxJson update(TtCostTypeFineEntity entity, AjaxJson ajaxJson) {
        TtCostTypeFineEntity oldEntity = (TtCostTypeFineEntity)this.ttCostTypeFineDao.selectByPrimaryKey(entity.getId());
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)oldEntity);
            oldEntity.setActReleaseNeed(entity.getActReleaseNeed());
            oldEntity.setActCollectNeet(entity.getActCollectNeet());
            oldEntity.setAuditMaterial(entity.getAuditMaterial());
            oldEntity.setPayType(entity.getPayType());
            oldEntity.setExtraAuditRatio(entity.getExtraAuditRatio());
            oldEntity.setAuditValidity(entity.getAuditValidity());
            oldEntity.setExtChar1(entity.getExtChar1());
            oldEntity.setExtChar2(entity.getExtChar2());
            oldEntity.setExtChar3(entity.getExtChar3());
            oldEntity.setExtChar4(entity.getExtChar4());
            oldEntity.setExtChar5(entity.getExtChar5());
            oldEntity.setUpdateBy(null);
            oldEntity.setUpdateDate(null);
            oldEntity.setUpdateName(null);
            this.ttCostTypeFineDao.updateByPrimaryKey(oldEntity);
        }
        catch (Exception e) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25");
        }
        this.saveOrUpdateFineExpand(oldEntity, entity);
        return ajaxJson;
    }

    public void saveOrUpdateFineExpand(TtCostTypeFineEntity newEntity, TtCostTypeFineEntity entity) {
        String fineCode = newEntity.getFineCode();
        if (StringUtil.isEmpty((String)fineCode)) {
            return;
        }
        Map mapType = DictUtil.getDictMap((String)"act_expand_type");
        Example exampleAll = new Example(TtCostTypeFineDetailEntity.class);
        Example.Criteria criteriaAll = exampleAll.createCriteria();
        criteriaAll.andEqualTo("fineCode", (Object)fineCode);
        List oldDetails = this.ttCostTypeFineDetailDao.selectByExample(exampleAll);
        HashMap detailMap = new HashMap();
        oldDetails.stream().collect(Collectors.groupingBy(TtCostTypeFineDetailEntity::getType, Collectors.toList())).forEach((type, list) -> detailMap.put(type, list));
        ArrayList<TtCostTypeFineDetailEntity> deleteItems = new ArrayList<TtCostTypeFineDetailEntity>();
        ArrayList noDoList = new ArrayList();
        ArrayList<TtCostTypeFineDetailEntity> addList = new ArrayList<TtCostTypeFineDetailEntity>();
        mapType.forEach((keyMap, valTemp) -> {
            String formVals;
            String key = keyMap.toString();
            KnlDictDataEntity val = (KnlDictDataEntity)valTemp;
            Object value = ReflectionUtils.getFieldValue((Object)entity, (String)val.getDictValue());
            String string = formVals = StringUtil.isNotEmpty((Object)value) ? value.toString() : "";
            if (StringUtil.isEmpty((String)formVals)) {
                if (StringUtil.isNotEmpty(detailMap.get(key))) {
                    deleteItems.addAll((Collection)detailMap.get(key));
                }
            } else {
                String[] formValArry = formVals.split(",");
                Map<String, String> mapTemp = this.changeData(formValArry);
                List oldListTemp = (List)detailMap.get(key);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)oldListTemp)) {
                    oldListTemp.forEach(item -> {
                        if (mapTemp.containsKey(item.getType())) {
                            noDoList.add(item);
                            mapTemp.remove(item.getType());
                        } else {
                            deleteItems.add((TtCostTypeFineDetailEntity)item);
                        }
                    });
                }
                if (!mapTemp.isEmpty()) {
                    List<TtCostTypeFineDetailEntity> tempAdd = this.createEntity(mapTemp, fineCode, val);
                    addList.addAll(tempAdd);
                }
            }
        });
        this.saveOrUpdateData(deleteItems, addList);
    }

    private void saveOrUpdateData(List<TtCostTypeFineDetailEntity> deleteItems, List<TtCostTypeFineDetailEntity> addList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteItems)) {
            Example exampleDelete = new Example(TtCostTypeFineDetailEntity.class);
            Example.Criteria criteria = exampleDelete.createCriteria();
            List ids = deleteItems.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteria.andIn("id", ids);
            this.ttCostTypeFineDetailDao.deleteByExample(exampleDelete);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            addList.forEach(itme -> this.ttCostTypeFineDetailDao.insertSelective(itme));
        }
    }

    private List<TtCostTypeFineDetailEntity> createEntity(Map<String, String> mapTemp, String fineCode, KnlDictDataEntity typeDic) {
        ArrayList<TtCostTypeFineDetailEntity> adds = new ArrayList<TtCostTypeFineDetailEntity>();
        Map mapType = DictUtil.getDictMap((String)typeDic.getDictCode());
        HashMap mapTypeNew = new HashMap();
        mapType.forEach((k, v) -> mapTypeNew.put(k.toString(), v.toString()));
        mapTemp.forEach((k, v) -> {
            KnlDictDataEntity dictDataEntity = (KnlDictDataEntity)mapType.get(k);
            TtCostTypeFineDetailEntity entity = new TtCostTypeFineDetailEntity();
            entity.setFineCode(fineCode);
            entity.setType(typeDic.getDictCode());
            entity.setTypeName(typeDic.getDictValue());
            entity.setCode(k);
            entity.setName(dictDataEntity.getDictValue());
            entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            adds.add(entity);
        });
        return adds;
    }

    private Map<String, String> changeData(String[] formValArry) {
        HashMap<String, String> formValMap = new HashMap<String, String>();
        for (String formVa : formValArry) {
            if (StringUtil.isEmpty((Object)formValArry)) continue;
            formValMap.put(formVa, formVa);
        }
        return formValMap;
    }

    @Override
    public List<TtCostTypeFineEntity> getFinesByCategoriesCode(String categoriesCode) {
        if (StringUtil.isEmpty((String)categoriesCode)) {
            return new ArrayList<TtCostTypeFineEntity>();
        }
        return this.ttCostTypeFineDao.getFinesByCategoriesCode(categoriesCode);
    }

    @Override
    public List<TtCostTypeFineEntity> getFinesByCategoriesCode(Example example) {
        return this.ttCostTypeFineDao.selectByExample(example);
    }

    @Override
    public Map<String, List<TtCostTypeFineDetailEntity>> findCostTypeCons(String fineCode, List<String> cons) {
        Example example = new Example(TtCostTypeFineDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("fineCode", (Object)fineCode);
        criteria.andIn("type", cons);
        List listEntity = this.ttCostTypeFineDetailDao.selectByExample(example);
        HashMap<String, List<TtCostTypeFineDetailEntity>> typeListMap = new HashMap<String, List<TtCostTypeFineDetailEntity>>();
        listEntity.stream().collect(Collectors.groupingBy(TtCostTypeFineDetailEntity::getType, Collectors.toList())).forEach((type, list) -> typeListMap.put((String)type, (List<TtCostTypeFineDetailEntity>)list));
        return typeListMap;
    }

    @Override
    public Boolean checkProductByFineCode(List<String> codes) {
        boolean flag = false;
        block0: for (String code : codes) {
            if (flag) break;
            ArrayList<String> types = new ArrayList<String>();
            String act_name = ConstantEnum.FIELD_NAME.act_release_need.name();
            types.add(act_name);
            Map<String, List<TtCostTypeFineDetailEntity>> map = this.findCostTypeCons(code, types);
            if (map == null || !map.containsKey(act_name) || !CollectionUtil.listNotEmptyNotSizeZero(map.get(act_name))) continue;
            for (TtCostTypeFineDetailEntity item : map.get(act_name)) {
                if (!StringUtils.equals((CharSequence)item.getCode(), (CharSequence)ConstantEnum.FIELD_NAME.product.name())) continue;
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getActFinesList(TtCostTypeFineEntity ttCostTypeFineEntity, List<String> codes, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getActFinesList(ttCostTypeFineEntity, codes), (Page)page);
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getActFinesListByCatge(TtCostTypeFineEntity ttCostTypeFineEntity, Page page) {
        UserRedis userRedis = UserUtils.getUser();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.typeFinegetActFinesListByCatgeExtend != null) {
            String sql = this.typeFinegetActFinesListByCatgeExtend.getActFinesListByCatge(ttCostTypeFineEntity, userRedis);
            stringBuffer.append(sql);
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getActFinesListByCatge(ttCostTypeFineEntity, stringBuffer.toString()), (Page)page);
    }

    @Override
    public boolean delete(String id) {
        int i = this.ttCostTypeFineDao.deleteByPrimaryKey(id);
        return i > 0;
    }

    @Override
    public List<TtCostTypeFineEntity> getActFineList(ActFineVo actFineVo) {
        String categoriesCode = actFineVo.getCategoriesCode();
        List<TtCostTypeFineEntity> result = new ArrayList<TtCostTypeFineEntity>();
        if (StringUtil.isEmpty((String)categoriesCode)) {
            return result;
        }
        List<String> categoriesCodes = Arrays.asList(categoriesCode.split(","));
        actFineVo.setCategoriesCodes(categoriesCodes);
        result = this.costFinegetActFineListExtend != null ? this.costFinegetActFineListExtend.getActFineByCategoriesCodesList(actFineVo) : this.getActFineByCategoriesCodesList(actFineVo);
        return result;
    }

    @Override
    public List<TtCostTypeFineEntity> getActFineByCategoriesCodesList(ActFineVo actFineVo) {
        return this.ttCostTypeFineDao.getActFineByCategoriesCodesList(actFineVo, actFineVo.getCategoriesCodes());
    }

    @Override
    public PageInfo<TtCostTypeFineEntity> getTtCostTypeFineEntityListByBudgetSubjectsCodes(TtCostTypeFineEntity costTypeFineEntity, List<String> budgetSubjectsCodes, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttCostTypeFineDao.getTtCostTypeFineEntityListByBudgetSubjectsCodes(costTypeFineEntity, budgetSubjectsCodes), (Page)page);
    }
}

