drop table if exists temp_tt_cost_type_fine_import;

create table temp_tt_cost_type_fine_import
(
  code      text        null comment '编码;编码',
  type      varchar(32) null comment '类型编码;类型编码',
  fine_code varchar(32) null comment '活动细类编号;活动细类编号'
);
insert into temp_tt_cost_type_fine_import (code, type, fine_code)
select GROUP_CONCAT(b.dict_value) code, a.type, fine_code
from tt_cost_type_fine_detail a
       left join bizeispbase.knl_dict_data b on (a.code = b.dict_code and a.type = b.dict_type_code)
GROUP BY fine_code, a.type;


delete
from temp_tt_cost_type_fine_import
where fine_code is null
   or type is null;

select a.fine_code                                             细类编码,
       a.fine_name                                          as 细类名称,
       b.categories_code                                       大类编码,
       b.categories_name                                       大类名称,
       c.dict_value                                         as 活动方式,
       d.dict_value                                         as 是否人工核销,
       extra_Audit_Ratio                                    as 超额核销比例,
       e.code                                               as 超额核销控制,
       audit_validity                                          核销有效期,
       f.code                                               as 表单类型,
       g.dict_value                                            多次核销,
       h.code                                                  支付方式,
       i.code                                                  活动发布需求,
       case when is_Control_Ter = '1' then '是' else '否' end as 是否控制门店金额,
       j.code                                               as 采集要求,
       k.code                                               as 核销资料,
       a.ext_Char1                                          as 财务四级科目编号,
       a.ext_char2                                          as 费用池条件类型
from tt_cost_type_fine a
       left join tt_cost_type_categories_fine abf on a.fine_code = abf.fine_code
       left join tt_cost_type_categories b on