/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.attachment.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.attachment.dao.BudgetAttachmentDao;
import com.biz.eisp.budget.attachment.entity.BudgetAttachmentEntity;
import com.biz.eisp.budget.attachment.service.BudgetAttachmentService;
import com.biz.eisp.budget.attachment.vo.BudgetAttachBusVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.upload.KnlDownAttachmentFeign;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class BudgetAttachmentServiceImpl
extends BaseServiceImpl<BudgetAttachmentEntity>
implements BudgetAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(BudgetAttachmentServiceImpl.class);
    @Autowired
    private BudgetAttachmentDao budgetAttachmentDao;
    @Autowired
    private KnlDownAttachmentFeign downAttachmentFeign;

    @Override
    public AjaxJson saveUploadFile(BudgetAttachBusVo vo) {
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        json.setMsg("\u4e0a\u4f20\u6210\u529f");
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)vo.getList())) {
            return json;
        }
        List list = vo.getList();
        int num = 0;
        try {
            BudgetAttachmentEntity param = new BudgetAttachmentEntity();
            param.setBusinessKey(vo.getBusinessKey());
            List old = this.budgetAttachmentDao.select(param);
            old.forEach(e -> this.budgetAttachmentDao.delete(e));
            list.forEach(e -> {
                e.setBusinessKey(vo.getBusinessKey());
                e.setAttachmentType(vo.getAttachmentType());
                e.setStatus(ConstantEnum.StatusEnum.NEW.getValue());
            });
            num = this.budgetAttachmentDao.insertList(list);
        }
        catch (Exception e2) {
            log.error("", (Throwable)e2);
            json.setSuccess(false);
            json.setMsg("\u4fdd\u5b58\u5f02\u5e38");
        }
        if (num != list.size()) {
            json.setSuccess(false);
            json.setMsg("\u4e0a\u4f20\u5931\u8d25");
        }
        return json;
    }

    @Override
    public AjaxJson removeUploadFile(String id) {
        AjaxJson json = new AjaxJson();
        json.setSuccess(true);
        json.setMsg("\u5220\u9664\u6210\u529f");
        BudgetAttachmentEntity entity = (BudgetAttachmentEntity)this.budgetAttachmentDao.selectByPrimaryKey(id);
        if (StringUtil.isEmpty((Object)entity)) {
            return json;
        }
        int num = 0;
        try {
            num = this.budgetAttachmentDao.delete(entity);
            this.downAttachmentFeign.removeDownAttach(id);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            json.setSuccess(false);
            json.setMsg("\u64cd\u4f5c\u5f02\u5e38");
        }
        if (num != 1) {
            json.setSuccess(false);
            json.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return json;
    }

    @Override
    public PageInfo<BudgetAttachmentEntity> findAttachmentList(String businessKey, Page page) {
        Example example = new Example(BudgetAttachmentEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("businessKey", (Object)businessKey);
        criteria.andEqualTo("status", (Object)ConstantEnum.StatusEnum.NEW.getValue());
        return PageAutoHelperUtil.generatePage(() -> this.budgetAttachmentDao.selectByExample(example), (Page)page);
    }
}

