/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.collectioninfo.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.budget.collectioninfo.entity.TtCollectionInfoEntity;
import com.biz.eisp.budget.collectioninfo.service.TtCollectionInfoService;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttCollectionInfoController"})
public class TtCollectionInfoController
extends ImpExpController {
    private static final Logger log = LoggerFactory.getLogger(TtCollectionInfoController.class);
    @Autowired
    private TtCollectionInfoService ttCollectionInfoService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtCollectionInfoEntity> getEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtCollectionInfoEntity entity = this.ttCollectionInfoService.getEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtCollectionInfoEntity ttCollectionInfoEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCollectionInfoEntity> pageInfo = this.ttCollectionInfoService.getMaiList(ttCollectionInfoEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdate(HttpServletRequest request, TtCollectionInfoEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isNotEmpty((CharSequence)entity.getId()) ? this.ttCollectionInfoService.update(entity, ajaxJson) : this.ttCollectionInfoService.save(entity, ajaxJson);
        return ajaxJson;
    }

    @RequestMapping(value={"getCollectionMaterialDict"})
    @ResponseBody
    public List<KnlDictDataEntity> getCollectionMaterialDict(HttpServletRequest request) {
        List knlDictDataEntitys = DictUtil.getDictList((String)"act_collect_neet");
        return knlDictDataEntitys;
    }

    @ResponseBody
    @RequestMapping(value={"delete"})
    public AjaxJson deleteTtAct(HttpServletRequest request, String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttCollectionInfoService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        return new AjaxJson();
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        return new AjaxJson();
    }
}

