/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.budget.config.dao.TtBudgetSubjectsDao;
import com.biz.eisp.budget.config.dao.TtBudgetSubjectsDetailDao;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsDetailEntity;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsDeleteExpand;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttBudgetSubjectsService")
@Transactional
public class TtBudgetSubjectsServiceImpl
extends BaseServiceImpl<TtBudgetSubjectsEntity>
implements TtBudgetSubjectsService {
    @Autowired
    private TtBudgetSubjectsDao ttBudgetSubjectsDao;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;
    @Autowired
    private TtIncomeBudgetService ttIncomeBudgetService;
    @Autowired
    private TtBudgetSubjectsDetailDao ttBudgetSubjectsDetailDao;
    @Autowired(required=false)
    private TtBudgetSubjectsDeleteExpand ttBudgetSubjectsDeleteExpand;

    @Override
    public PageInfo<TtBudgetSubjectsEntity> getMaiList(TtBudgetSubjectsEntity entity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.getTtBudgetSubjectsList(entity), (Page)page);
    }

    @Override
    public List<TtBudgetSubjectsEntity> getTtBudgetSubjectsList(TtBudgetSubjectsEntity entity) {
        Example example = new Example(TtBudgetSubjectsEntity.class);
        example.orderBy("budgetSubjectsCode");
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            entity.setEnableStatus(StringUtil.remove((String)entity.getEnableStatus(), (String)","));
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsCode())) {
            criteria.andLike("budgetSubjectsCode", "%" + entity.getBudgetSubjectsCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsName())) {
            criteria.andLike("budgetSubjectsName", "%" + entity.getBudgetSubjectsName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsTypeCode())) {
            criteria.andEqualTo("subjectsTypeCode", (Object)entity.getSubjectsTypeCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsTypeName())) {
            criteria.andLike("subjectsTypeName", "%" + entity.getSubjectsTypeName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsGroupCode())) {
            criteria.andEqualTo("subjectsGroupCode", (Object)entity.getSubjectsGroupCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getSubjectsGroupName())) {
            criteria.andLike("subjectsGroupName", "%" + entity.getSubjectsGroupName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getBudgetSubjectsErpCode())) {
            criteria.andLike("budgetSubjectsErpCode", "%" + entity.getBudgetSubjectsErpCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getIsBudgetControl())) {
            criteria.andEqualTo("isBudgetControl", (Object)entity.getIsBudgetControl());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getIsFiscalContinue())) {
            criteria.andEqualTo("isFiscalContinue", (Object)entity.getIsFiscalContinue());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getNotes())) {
            criteria.andLike("notes", "%" + entity.getNotes() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCreateName())) {
            criteria.andLike("createName", "%" + entity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getUpdateName())) {
            criteria.andLike("updateName", "%" + entity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + entity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + entity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + entity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + entity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + entity.getExtChar5() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar6())) {
            criteria.andLike("extChar6", "%" + entity.getExtChar6() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar7())) {
            criteria.andLike("extChar7", "%" + entity.getExtChar7() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar8())) {
            criteria.andLike("extChar8", "%" + entity.getExtChar8() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar9())) {
            criteria.andLike("extChar9", "%" + entity.getExtChar9() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar10())) {
            criteria.andLike("extChar10", "%" + entity.getExtChar10() + "%");
        }
        return this.ttBudgetSubjectsDao.selectByExample(example);
    }

    @Override
    public List<TtBudgetSubjectsEntity> getAccountMaiList(TtBudgetSubjectsEntity entity, String applyBudgetSubjectsCode) {
        List<TtBudgetSubjectsEntity> list = this.getTtBudgetSubjectsList(entity);
        Iterator<TtBudgetSubjectsEntity> it = list.iterator();
        while (it.hasNext()) {
            TtBudgetSubjectsEntity obj = it.next();
            if (!StringUtil.equals((String)obj.getBudgetSubjectsCode(), (String)applyBudgetSubjectsCode)) continue;
            it.remove();
        }
        return list;
    }

    @Override
    public TtBudgetSubjectsEntity getEntity(String id, String budgetSubjectsCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetSubjectsCode)) {
            return null;
        }
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetSubjectsCode)) {
            criteria.andEqualTo("budgetSubjectsCode", (Object)budgetSubjectsCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttBudgetSubjectsDao.selectByExample(example)))) {
            return (TtBudgetSubjectsEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtBudgetSubjectsServiceImpl.class)
    public AjaxJson save(TtBudgetSubjectsEntity entity, AjaxJson ajaxJson) {
        this.ttBudgetSubjectsDao.insertSelective(entity);
        this.doBudgetSubjectsDetail(entity);
        return ajaxJson;
    }

    private void doBudgetSubjectsDetail(TtBudgetSubjectsEntity entity) {
        if (StringUtil.isNotBlank((CharSequence)entity.getBudgetSubjectsCode())) {
            List detailEntities;
            Example example = new Example(TtBudgetSubjectsEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("budgetSubjectsCode", (Object)entity.getBudgetSubjectsCode());
            this.ttBudgetSubjectsDetailDao.deleteByExample(example);
            String jsonDetail = entity.getBudgetSubjectsDetailJson();
            if (StringUtil.isNotBlank((CharSequence)jsonDetail) && CollectionUtil.listNotEmptyNotSizeZero((List)(detailEntities = JsonPropertyUtil.toArray((String)jsonDetail, TtBudgetSubjectsDetailEntity.class)))) {
                detailEntities.forEach(item -> item.setBudgetSubjectsCode(entity.getBudgetSubjectsCode()));
                this.ttBudgetSubjectsDetailDao.insertList(detailEntities);
            }
        }
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtBudgetSubjectsServiceImpl.class)
    public AjaxJson update(TtBudgetSubjectsEntity entity, AjaxJson ajaxJson) {
        TtBudgetSubjectsEntity oldentity = this.getEntity(entity.getId(), null);
        entity.setCreateBy(oldentity.getCreateBy());
        entity.setEnableStatus(oldentity.getEnableStatus());
        entity.setCreateDate(oldentity.getCreateDate());
        entity.setCreateName(oldentity.getCreateName());
        entity.setPositionCode(oldentity.getPositionCode());
        entity.setPositionName(oldentity.getPositionName());
        this.ttBudgetSubjectsDao.updateByPrimaryKey(entity);
        this.ttCostTypeCategoriesService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        this.ttFeeBudgetService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        this.ttIncomeBudgetService.updateBudgetSubjectsName(entity.getBudgetSubjectsName(), entity.getBudgetSubjectsCode());
        this.doBudgetSubjectsDetail(entity);
        return ajaxJson;
    }

    @Override
    public AjaxJson startOrStop(String id, AjaxJson ajaxJson, String type) {
        TtBudgetSubjectsEntity entity = new TtBudgetSubjectsEntity();
        entity.setId(id);
        entity.setEnableStatus(type);
        this.ttBudgetSubjectsDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public boolean delete(String id) {
        int i;
        if (Objects.nonNull(this.ttBudgetSubjectsDeleteExpand)) {
            this.ttBudgetSubjectsDeleteExpand.validate(id);
        }
        return (i = this.ttBudgetSubjectsDao.deleteByPrimaryKey(id)) > 0;
    }

    @Override
    public List<TtBudgetSubjectsEntity> getBudgetSubjects(List<String> budgetSubjectsCodes) {
        if (CollectionUtil.listEmpty(budgetSubjectsCodes)) {
            return new ArrayList<TtBudgetSubjectsEntity>();
        }
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("budgetSubjectsCode", budgetSubjectsCodes);
        List list = this.selectExample(example);
        list = list == null ? new ArrayList() : list;
        return list;
    }

    @Override
    public List<TtBudgetSubjectsEntity> getBudgetSubjectsBySubjectsType(List<String> subjectsTypeCodes) {
        if (CollectionUtil.listEmpty(subjectsTypeCodes)) {
            return new ArrayList<TtBudgetSubjectsEntity>();
        }
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("subjectsTypeCode", subjectsTypeCodes);
        List list = this.selectExample(example);
        list = list == null ? new ArrayList() : list;
        return list;
    }

    @Override
    public ValidForm checkBudgetSubjectsCodeRepeat(String id, String param) {
        ValidForm validForm = new ValidForm();
        if (StringUtil.isBlank((CharSequence)param)) {
            return validForm;
        }
        Example example = new Example(TtBudgetSubjectsEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetSubjectsCode", (Object)param);
        if (StringUtil.isNotBlank((CharSequence)id)) {
            criteria.andNotEqualTo("id", (Object)id);
            List list = this.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                validForm.setInfo("\u7f16\u7801\u91cd\u590d");
                validForm.setStatus("N");
            }
        } else {
            List list = this.selectExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                validForm.setInfo("\u7f16\u7801\u91cd\u590d");
                validForm.setStatus("N");
            }
        }
        return validForm;
    }
}

