/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.special.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.tag.tags.FormTags;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.Globals;
import com.biz.eisp.budget.fee.entity.TtSpecialAreaDetailEntity;
import com.biz.eisp.budget.fee.entity.TtSpecialAreaEntity;
import com.biz.eisp.budget.special.dao.TtSpecialAreaDao;
import com.biz.eisp.budget.special.dao.TtSpecialAreaDetailDao;
import com.biz.eisp.budget.special.service.TtSpecialAreaService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.params.Constant;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttSpecialAreaService")
@Transactional(rollbackFor={Exception.class})
public class TtSpecialAreaServiceImpl
extends BaseServiceImpl<TtSpecialAreaEntity>
implements TtSpecialAreaService {
    @Autowired
    private TtSpecialAreaDao ttSpecialAreaDao;
    @Autowired
    private TtSpecialAreaDetailDao ttSpecialAreaDetailDao;

    @Override
    public PageInfo<TtSpecialAreaEntity> getMainList(TtSpecialAreaEntity entity, Page page) {
        Example example = new Example(TtSpecialAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)entity.getCode())) {
            criteria.andLike("code", "%" + entity.getCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getName())) {
            criteria.andLike("name", "%" + entity.getName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getType())) {
            criteria.andEqualTo("type", (Object)entity.getType());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getTypeName())) {
            criteria.andLike("typeName", "%" + entity.getTypeName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getNotes())) {
            criteria.andLike("notes", "%" + entity.getNotes() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)entity.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getCreateName())) {
            criteria.andLike("createName", "%" + entity.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getUpdateName())) {
            criteria.andLike("updateName", "%" + entity.getUpdateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar1())) {
            criteria.andLike("extChar1", "%" + entity.getExtChar1() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar2())) {
            criteria.andLike("extChar2", "%" + entity.getExtChar2() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar3())) {
            criteria.andLike("extChar3", "%" + entity.getExtChar3() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar4())) {
            criteria.andLike("extChar4", "%" + entity.getExtChar4() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)entity.getExtChar5())) {
            criteria.andLike("extChar5", "%" + entity.getExtChar5() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttSpecialAreaDao.selectByExample(example), (Page)page);
    }

    @Override
    public TtSpecialAreaEntity getEntity(String id, String code) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)code)) {
            return null;
        }
        Example example = new Example(TtSpecialAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)code)) {
            criteria.andEqualTo("code", (Object)code);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttSpecialAreaDao.selectByExample(example)))) {
            TtSpecialAreaEntity entity = (TtSpecialAreaEntity)list.get(0);
            String mainCode = entity.getCode();
            Example exampleDetail = new Example(TtSpecialAreaDetailEntity.class);
            Example.Criteria criteriaDetail = exampleDetail.createCriteria();
            criteriaDetail.andEqualTo("mainCode", (Object)mainCode);
            List detailEntities = this.ttSpecialAreaDetailDao.selectByExample(exampleDetail);
            ArrayList orgCodesTags = new ArrayList();
            ArrayList orgTypesTags = new ArrayList();
            detailEntities.forEach(item -> {
                FormTags formTags = new FormTags();
                formTags.setCode(item.getCode());
                formTags.setName(item.getName());
                if (Constant.OptionalType.ORG_CODE.getCode().equals(item.getType())) {
                    orgCodesTags.add(formTags);
                } else if (Constant.OptionalType.ORG_TYPE.getCode().equals(item.getType())) {
                    orgTypesTags.add(formTags);
                }
            });
            entity.setOrgCodeFormTags(orgCodesTags);
            entity.setOrgTypeFormTags(orgTypesTags);
            return entity;
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtSpecialAreaServiceImpl.class)
    public AjaxJson stopOrStart(TtSpecialAreaEntity entity, AjaxJson ajaxJson) {
        TtSpecialAreaEntity update = new TtSpecialAreaEntity();
        update.setId(entity.getId());
        update.setEnableStatus(entity.getEnableStatus());
        this.ttSpecialAreaDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtSpecialAreaServiceImpl.class)
    public AjaxJson save(TtSpecialAreaEntity entity, AjaxJson ajaxJson) {
        String code = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.special_area.name());
        entity.setCode(code);
        String type = entity.getType();
        if (StringUtil.isNotEmpty((CharSequence)type)) {
            entity.setTypeName(DictUtil.getDictDataVal((String)"special_type", (String)type));
        }
        this.ttSpecialAreaDao.insertSelective(entity);
        this.saveOrUpdate(false, entity);
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtSpecialAreaServiceImpl.class)
    public AjaxJson update(TtSpecialAreaEntity entity, AjaxJson ajaxJson) {
        TtSpecialAreaEntity newEntity = (TtSpecialAreaEntity)this.ttSpecialAreaDao.selectByPrimaryKey(entity.getId());
        if (newEntity == null) {
            ajaxJson.setErrMsg("\u66f4\u65b0\u5931\u8d25,\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u65b0\u7f16\u8f91.");
            return ajaxJson;
        }
        String type = entity.getType();
        if (StringUtil.isNotEmpty((CharSequence)type)) {
            entity.setTypeName(DictUtil.getDictDataVal((String)"special_type", (String)type));
        }
        this.ttSpecialAreaDao.updateByPrimaryKeySelective(entity);
        this.saveOrUpdate(true, entity);
        return ajaxJson;
    }

    private void saveOrUpdate(Boolean isDel, TtSpecialAreaEntity entity) {
        String orgTypeJson;
        ArrayList<TtSpecialAreaDetailEntity> addList = new ArrayList<TtSpecialAreaDetailEntity>();
        String orgCodeJson = entity.getOrgCodeJson();
        String code = entity.getCode();
        if (StringUtil.isNotEmpty((CharSequence)orgCodeJson)) {
            List list = JSONArray.parseArray((String)orgCodeJson, TtSpecialAreaDetailEntity.class);
            Constant.OptionalType orgCodeEnum = Constant.OptionalType.ORG_CODE;
            for (TtSpecialAreaDetailEntity vo : list) {
                vo.setType(orgCodeEnum.getCode());
                vo.setTypeName(orgCodeEnum.getName());
                vo.setMainCode(code);
                vo.setEnableStatus(Globals.add);
            }
            addList.addAll(list);
        }
        if (StringUtil.isNotEmpty((CharSequence)(orgTypeJson = entity.getOrgTypeJson()))) {
            Constant.OptionalType orgTypeEnum = Constant.OptionalType.ORG_TYPE;
            List list = JSONArray.parseArray((String)orgTypeJson, TtSpecialAreaDetailEntity.class);
            for (TtSpecialAreaDetailEntity vo : list) {
                vo.setType(orgTypeEnum.getCode());
                vo.setTypeName(orgTypeEnum.getName());
                vo.setMainCode(code);
                vo.setEnableStatus(Globals.add);
            }
            addList.addAll(list);
        }
        this.saveOrUpdateData(isDel, addList);
    }

    private void saveOrUpdateData(Boolean mainCode, List<TtSpecialAreaDetailEntity> addList) {
        if (mainCode.booleanValue()) {
            Example exampleDelete = new Example(TtSpecialAreaDetailEntity.class);
            Example.Criteria criteria = exampleDelete.createCriteria();
            List mainCodes = addList.stream().map(TtSpecialAreaDetailEntity::getMainCode).distinct().collect(Collectors.toList());
            criteria.andIn("mainCode", mainCodes);
            this.ttSpecialAreaDetailDao.deleteByExample(exampleDelete);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            this.ttSpecialAreaDetailDao.insertList(addList);
        }
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtSpecialAreaServiceImpl.class)
    public AjaxJson delete(String[] ids, AjaxJson ajaxJson) {
        if (ids == null || ids.length < 1) {
            ajaxJson.setErrMsg("\u8bf7\u9009\u62e9\u6570\u636e");
            return ajaxJson;
        }
        List<String> list = Arrays.asList(ids);
        Example example = new Example(TtSpecialAreaEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", list);
        List specialAreaEntityList = this.ttSpecialAreaDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)specialAreaEntityList)) {
            ajaxJson.setErrMsg("\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5.");
            return ajaxJson;
        }
        this.ttSpecialAreaDao.deleteByExample(example);
        ArrayList<String> mainCodes = new ArrayList<String>();
        for (TtSpecialAreaEntity entity : specialAreaEntityList) {
            mainCodes.add(entity.getCode());
        }
        Example exampleDetail = new Example(TtSpecialAreaDetailEntity.class);
        Example.Criteria criteriaDetail = exampleDetail.createCriteria();
        criteriaDetail.andIn("mainCode", mainCodes);
        this.ttSpecialAreaDetailDao.deleteByExample(exampleDetail);
        return ajaxJson;
    }

    @Override
    public List<String> getCodeList(String type, List<String> orgCodes, List<String> orgTypes) {
        if (StringUtil.isEmpty((String)type)) {
            return new ArrayList<String>();
        }
        return this.ttSpecialAreaDao.getCodeList(type, orgCodes, orgTypes);
    }
}

