/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.fee.dao.TtFeePoolDetailDao;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.service.TtFeeDetailPoolService;
import com.biz.eisp.fee.vo.TtFeePoolDetailApiListReq;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtFeeDetailPoolServiceImpl
extends BaseServiceImpl<TtFeePoolDetailEntity>
implements TtFeeDetailPoolService {
    @Autowired
    private TtFeePoolDetailDao ttFeePoolDetailDao;

    @Override
    public PageInfo<TtFeePoolDetailEntity> getMainListPage(TtFeePoolDetailEntity entity, Page page) {
        Example example = new Example(TtFeePoolDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("custCode", (Object)entity.getCustCode());
        criteria.andNotEqualTo("payTypeCode", (Object)"BILL");
        if (StringUtil.isNotBlank((CharSequence)entity.getPayType())) {
            criteria.andEqualTo("payType", (Object)entity.getPayType());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDetailDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TtFeePoolDetailEntity> feeDetail(TtFeePoolDetailEntity entity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDetailDao.feeDetail(entity), (Page)page);
    }

    @Override
    public List<TtFeePoolDetailEntity> getDetailByPoolCode(String poolCode, Boolean flag) {
        Example example = new Example(TtFeePoolDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        example.orderBy("poolDetailCode").asc();
        criteria.andEqualTo("poolCode", (Object)poolCode);
        if (flag.booleanValue()) {
            criteria.andGreaterThan("feeUsableAmount", (Object)0);
        }
        return this.ttFeePoolDetailDao.selectByExample(example);
    }

    @Override
    public TtFeePoolDetailEntity getEntityByIdOrPoolDetailCode(String id, String poolDetailCode) {
        if (StringUtil.isNotBlank((CharSequence)id)) {
            return (TtFeePoolDetailEntity)this.ttFeePoolDetailDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotBlank((CharSequence)poolDetailCode)) {
            Example example = new Example(TtFeePoolDetailEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("poolDetailCode", (Object)poolDetailCode);
            return (TtFeePoolDetailEntity)this.ttFeePoolDetailDao.selectOneByExample(example);
        }
        return null;
    }

    @Override
    public PageInfo<TtFeePoolDetailEntity> list(TtFeePoolDetailApiListReq ttFeePoolDetailApiListReq) {
        Page page = new Page();
        page.setPage(ttFeePoolDetailApiListReq.getPageNum());
        page.setRows(ttFeePoolDetailApiListReq.getPageSize());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDetailDao.list(ttFeePoolDetailApiListReq.getPoolDetailCode()), (Page)page);
        return pageInfo;
    }
}

