/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.DataDriverUtilService;
import com.biz.eisp.fee.dao.TtFeePoolDao;
import com.biz.eisp.fee.dao.TtFeePoolDetailDao;
import com.biz.eisp.fee.dao.TtFeePoolDetailUsedDao;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.entity.TtFeePoolDetailUsedEntity;
import com.biz.eisp.fee.entity.TtFeePoolEntity;
import com.biz.eisp.fee.service.TtFeeDetailPoolService;
import com.biz.eisp.fee.service.TtFeePoolService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TtFeePoolServiceImpl
extends BaseServiceImpl<TtFeePoolEntity>
implements TtFeePoolService {
    @Autowired
    private TtFeePoolDao ttFeePoolDao;
    @Autowired
    private TtFeePoolDetailDao ttFeePoolDetailDao;
    @Autowired
    private TtFeePoolDetailUsedDao ttFeePoolDetailUsedDao;
    @Autowired
    private TtFeeDetailPoolService ttFeeDetailPoolService;
    @Autowired
    private DataDriverUtilService dataDriverUtilService;

    @Override
    public PageInfo<TtFeePoolEntity> getMaiList(TtFeePoolEntity entity, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.ttFeePoolDao.getMaiList(entity), (Page)page);
    }

    @Override
    @Klock(keys={"#entity.custCode"})
    public AjaxJson updateAmount(TtFeePoolDetailEntity entity, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)entity.getCustCode())) {
            ajaxJson.setErrMsg("\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (entity.getUpdateAmount() == null) {
            ajaxJson.setErrMsg("\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (entity.getFeePoolType() == null || ConstantEnum.FeePoolTypeEnum.getEnum((String)entity.getFeePoolType()) == null) {
            ajaxJson.setErrMsg("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (entity.getUpdateAmount() == null) {
            ajaxJson.setErrMsg("\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        TtFeePoolDetailEntity entityOld = this.ttFeeDetailPoolService.getEntityByIdOrPoolDetailCode(entity.getId(), entity.getPoolDetailCode());
        if (entityOld != null) {
            BigDecimal oldAmount = entityOld.getFeeUsableAmount();
            BigDecimal updateAmount = entity.getUpdateAmount();
            ajaxJson = this.checkAmoun(entityOld.getPoolDetailCode(), entity.getFeePoolType(), updateAmount, oldAmount);
            if (!ajaxJson.isSuccess()) {
                return ajaxJson;
            }
            if (ConstantEnum.FeePoolTypeEnum.INCOME_OUT.getValue().equals(entity.getFeePoolType()) || ConstantEnum.FeePoolTypeEnum.DELETE_FEE.getValue().equals(entity.getFeePoolType()) || ConstantEnum.FeePoolTypeEnum.USED_FEE.getValue().equals(entity.getFeePoolType())) {
                updateAmount = updateAmount.multiply(new BigDecimal(-1));
            }
            oldAmount = oldAmount.add(updateAmount);
            this.doFeeUesd(entity, updateAmount);
            entityOld.setFeeUsableAmount(oldAmount);
            this.ttFeeDetailPoolService.updateByPrimaryKeySelective(entityOld);
        } else if (ConstantEnum.FeePoolTypeEnum.INCOME_FEE.getValue().equals(entity.getFeePoolType()) || ConstantEnum.FeePoolTypeEnum.INIT_FEE.getValue().equals(entity.getFeePoolType())) {
            entity.setFeeAmount(entity.getUpdateAmount());
            entity.setFeeUsableAmount(entity.getUpdateAmount());
            entity.setPoolDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_pool_detail_code.name()));
            this.ttFeeDetailPoolService.insertSelective(entity);
        } else {
            throw new BusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728" + entity.getFeePoolType());
        }
        return ajaxJson;
    }

    private AjaxJson checkAmoun(String detailCode, String feePoolType, BigDecimal updateAmount, BigDecimal oldAmount) {
        AjaxJson ajaxJson = new AjaxJson();
        if ((ConstantEnum.FeePoolTypeEnum.INCOME_OUT.getValue().equals(feePoolType) || ConstantEnum.FeePoolTypeEnum.DELETE_FEE.getValue().equals(feePoolType) || ConstantEnum.FeePoolTypeEnum.USED_FEE.getValue().equals(feePoolType)) && oldAmount.compareTo(updateAmount) < 0) {
            ajaxJson.setErrMsg(detailCode + "\u8d85\u8fc7\u4f59\u989d" + oldAmount);
            return ajaxJson;
        }
        return ajaxJson;
    }

    private Boolean checkUsedFlag(String feePoolType) {
        if (ConstantEnum.FeePoolTypeEnum.INCOME_OUT.getValue().equals(feePoolType) || ConstantEnum.FeePoolTypeEnum.DELETE_FEE.getValue().equals(feePoolType) || ConstantEnum.FeePoolTypeEnum.USED_FEE.getValue().equals(feePoolType)) {
            return true;
        }
        return false;
    }

    private void doFeeUesd(TtFeePoolDetailEntity poolEntity, BigDecimal updateAmount) {
        TtFeePoolDetailUsedEntity entity = new TtFeePoolDetailUsedEntity();
        entity.setPoolDetailCode(poolEntity.getPoolDetailCode());
        entity.setUseAmount(updateAmount);
        entity.setUseableAmount(poolEntity.getFeeUsableAmount());
        entity.setTotalAmount(poolEntity.getFeeAmount());
        entity.setUseType(poolEntity.getFeePoolType());
        entity.setFromCode(poolEntity.getFromCode());
        entity.setNotes(poolEntity.getNotes());
        this.ttFeePoolDetailUsedDao.insertSelective(entity);
    }

    private void sysAmount(TtFeePoolEntity newEntity, TtFeePoolEntity oldEntity) {
        newEntity.setFeeAmount(oldEntity.getFeeAmount());
        newEntity.setFeeUsableAmount(oldEntity.getFeeUsableAmount());
    }

    private void updateDataPool(TtFeePoolEntity entity) {
        TtFeePoolEntity newEntity = new TtFeePoolEntity();
        newEntity.setFeeAmount(entity.getFeeAmount());
        newEntity.setFeeUsableAmount(entity.getFeeUsableAmount());
        newEntity.setCustCode(entity.getCustCode());
        newEntity.setCustName(entity.getCustName());
        newEntity.setCompanyCode(entity.getCompanyCode());
        newEntity.setCompanyName(entity.getCompanyName());
        newEntity.setMoneyUnits(entity.getMoneyUnits());
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", (Object)entity.getId());
        this.ttFeePoolDao.updateByExampleSelective(newEntity, example);
    }

    private void doAmountUpdate(TtFeePoolEntity entity, AjaxJson ajaxJson) {
        BigDecimal feeAmount = entity.getFeeAmount();
        BigDecimal feeUsableAmount = entity.getFeeUsableAmount();
        BigDecimal amount = entity.getUpdateAmount();
        if ((ConstantEnum.FeePoolTypeEnum.INCOME_OUT.getValue().equals(entity.getFeePoolType()) || ConstantEnum.FeePoolTypeEnum.DELETE_FEE.getValue().equals(entity.getFeePoolType())) && feeUsableAmount.add(amount = amount.multiply(new BigDecimal("-1"))).compareTo(BigDecimal.ZERO) < 0) {
            ajaxJson.setErrMsg("\u64cd\u4f5c\u5931\u8d25\uff0c\u8d85\u8fc7\u4f59\u989d\u8d39\u7528\uff1a" + feeUsableAmount);
            return;
        }
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            feeAmount = feeAmount.add(amount);
        }
        feeUsableAmount = feeUsableAmount.add(amount);
        entity.setFeeAmount(feeAmount);
        entity.setFeeUsableAmount(feeUsableAmount);
    }

    private TtFeePoolDetailEntity createDetailEntity(TtFeePoolEntity entity) {
        BigDecimal amount = entity.getUpdateAmount();
        TtFeePoolDetailEntity detailEntity = new TtFeePoolDetailEntity();
        detailEntity.setPoolCode(entity.getPoolCode());
        detailEntity.setPoolDetailCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_pool_detail_code.name()));
        detailEntity.setFeeAmount(amount);
        detailEntity.setFeeUsableAmount(amount);
        detailEntity.setMoneyUnits(entity.getMoneyUnits());
        detailEntity.setFeePoolType(entity.getFeePoolType());
        detailEntity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        detailEntity.setNotes(entity.getNotes());
        detailEntity.setCompanyCode(entity.getCompanyCode());
        detailEntity.setCompanyName(entity.getCompanyName());
        detailEntity.setCustCode(entity.getCustCode());
        detailEntity.setCustName(entity.getCustName());
        detailEntity.setFromCode(entity.getFromCode());
        detailEntity.setFromTable(entity.getFromTable());
        detailEntity.setPayType(entity.getPayType());
        return detailEntity;
    }

    @Override
    public TtFeePoolEntity getEntityByCustAndCompany(String custCode, String companyCode) {
        List list;
        if (StringUtil.isEmpty((String)custCode)) {
            return null;
        }
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)custCode)) {
            criteria.andEqualTo("custCode", (Object)custCode);
        }
        if (StringUtil.isNotEmpty((CharSequence)companyCode)) {
            criteria.andEqualTo("companyCode", (Object)companyCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttFeePoolDao.selectByExample(example)))) {
            return (TtFeePoolEntity)list.get(0);
        }
        return null;
    }

    @Override
    public TtFeePoolEntity getEntityByIdOrPoolCode(String id, String poolCode) {
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)poolCode)) {
            return null;
        }
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (TtFeePoolEntity)this.ttFeePoolDao.selectByPrimaryKey(id);
        }
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("poolCode", (Object)poolCode);
        List list = this.ttFeePoolDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return (TtFeePoolEntity)list.get(0);
        }
        return null;
    }

    @Override
    public TtFeePoolEntity getPoolUsableByCustAndCompanyCode(String custCode, String companyCode) {
        if (StringUtil.isBlank((CharSequence)custCode)) {
            return null;
        }
        Example example = new Example(TtFeePoolEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("custCode", (Object)custCode);
        if (StringUtil.isBlank((CharSequence)companyCode)) {
            if (this.dataDriverUtilService.isMysql()) {
                criteria.andCondition(" IFNULL(company_code,'') = '' ");
            }
            if (this.dataDriverUtilService.isOracle()) {
                criteria.andCondition(" nvl(company_code,'') = '' ");
            }
        } else {
            criteria.andEqualTo("companyCode", (Object)companyCode);
        }
        return null;
    }
}

