/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.entity.TtFeePoolDetailUsedEntity;
import com.biz.eisp.fee.service.TtFeeDetailPoolService;
import com.biz.eisp.fee.service.TtFeePoolDetailUsedService;
import com.biz.eisp.fee.service.TtFeePoolService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import tk.mybatis.mapper.entity.Example;

@Controller
@RequestMapping(value={"/ttFeePoolDetailController"})
public class TtFeePoolDetailController {
    @Autowired
    private TtFeeDetailPoolService ttFeeDetailPoolService;
    @Autowired
    private TtFeePoolService ttFeePoolService;
    @Autowired
    private TtFeePoolDetailUsedService ttFeePoolDetailUsedService;

    @RequestMapping(value={"goMain"})
    public ModelAndView goMain(HttpServletRequest request, String id) {
        request.setAttribute("id", (Object)id);
        return new ModelAndView("com/biz/eisp/fee/feeAddListMain");
    }

    @RequestMapping(value={"getFeePoolDetailForEstimate"})
    @ResponseBody
    public AjaxJson<TtFeePoolDetailEntity> getFeePoolDetailForEstimate() {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(TtFeePoolDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIsNotNull("poolCode");
        ArrayList<String> list = new ArrayList<String>();
        list.add(ConstantEnum.FeePoolTypeEnum.INCOME_FEE.getValue());
        list.add(ConstantEnum.FeePoolTypeEnum.INIT_FEE.getValue());
        criteria.andIn("feePoolType", list);
        criteria.andGreaterThan("feeUsableAmount", (Object)0);
        List entities = this.ttFeeDetailPoolService.selectExample(example);
        ajaxJson.setObjList(entities);
        return ajaxJson;
    }

    @RequestMapping(value={"getMainListPage"})
    @ResponseBody
    public DataGrid getMainListPage(HttpServletRequest request, TtFeePoolDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeePoolDetailEntity> pageInfo = this.ttFeeDetailPoolService.getMainListPage(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"feeDetail"})
    @ResponseBody
    public DataGrid feeDetail(HttpServletRequest request, TtFeePoolDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeePoolDetailEntity> pageInfo = this.ttFeeDetailPoolService.feeDetail(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getUsedMainListPage"})
    @ResponseBody
    public DataGrid getUsedMainListPage(HttpServletRequest request, TtFeePoolDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeePoolDetailUsedEntity> pageInfo = this.ttFeePoolDetailUsedService.getUsedMainListPage(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getDetailUsedMainListPage"})
    @ResponseBody
    public DataGrid getDetailUsedMainListPage(HttpServletRequest request, TtFeePoolDetailEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeePoolDetailUsedEntity> pageInfo = this.ttFeePoolDetailUsedService.getUsedMainListPage(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getEntityByIdOrPoolDetailCode"})
    @ResponseBody
    public AjaxJson<TtFeePoolDetailEntity> getEntityByIdOrPoolDetailCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="poolDetailCode", required=false) String poolDetailCode) {
        TtFeePoolDetailEntity entity = this.ttFeeDetailPoolService.getEntityByIdOrPoolDetailCode(id, poolDetailCode);
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

