/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.account.controller;

import com.biz.eisp.account.entity.FeeBillHeadEntity;
import com.biz.eisp.account.entity.TtAccountDetailEntity;
import com.biz.eisp.account.entity.TtAccountInvoiceEntity;
import com.biz.eisp.account.service.AccountSaveOrUpdateDataAfterCommitExtend;
import com.biz.eisp.account.service.FeeBillHeadService;
import com.biz.eisp.account.service.TtAccountDetailService;
import com.biz.eisp.account.vo.AccountDetailVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.CodeRuleUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttAccountController"})
public class TtAccountController {
    @Autowired
    private TtAccountDetailService ttAccountDetailService;
    @Autowired
    private FeeBillHeadService feeBillHeadService;
    @Autowired(required=false)
    private AccountSaveOrUpdateDataAfterCommitExtend accountSaveOrUpdateDataAfterCommitExtend;

    @GetMapping(value={"getEntityByIdOrAccountCode"})
    public AjaxJson<TtAccountDetailEntity> getEntityByIdOrAccountCode(@RequestParam(value="id") String id, @RequestParam(value="accountCode") String accountCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAccountDetailEntity entity = this.ttAccountDetailService.getEntityByIdOrAccountCode(id, accountCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"checkUpdate"})
    public AjaxJson<TtAccountDetailEntity> checkUpdate(@RequestParam(value="groupId") String groupId) {
        AjaxJson ajaxJson = new AjaxJson();
        return this.ttAccountDetailService.checkUpdate(groupId);
    }

    @GetMapping(value={"getFeeBillHead"})
    public AjaxJson<FeeBillHeadEntity> getFeeBillHead(@RequestParam(value="groupId") String groupId) {
        AjaxJson ajaxJson = new AjaxJson();
        FeeBillHeadEntity headEntity = this.feeBillHeadService.getFeeBillHeadByGroupId(groupId);
        headEntity = headEntity == null ? new FeeBillHeadEntity() : headEntity;
        ajaxJson.setObj((Object)headEntity);
        return ajaxJson;
    }

    @RequestMapping(value={"getMaiListPage"})
    @ResponseBody
    public DataGrid getMaiListPage(HttpServletRequest request, TtAccountDetailEntity ttBudgetSubjectsEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtAccountDetailEntity> pageInfo = this.ttAccountDetailService.getMaiList(ttBudgetSubjectsEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getListForUpdatePage"})
    @ResponseBody
    public DataGrid getListForAddPage(HttpServletRequest request, TtAccountDetailEntity ttBudgetSubjectsEntity) {
        EuPage page = new EuPage(request);
        String groupId = StringUtil.isEmpty((String)ttBudgetSubjectsEntity.getGroupId()) ? "null" : ttBudgetSubjectsEntity.getGroupId();
        ttBudgetSubjectsEntity.setGroupId(groupId);
        PageInfo<TtAccountDetailEntity> pageInfo = this.ttAccountDetailService.getMaiList(ttBudgetSubjectsEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getEntityByIdOrAccountCode"})
    @ResponseBody
    public AjaxJson getEntityByIdOrAccountCode(HttpServletRequest request, @RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAccountDetailEntity entity = this.ttAccountDetailService.getEntityByIdOrAccountCode(id, null);
        if (!ConstantEnum.StatusEnum.UPDATE.getValue().equals(entity.getEnableStatus())) {
            ajaxJson.setErrMsg("\u53ea\u6709\u6682\u5b58\u72b6\u6001\u624d\u5141\u8bb8\u7f16\u8f91");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"getInvoiceMaiListPage"})
    @ResponseBody
    public List<TtAccountInvoiceEntity> getInvoiceMaiListPage(HttpServletRequest request, TtAccountInvoiceEntity entity) {
        EuPage page = new EuPage(request);
        page.setPage("1");
        page.setRows("5000");
        PageInfo<TtAccountInvoiceEntity> pageInfo = this.ttAccountDetailService.getInvoiceMaiListPage(entity, (Page)page);
        return pageInfo.getList();
    }

    @RequestMapping(value={"saveOrUpdateData"})
    @ResponseBody
    public AjaxJson saveOrUpdateData(HttpServletRequest request, @RequestBody AccountDetailVo accountDetailVo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.ttAccountDetailService.saveOrUpdateData(accountDetailVo, ajaxJson);
        if (null != this.accountSaveOrUpdateDataAfterCommitExtend) {
            this.accountSaveOrUpdateDataAfterCommitExtend.afterSaveOrUpdateData(accountDetailVo);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"getCodes"})
    @ResponseBody
    public AjaxJson<String> getCodes(HttpServletRequest request, Integer count) {
        AjaxJson ajaxJson = new AjaxJson();
        List codes = CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.account_code.name(), (Integer)count);
        ajaxJson.setObjList(codes);
        return ajaxJson;
    }

    @RequestMapping(value={"delete"})
    @ResponseBody
    public AjaxJson delete(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJsonAll = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        StringBuffer errorMsg = new StringBuffer();
        for (String id : ids) {
            try {
                AjaxJson ajaxJson = new AjaxJson();
                ajaxJson = this.ttAccountDetailService.delete(id, ajaxJson);
                if (ajaxJson.isSuccess()) continue;
                errorMsg.append(ajaxJson.getMsg() + "</br>");
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761 <br/>");
        stringBuffer.append(errorMsg);
        if (errorCount == 0) {
            ajaxJsonAll.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJsonAll.setErrMsg(stringBuffer.toString());
        }
        return ajaxJsonAll;
    }
}

