/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.fee.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.fee.entity.TtFeePoolDetailEntity;
import com.biz.eisp.fee.entity.TtFeePoolEntity;
import com.biz.eisp.fee.service.TtFeePoolService;
import com.biz.eisp.fee.vo.UseFeePoolVo;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttFeePoolController"})
public class TtFeePoolController {
    @Autowired
    private TtFeePoolService ttFeePoolService;

    @RequestMapping(value={"getMaiListPage"})
    public DataGrid getMaiListPage(HttpServletRequest request, TtFeePoolEntity entity) {
        EuPage page = new EuPage(request);
        PageInfo<TtFeePoolEntity> pageInfo = this.ttFeePoolService.getMaiList(entity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"updateAmount"})
    public AjaxJson updateAmount(HttpServletRequest request, TtFeePoolDetailEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (entity.getUpdateAmount() == null) {
            ajaxJson.setErrMsg("\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        ajaxJson = this.ttFeePoolService.updateAmount(entity, ajaxJson);
        return ajaxJson;
    }

    @GetMapping(value={"getEntityByIdOrPoolCode"})
    public AjaxJson<TtFeePoolEntity> getEntityByIdOrPoolCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="poolCode", required=false) String poolCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtFeePoolEntity entity = this.ttFeePoolService.getEntityByIdOrPoolCode(id, poolCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getPoolUsableByCustAndCompanyCode"})
    public AjaxJson<TtFeePoolEntity> getPoolUsableByCustAndCompanyCode(@RequestParam(value="custCode", required=false) String custCode, @RequestParam(value="companyCode", required=false) String companyCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtFeePoolEntity entity = this.ttFeePoolService.getPoolUsableByCustAndCompanyCode(custCode, companyCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @PostMapping(value={"commonUseFeePool"})
    public AjaxJson commonUseFeePool(@RequestBody UseFeePoolVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        TtFeePoolDetailEntity entity = new TtFeePoolDetailEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        ajaxJson = this.ttFeePoolService.updateAmount(entity, ajaxJson);
        return ajaxJson;
    }
}

