/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.tools;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.kernel.KnlCodeRuleFeign;
import com.biz.eisp.service.RedisService;
import java.util.List;

public class CodeRuleUtil {
    private static RedisService redisService;
    private static KnlCodeRuleFeign knlCodeRuleFeign;

    public static void getKnlCodeRuleFeign() {
        String[] beanTypes;
        if (knlCodeRuleFeign == null && (beanTypes = SpringApplicationContextUtil.getApplicationContext().getBeanNamesForType(KnlCodeRuleFeign.class)).length > 0) {
            knlCodeRuleFeign = (KnlCodeRuleFeign)SpringApplicationContextUtil.getApplicationContext().getBean(KnlCodeRuleFeign.class);
        }
    }

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    public static String getKnlCodingRulesString(String codingRuleCode) {
        List<String> strings = CodeRuleUtil.getCodeList(codingRuleCode, 1);
        String code = null;
        if (!CollectionUtil.listNotEmptyNotSizeZero(strings)) {
            throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
        }
        code = strings.get(0);
        return code;
    }

    public static List<String> getCodeList(String codingRuleCode, Integer number) {
        CodeRuleUtil.getKnlCodeRuleFeign();
        AjaxJson<String> ajaxJson = knlCodeRuleFeign.getCodeRuleList(codingRuleCode, number);
        return ajaxJson.getObjList();
    }
}

