/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.config;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.config.FeignHystrixConcurrencyStrategy;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignHeaderInterceptor
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        try {
            String loginUserToken = AppcenterUtil.getUserKey();
            loginUserToken = StringUtil.isNotEmpty((CharSequence)loginUserToken) ? loginUserToken : "";
            requestTemplate.header("loginUserToken", new String[]{loginUserToken});
        }
        catch (Exception e) {
            requestTemplate.header("loginUserToken", new String[]{""});
        }
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null && requestAttributes.getRequest() != null) {
                String clickFunctionId = requestAttributes.getRequest().getParameter("clickFunctionId");
                clickFunctionId = clickFunctionId == null ? "" : clickFunctionId;
                requestTemplate.header("clickFunctionIdToken", new String[]{clickFunctionId});
            }
        }
        catch (Exception e) {
            requestTemplate.header("clickFunctionIdToken", new String[]{""});
        }
    }

    @Bean
    public FeignHystrixConcurrencyStrategy feignHystrixConcurrencyStrategy() {
        return new FeignHystrixConcurrencyStrategy();
    }
}

