/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.task.util;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.task.util.ExecuteUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadUtil {
    private static ThreadPoolTaskExecutor taskPoolExecutor;

    public static <T> void executeThread(List<T> objects, String fromName, String serviceName) {
        if (objects == null) {
            return;
        }
        ThreadUtil.initPool();
        for (T object : objects) {
            ExecuteUtil executeUtil = new ExecuteUtil(object, fromName, serviceName);
            taskPoolExecutor.submit((Callable)executeUtil);
        }
    }

    public static Map<String, AjaxJson> callThread(Map<String, Object> mapObject, String fromName, String serviceName) {
        HashMap<String, AjaxJson> map = new HashMap<String, AjaxJson>();
        if (mapObject == null || mapObject.isEmpty()) {
            return map;
        }
        ThreadUtil.initPool();
        HashMap<String, Future> mapReturn = new HashMap<String, Future>();
        for (Map.Entry<String, Object> entry : mapObject.entrySet()) {
            String key = entry.getKey();
            ExecuteUtil executeUtil = new ExecuteUtil(entry.getValue(), fromName, serviceName);
            Future future = taskPoolExecutor.submit((Callable)executeUtil);
            mapReturn.put(key, future);
        }
        for (Map.Entry<String, Object> entry : mapReturn.entrySet()) {
            try {
                map.put(entry.getKey(), (AjaxJson)((Future)entry.getValue()).get());
            }
            catch (Exception e) {
                AjaxJson<Exception> ajaxJson = new AjaxJson<Exception>();
                ajaxJson.setErrMsg("\u5904\u7406\u5931\u8d25");
                ajaxJson.setObj(e);
                map.put(entry.getKey(), ajaxJson);
                e.printStackTrace();
            }
        }
        return map;
    }

    private static void initPool() {
        if (taskPoolExecutor == null) {
            taskPoolExecutor = (ThreadPoolTaskExecutor)SpringApplicationContextUtil.getApplicationContext().getBean("taskPoolExecutor");
        }
    }
}

