/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapChangeUtil {
    public static final String ONE_STR = "1";
    public static final String mapKeyStr = "key";
    public static final String mapValueStr = "value";

    public static <T> List<Map<String, Object>> encapsulateDataAjax(List<T> objs, String ... fields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            for (T obj : objs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String field : fields) {
                    Object object = reflectHelper.getMethodValue(obj, field);
                    map.put(field, object);
                }
                list.add(map);
            }
        }
        return list;
    }

    public static <T> Map<String, Object> encapsulateDataAndLinkFieldsValue(List<T> objs, boolean redundant, String valueField, String ... fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            for (T obj : objs) {
                Object valueStrTemp;
                String keyStr = "";
                Object valueStr = ONE_STR;
                if (StringUtil.isNotEmpty((CharSequence)valueField) && StringUtil.isNotEmpty(valueStrTemp = reflectHelper.getMethodValue(obj, valueField))) {
                    valueStr = valueStrTemp;
                }
                int i = 0;
                for (String field : fields) {
                    Object object = reflectHelper.getMethodValue(obj, field);
                    if (object instanceof Date) {
                        throw new BusinessException("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u4e0d\u80fd\u8f6c\u6362\u5c06\u2018" + Date.class.getName() + "\u2019\u7c7b\u578b\u8f6c\u6362\u4e3a\u2018java.lang.String\u2019\u7c7b\u578b");
                    }
                    String valueTmp = String.valueOf(object);
                    if (redundant) {
                        map.put(valueTmp, valueStr);
                    }
                    keyStr = keyStr + valueTmp;
                    if (!redundant) continue;
                    ++i;
                }
                if (i == true) continue;
                map.put(keyStr, valueStr);
            }
        }
        return map;
    }

    public static <T> Map<String, Object> encapsulateDataFieldsToKeyAndRespectivelyLinkFieldsValue(List<T> objs, boolean isInStr, String ... fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            for (T obj : objs) {
                String keyStr = "";
                boolean i = false;
                for (String field : fields) {
                    Object object = reflectHelper.getMethodValue(obj, field);
                    if (object instanceof Date) {
                        throw new BusinessException("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u4e0d\u80fd\u8f6c\u6362\u5c06\u2018" + Date.class.getName() + "\u2019\u7c7b\u578b\u8f6c\u6362\u4e3a\u2018java.lang.String\u2019\u7c7b\u578b");
                    }
                    String valueOldTemp = StringUtil.returnNotNullWordValue(String.valueOf(map.get(field)));
                    String valueTmp = String.valueOf(object);
                    if (StringUtil.isNotEmpty((CharSequence)valueOldTemp)) {
                        if (valueOldTemp.contains(valueTmp)) continue;
                        valueOldTemp = valueOldTemp + ",";
                    }
                    valueOldTemp = valueOldTemp + valueTmp;
                    map.put(field, valueOldTemp);
                }
            }
        }
        if (isInStr) {
            for (String str : map.keySet()) {
                Object object = map.get(str);
                map.put(str, StringUtil.changeStringToSqlInString(String.valueOf(object)));
            }
        }
        return map;
    }

    public static <T> void encapsulateDataAjaxByMap(AjaxJson j, List<T> objs, String idName, String valueName) {
        j.setObj(MapChangeUtil.encapsulateDataAjaxByMap(objs, idName, valueName));
    }

    public static <T> List<Map<String, Object>> encapsulateDataAjaxByMap(List<T> objs, String idName, String valueName) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            for (T obj : objs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Object object = reflectHelper.getMethodValue(obj, idName);
                map.put(mapKeyStr, object);
                object = reflectHelper.getMethodValue(obj, valueName);
                map.put(mapValueStr, object);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> Map<String, Object> encapsulateDataByMapKeyToKayValueToValue(List<T> objs, String key, String value) {
        if (!StringUtil.isNotEmpty((CharSequence)key)) {
            throw new BusinessException("key is null ");
        }
        if (!StringUtil.isNotEmpty((CharSequence)value)) {
            throw new BusinessException("value is null ");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            for (T obj : objs) {
                Object keyObj = reflectHelper.getMethodValue(obj, key);
                if (keyObj == null) {
                    throw new BusinessException("map\u7684\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (keyObj instanceof String) {
                    Object valueObj = reflectHelper.getMethodValue(obj, value);
                    map.put(keyObj.toString(), valueObj);
                    continue;
                }
                throw new BusinessException("map\u7684\u952e\u5fc5\u987b\u4e3aString");
            }
        }
        return map;
    }

    public static <T> Map<String, Object> encapsulateListMapDataByMapKeyToKayValueToValue(List<Map<String, Object>> objs, String key, String value) {
        if (!StringUtil.isNotEmpty((CharSequence)key)) {
            throw new BusinessException("key is null ");
        }
        if (!StringUtil.isNotEmpty((CharSequence)value)) {
            throw new BusinessException("value is null ");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        key = key.toUpperCase();
        value = value.toUpperCase();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            for (Map<String, Object> obj : objs) {
                Object keyObj = obj.get(key);
                if (keyObj == null) {
                    throw new BusinessException("map\u7684\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (keyObj instanceof String) {
                    Object valueObj = obj.get(value);
                    map.put(keyObj.toString(), valueObj);
                    continue;
                }
                throw new BusinessException("map\u7684\u952e\u5fc5\u987b\u4e3aString");
            }
        }
        return map;
    }

    public static <T> Map<String, T> encapsulateDataByMapKeyToKayMapValueToEntity(List<T> objs, boolean ignoreEmpty, String key) {
        if (!StringUtil.isNotEmpty((CharSequence)key)) {
            throw new BusinessException("key is null ");
        }
        HashMap<String, T> map = new HashMap<String, T>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            for (T obj : objs) {
                Object keyObj = reflectHelper.getMethodValue(obj, key);
                if (keyObj instanceof String) {
                    if (StringUtil.isNotEmpty(keyObj)) {
                        map.put(keyObj.toString(), obj);
                        continue;
                    }
                    if (!ignoreEmpty) continue;
                    throw new BusinessException("\u952e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                throw new BusinessException("map\u7684\u952e\u5fc5\u987b\u4e3aString");
            }
        }
        return map;
    }

    public static <T> Map<String, T> encapsulateDataByMapKeyToKayMapValueToT(List<T> objs, String connect, String ... keys) {
        if (keys == null || keys.length <= 0) {
            throw new BusinessException("key is null ");
        }
        HashMap<String, T> map = new HashMap<String, T>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            String keyTemp = "";
            for (T obj : objs) {
                keyTemp = MapChangeUtil.getTheKeyTempByPointFile("", reflectHelper, obj, connect, keys);
                if (!StringUtil.isNotEmpty((CharSequence)keyTemp)) continue;
                map.put(keyTemp, obj);
            }
        }
        return map;
    }

    public static <T> Map<String, List<T>> encapsulateDataByMapKeyToKayMapValueToListTs(List<T> objs, String connect, String ... keys) {
        if (keys == null || keys.length <= 0) {
            throw new BusinessException("key is null ");
        }
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(objs)) {
            ReflectHelper reflectHelper = new ReflectHelper(objs.get(0));
            String keyTemp = "";
            for (T obj : objs) {
                keyTemp = MapChangeUtil.getTheKeyTempByPointFile("", reflectHelper, obj, connect, keys);
                if (!StringUtil.isNotEmpty((CharSequence)keyTemp)) continue;
                ArrayList<T> tList = (ArrayList<T>)map.get(keyTemp);
                if (tList == null) {
                    tList = new ArrayList<T>();
                    map.put(keyTemp, tList);
                }
                tList.add(obj);
            }
        }
        return map;
    }

    private static <T> String getTheKeyTempByPointFile(String keyTemp, ReflectHelper reflectHelper, T obj, String connect, String ... keys) {
        for (String key : keys) {
            Object keyObj;
            if (StringUtil.isNotEmpty((CharSequence)keyTemp)) {
                keyTemp = keyTemp + connect;
            }
            if ((keyObj = reflectHelper.getMethodValue(obj, key)) == null) continue;
            if (keyObj instanceof String) {
                keyTemp = keyTemp + keyObj.toString();
                continue;
            }
            throw new BusinessException("map\u7684\u952e\u5fc5\u987b\u4e3aString");
        }
        if (!StringUtil.isNotEmpty((CharSequence)keyTemp)) {
            throw new BusinessException("\u8bfb\u53d6\u5173\u952e\u503c\u4e3a\u7a7akey\uff1a" + Arrays.toString(keys));
        }
        return keyTemp;
    }

    public static List<Map<String, Object>> changeMapToMapKeyValue(Map<String, Object> map) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (map == null || map.size() <= 0) {
            return mapList;
        }
        for (Map.Entry<String, Object> objectEntry : map.entrySet()) {
            HashMap<String, String> objectMap = new HashMap<String, String>();
            objectMap.put(mapKeyStr, objectEntry.getKey());
            objectMap.put(mapValueStr, objectEntry.getKey());
            mapList.add(objectMap);
        }
        return mapList;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<?> clazz) throws Exception {
        Object obj = clazz.newInstance();
        if (map != null && !map.isEmpty() && map.size() > 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                Field field = MapChangeUtil.getClassField(clazz, propertyName);
                if (field == null) continue;
                Class<?> fieldTypeClass = field.getType();
                value = MapChangeUtil.convertValType(value, fieldTypeClass);
                try {
                    clazz.getMethod(setMethodName, field.getType()).invoke(obj, value);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        return (T)obj;
    }

    private static Object convertValType(Object value, Class<?> fieldTypeClass) {
        Object retVal = null;
        retVal = Long.class.getName().equals(fieldTypeClass.getName()) || Long.TYPE.getName().equals(fieldTypeClass.getName()) ? Long.valueOf(Long.parseLong(value.toString())) : (Integer.class.getName().equals(fieldTypeClass.getName()) || Integer.TYPE.getName().equals(fieldTypeClass.getName()) ? Integer.valueOf(Integer.parseInt(value.toString())) : (Float.class.getName().equals(fieldTypeClass.getName()) || Float.TYPE.getName().equals(fieldTypeClass.getName()) ? Float.valueOf(Float.parseFloat(value.toString())) : (Double.class.getName().equals(fieldTypeClass.getName()) || Double.TYPE.getName().equals(fieldTypeClass.getName()) ? Double.valueOf(Double.parseDouble(value.toString())) : value)));
        return retVal;
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        if (Object.class.getName().equals(clazz.getName())) {
            return null;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return MapChangeUtil.getClassField(superClass, fieldName);
        }
        return null;
    }
}

