/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class OwnDateUtils {
    public static final String YEAR = "YEAR";
    public static final String MONTH = "MONTH";
    public static final String DATE = "DATE";
    public static final String HOURS = "HOUR";
    public static final String MINUTES = "MINUTE";
    public static final String SECONDS = "SECOND";
    public static final String STARTDATE = "STARTDATE";
    public static final String ENDDATE = "ENDDATE";
    public static final String YEARMONTH = "YEARMONTH";
    public static final String FORMATTERYM_ = "yyyyMM";
    public static final String FORMATTER_YM = "yyyy-MM";
    public static final String FORMATTER_YMD = "yyyy-MM-dd";
    public static final String FORMATTER_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    public static OwnDateUtils getOwnDateUtils() {
        return new OwnDateUtils();
    }

    public void encapsulationYearAndMonth(HttpServletRequest request, int n) {
        Map<String, String> stringMap = this.returnYearAndMonthUseMapInNowDateNext(n);
        request.setAttribute(YEAR, (Object)stringMap.get(YEAR));
        request.setAttribute(MONTH, (Object)stringMap.get(MONTH));
        request.setAttribute(YEARMONTH, (Object)stringMap.get(YEARMONTH));
    }

    public Map<String, String> returnYearAndMonthUseMapInNowDateNext(int n) {
        return this.returnYearAndMonthUseMapInNowDateNext(new Date(), FORMATTER_YM, MONTH + ":" + n);
    }

    public Map<String, String> returnYearAndMonthUseMapInNowDateNext(Date date) {
        return this.returnYearAndMonthUseMapInNowDateNext(date, FORMATTER_YM, MONTH + ":0");
    }

    public Map<String, String> returnYearAndMonthUseMapInNowDateNext(Date date, int n) {
        return this.returnYearAndMonthUseMapInNowDateNext(date, FORMATTER_YM, MONTH + ":" + n);
    }

    public Map<String, String> returnYearAndMonthUseMapInNowDateNext(Date date, String format, int n) {
        return this.returnYearAndMonthUseMapInNowDateNext(date, FORMATTER_YM, MONTH + ":" + n);
    }

    public Map<String, String> returnYearAndMonthUseMapInNowDateNext(Date date, String format, String dataRule) {
        HashMap<String, String> map = new HashMap<String, String>();
        String dateStr = this.returnComputationsDateStr(date, format, dataRule);
        String[] dateStrs = dateStr.split("-");
        map.put(YEAR, dateStrs[0]);
        map.put(MONTH, dateStrs[1]);
        map.put(YEARMONTH, dateStr);
        return map;
    }

    public Map<String, String> returnYearAndMonthUseMapInNowDateNext(String dateStr, String format, String dataRule) {
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        Date date = DateUtils.parse(dateStr, format);
        return this.returnYearAndMonthUseMapInNowDateNext(date, format, dataRule);
    }

    public Map<String, String> returnStarAndEndDateUseMapDate(String yearMonth, String format) {
        return this.returnStarAndEndDateUseMapDate(yearMonth, format, null);
    }

    public Map<String, String> returnStarAndEndDateUseMapDate(String yearMonth, String format, String dateType) {
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        Date date = DateUtils.parse(yearMonth, format);
        return this.returnStarAndEndDateUseMapDate(date, FORMATTER_YMD, dateType);
    }

    public Map<String, String> returnStarAndEndDateUseMapDate(Date date, String format, String dateType) {
        HashMap<String, String> map = new HashMap<String, String>();
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        dateType = StringUtil.isNotEmpty((CharSequence)dateType) ? dateType : MONTH;
        String starDate = this.getFirstDateStr(date, format, dateType);
        String dateNRegular = dateType + ":1," + DATE + ":-1";
        String endDate = this.returnComputationsDateStr(starDate, format, dateNRegular);
        map.put(STARTDATE, starDate);
        map.put(ENDDATE, endDate);
        return map;
    }

    public String returnComputationsDateStr(String srcDateStr, String format, String chooseType, int n) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        Date date = DateUtils.parse(srcDateStr, format);
        map.put(this.returnNotNullChooseType(chooseType), n);
        String dateStr = this.getDateStr(date, format, map);
        return dateStr;
    }

    public String returnComputationsDateStr(String srcDateStr, String format, String dateNRegular) {
        Map<String, Integer> map = this.changeSaveTypeByMap(dateNRegular);
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        Date date = DateUtils.parse(srcDateStr, format);
        String dateStr = this.getDateStr(date, format, map);
        return dateStr;
    }

    public String returnComputationsDateStr(Date date, String format, String dateNRegular) {
        Map<String, Integer> map = this.changeSaveTypeByMap(dateNRegular);
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        String dateStr = this.getDateStr(date, format, map);
        return dateStr;
    }

    public Date returnComputationsDate(Date date, String dateNRegular) {
        Map<String, Integer> map = this.changeSaveTypeByMap(dateNRegular);
        return this.returnDate(date, map);
    }

    public Date returnComputationsDate(String srcDateStr, String format, String dateNRegular) {
        Map<String, Integer> map = this.changeSaveTypeByMap(dateNRegular);
        format = StringUtil.isNotEmpty((CharSequence)format) ? format : FORMATTER_YMD;
        Date date = DateUtils.parse(srcDateStr, format);
        return this.returnDate(date, map);
    }

    private String getDateStr(Date date, String format, Map<String, Integer> map) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return this.returnDateStr(date, dateFormat, map);
    }

    private String getFirstDateStr(Date date, String format, String dateType) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return this.returnFirstDateStr(date, dateFormat, dateType);
    }

    private String returnFirstDateStr(Date date, SimpleDateFormat dateFormat, String dateType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.switchCalendarDateType(calendar, dateType);
        return dateFormat.format(calendar.getTime());
    }

    private String returnDateStr(Date date, SimpleDateFormat dateFormat, Map<String, Integer> map) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.switchCalendarYearMonthDate(calendar, map);
        return dateFormat.format(calendar.getTime());
    }

    private Date returnDate(Date date, Map<String, Integer> map) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.switchCalendarYearMonthDate(calendar, map);
        return calendar.getTime();
    }

    private void switchCalendarYearMonthDate(Calendar calendar, Map<String, Integer> map) {
        Set<String> keyStrs = map.keySet();
        Iterator<String> iterator = keyStrs.iterator();
        block16: while (iterator.hasNext()) {
            String str;
            switch (str = iterator.next()) {
                case "YEAR": {
                    calendar.add(1, map.get(str));
                    continue block16;
                }
                case "MONTH": {
                    calendar.add(2, map.get(str));
                    continue block16;
                }
                case "DATE": {
                    calendar.add(5, map.get(str));
                    continue block16;
                }
                case "HOUR": {
                    calendar.add(10, map.get(str));
                    continue block16;
                }
                case "MINUTE": {
                    calendar.add(12, map.get(str));
                    continue block16;
                }
                case "SECOND": {
                    calendar.add(13, map.get(str));
                    continue block16;
                }
            }
            throw new BusinessException("\u65e5\u671f\u8ba1\u7b97\u5931\u8d25,\u89c4\u5219\uff1a" + str + ":" + map.get(str));
        }
    }

    private void switchCalendarDateType(Calendar calendar, String targ) {
        switch (targ) {
            case "YEAR": {
                calendar.add(1, 0);
                calendar.set(6, 1);
                break;
            }
            case "MONTH": {
                calendar.add(2, 0);
                calendar.set(5, 1);
                break;
            }
            default: {
                throw new BusinessException("\u83b7\u53d6\u7b2c\u4e00\u5929\u65f6\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u83b7\u53d6\u7b2c\u4e00\u5929\u7684\u65f6\u95f4\u8303\u56f4\u3002\u4f8b\uff1a\u5e74\u6216\u6708");
            }
        }
    }

    private String returnNotNullChooseType(String chooseType) {
        return StringUtil.isNotEmpty((CharSequence)chooseType) ? chooseType : DATE;
    }

    private Map<String, Integer> changeSaveTypeByMap(String dateNRegular) {
        String[] dateNRegulars;
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        if (!StringUtil.isNotEmpty((CharSequence)dateNRegular)) {
            throw new BusinessException("\u76f8\u5dee\u5929\u6570\uff0c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String strs : dateNRegulars = dateNRegular.split(",")) {
            String[] dateStrs = strs.split(":");
            if (dateStrs.length != 2) {
                throw new BusinessException("\u76f8\u5dee\u5929\u6570\uff0c\u8868\u8fbe\u5f0f(" + dateNRegular + ")\u9519\u8bef\uff1a\u4f8b\uff1a YEAR:-1,MONTH:-2,DATE:1 \u6216 YEAR:-1,DATE:1 ;");
            }
            map.put(dateStrs[0], Integer.parseInt(dateStrs[1]));
        }
        return map;
    }

    public String checkTheDateStrIsMacthRegexAndReturn(String dateStr, String regex) {
        regex = StringUtil.isNotEmpty((CharSequence)regex) ? regex : FORMATTER_YMD;
        SimpleDateFormat sdf = new SimpleDateFormat(regex);
        sdf.setLenient(false);
        try {
            Date date = sdf.parse(dateStr);
            return sdf.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BusinessException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e5\u671f\u683c\u5f0f\u4e3a\uff08" + regex + "\uff09");
        }
    }
}

