/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import com.biz.eisp.base.common.exception.BusinessException;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.CollectionUtils;

public class ListCopyUtil {
    public static <T> List<T> deepCopyList(List<T> src) {
        List dest = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(src);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            dest = (List)in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return dest;
    }

    public static <T> List<T> batchTransform(Class<T> clazz, List<? extends Object> srcList) {
        if (CollectionUtils.isEmpty(srcList)) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(srcList.size());
        for (Object object : srcList) {
            result.add(ListCopyUtil.transfrom(clazz, object));
        }
        return result;
    }

    private static <T> T transfrom(Class<T> clazz, Object src) {
        if (src == null) {
            return null;
        }
        T instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        BeanUtils.copyProperties((Object)src, instance, (String[])ListCopyUtil.getNullPropertyNames(src));
        return instance;
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
}

