/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.tk.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ObjectUtils;

public abstract class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray((Object)source));
    }

    public static <E> void mergeArrayIntoCollection(Object array, Collection<E> collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        for (Object elem : arr = ObjectUtils.toObjectArray((Object)array)) {
            collection.add(elem);
        }
    }

    public static <K, V> void mergePropertiesIntoMap(Properties props, Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.get(key);
                if (value == null) {
                    value = props.getProperty(key);
                }
                map.put(key, value);
            }
        }
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, (Object)element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration<?> enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, (Object)element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection<?> collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static <E> E findFirstMatch(Collection<?> source, Collection<E> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (E candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> collection, Class<T> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty((Object[])types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = CollectionUtils.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

