/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiResultUtil {
    public static boolean checkResult(AjaxJson json) {
        if (json != null) {
            return json.isSuccess();
        }
        return false;
    }

    public static <T> T objResult(AjaxJson<T> json) {
        return ApiResultUtil.objResult(json, false);
    }

    public static <T> T objResult(AjaxJson<T> json, boolean notNull) {
        if (ApiResultUtil.checkResult(json)) {
            return json.getObj();
        }
        if (notNull) {
            throw new BusinessException(json.getMsg());
        }
        return json.getObj();
    }

    public static <T> List<T> listResult(AjaxJson<T> json) {
        return ApiResultUtil.listResult(json, false);
    }

    public static <T> List<T> listResult(AjaxJson<T> json, boolean notNull) {
        if (ApiResultUtil.checkResult(json)) {
            return json.getObjList();
        }
        if (notNull) {
            return new ArrayList();
        }
        throw new BusinessException(json.getMsg());
    }

    public static <T> PageInfo<T> pageInfoResult(AjaxJson<T> json) {
        return ApiResultUtil.pageInfoResult(json, false);
    }

    public static <T> PageInfo<T> pageInfoResult(AjaxJson<T> json, boolean notNull) {
        if (ApiResultUtil.checkResult(json)) {
            return json.getPageInfo();
        }
        if (notNull) {
            return new PageInfo();
        }
        throw new BusinessException(json.getMsg());
    }

    public static <T> Map<String, T> mapResult(AjaxJson<T> json) {
        return ApiResultUtil.mapResult(json, false);
    }

    public static <T> Map<String, T> mapResult(AjaxJson<T> json, boolean notNull) {
        if (ApiResultUtil.checkResult(json)) {
            return json.getMapT();
        }
        if (notNull) {
            return new HashMap();
        }
        throw new BusinessException(json.getMsg());
    }
}

