/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.tools;

import com.biz.eisp.api.feign.KnlDictFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.service.RedisService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictUtil {
    private static RedisService redisService;
    private static KnlDictFeign knlDictFeign;

    public static void getKnlDictFeign() {
        if (knlDictFeign == null) {
            knlDictFeign = (KnlDictFeign)SpringApplicationContextUtil.getApplicationContext().getBean("knlDictFeign");
        }
    }

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    public static Map<Object, Object> getDictMap(String typeCode) {
        DictUtil.getRedisService();
        Map map = redisService.hmget("DICT_DATA_" + typeCode);
        if (map == null || map.size() == 0) {
            DictUtil.getKnlDictFeign();
            List<KnlDictDataEntity> dataEntities = ApiResultUtil.listResult(knlDictFeign.getDictByParamList(typeCode), true);
            if (CollectionUtil.listNotEmptyNotSizeZero(dataEntities)) {
                HashMap<Object, Object> map_ = new HashMap<Object, Object>();
                dataEntities.forEach(item -> map_.put(item.getDictCode(), item));
                return map_;
            }
        }
        return map;
    }

    public static KnlDictDataEntity getDicData(String typeCode, String dataCode) {
        KnlDictDataEntity data = null;
        DictUtil.getRedisService();
        Object object = redisService.hget("DICT_DATA_" + typeCode, dataCode);
        if (object != null) {
            data = (KnlDictDataEntity)object;
        } else {
            DictUtil.getKnlDictFeign();
            KnlDictDataEntity o = ApiResultUtil.objResult(knlDictFeign.getDictByParamObj(typeCode, dataCode), false);
            if (o != null) {
                data = o;
            }
        }
        return data;
    }

    public static String getDictDataVal(String typeCode, String dataCode) {
        KnlDictDataEntity data = null;
        DictUtil.getRedisService();
        Object object = redisService.hget("DICT_DATA_" + typeCode, dataCode);
        if (object != null) {
            data = (KnlDictDataEntity)object;
            return data.getDictValue();
        }
        data = DictUtil.getDicData(typeCode, dataCode);
        if (data != null) {
            return data.getDictValue();
        }
        return "";
    }

    public static String gettDictDataFieldCodeVal(String typeCode, String dataCode, String fieldCode) {
        KnlDictDataEntity data = DictUtil.getDicData(typeCode, dataCode);
        if (null == data) {
            return "";
        }
        Map<String, Object> map = data.getExtendMap();
        if (map == null || map.size() == 0) {
            return "";
        }
        String fieldName = OConvertUtils.getString(map.get(fieldCode));
        return fieldName;
    }

    public static List<KnlDictDataEntity> getDictList(String dictType) {
        ArrayList<KnlDictDataEntity> list = new ArrayList<KnlDictDataEntity>();
        Map<Object, Object> map = DictUtil.getDictMap(dictType);
        if (map == null || map.size() <= 0) {
            DictUtil.getKnlDictFeign();
            return ApiResultUtil.listResult(knlDictFeign.getDictByParamList(dictType));
        }
        map.forEach((k, v) -> {
            KnlDictDataEntity entity = (KnlDictDataEntity)v;
            list.add(entity);
        });
        return list;
    }

    public static List<KnlDictDataEntity> getDictListByParentId(String parentId) {
        Object o = redisService.get(parentId);
        if (o == null) {
            DictUtil.getKnlDictFeign();
            AjaxJson<KnlDictDataEntity> dataEntityAjaxJson = knlDictFeign.getDictListByParentId(parentId);
            return ApiResultUtil.listResult(dataEntityAjaxJson);
        }
        return (List)o;
    }
}

