/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static final AjaxJson sendHttpRequest(String url, List<Header> headerList, String params, NameValuePair[] paramsList, String body, String encoding, int timeout) throws IOException {
        Object requestEntity;
        AjaxJson<String> ajaxJson = new AjaxJson<String>();
        HttpClient httpClient = new HttpClient();
        if (StringUtils.isEmpty((CharSequence)url)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a.");
            return ajaxJson;
        }
        if (body.equals("x-www-form-urlencoded")) {
            if (null == paramsList || paramsList.length <= 0) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
                return ajaxJson;
            }
        } else if (body.equals("raw") && null == params) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a.");
            return ajaxJson;
        }
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setContentCharset(encoding);
        postMethod.getParams().setHttpElementCharset(encoding);
        if (headerList != null) {
            for (Header header : headerList) {
                postMethod.addRequestHeader(header);
            }
        }
        if (body.equals("raw")) {
            postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            requestEntity = new StringRequestEntity(params, "application/json", "UTF-8");
            postMethod.setRequestEntity((RequestEntity)requestEntity);
        } else if (body.equals("x-www-form-urlencoded")) {
            postMethod.setRequestBody(paramsList);
        }
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            if (postMethod.getStatusCode() == 200) {
                ajaxJson.setSuccess(true);
                ajaxJson.setObj(postMethod.getResponseBodyAsString());
                requestEntity = ajaxJson;
                return requestEntity;
            }
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(postMethod.getResponseBodyAsString());
            requestEntity = ajaxJson;
            return requestEntity;
        }
        catch (HttpException e) {
            log.error("", (Throwable)e);
            throw new HttpException(((Object)((Object)e)).getClass().getName());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new IOException(e.getClass().getName());
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String sendRequest(String url, List<Header> headerList, RequestEntity requestEntry, String encoding, int timeout) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "url empty";
        }
        if (null == requestEntry) {
            return "requestEntry empty";
        }
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setContentCharset(encoding);
        postMethod.getParams().setHttpElementCharset(encoding);
        if (headerList != null) {
            for (Object header : headerList) {
                postMethod.addRequestHeader(header);
            }
        }
        postMethod.setRequestEntity(requestEntry);
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        try {
            Object header;
            httpClient.executeMethod((HttpMethod)postMethod);
            if (postMethod.getStatusCode() == 200) {
                header = postMethod.getResponseBodyAsString();
                return header;
            }
            header = postMethod.getResponseBodyAsString();
            return header;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AjaxJson sendRequest(String url, NameValuePair[] paramsList, String encoding, int timeout) {
        AjaxJson<String> ajaxJson = new AjaxJson<String>();
        String tmpencoding = encoding;
        int tmptimeout = timeout;
        if (StringUtils.isEmpty((CharSequence)url)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a.");
            return ajaxJson;
        }
        if (StringUtils.isBlank((CharSequence)encoding)) {
            tmpencoding = "UTF-8";
        }
        if (timeout <= 0) {
            tmptimeout = 5000;
        }
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setContentCharset(tmpencoding);
        postMethod.getParams().setHttpElementCharset(tmpencoding);
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(tmptimeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(tmptimeout);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            if (postMethod.getStatusCode() == 200) {
                ajaxJson.setSuccess(true);
                ajaxJson.setObj(postMethod.getResponseBodyAsString());
                AjaxJson<String> ajaxJson2 = ajaxJson;
                return ajaxJson2;
            }
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(postMethod.getResponseBodyAsString());
            AjaxJson<String> ajaxJson3 = ajaxJson;
            return ajaxJson3;
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8bf7\u6c42\u5f02\u5e38.");
            AjaxJson<String> ajaxJson4 = ajaxJson;
            return ajaxJson4;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public static final String postHttp(String url, String params, String encoding) throws UnsupportedEncodingException {
        String responseMsg = "";
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setContentCharset(encoding);
        PostMethod postMethod = new PostMethod(url);
        ByteArrayInputStream requestIO = new ByteArrayInputStream(params.getBytes("UTF-8"));
        InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)requestIO);
        postMethod.setRequestEntity((RequestEntity)entity);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            responseMsg = postMethod.getResponseBodyAsString();
        }
        catch (HttpException e) {
            log.error("", (Throwable)e);
            throw new UnsupportedEncodingException(((Object)((Object)e)).getClass().getName());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new UnsupportedEncodingException(e.getClass().getName());
        }
        finally {
            postMethod.releaseConnection();
        }
        return responseMsg;
    }

    public static final String postHttp(String url, String params) throws UnsupportedEncodingException {
        String responseMsg = "";
        HttpClient httpClient = new HttpClient(new HttpClientParams(), (HttpConnectionManager)new SimpleHttpConnectionManager(true));
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(10000);
        httpClient.getParams().setContentCharset("UTF-8");
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        postMethod.setRequestBody(params);
        postMethod.setRequestHeader("Connection", "close");
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            responseMsg = postMethod.getResponseBodyAsString();
        }
        catch (HttpException e) {
            log.error("", (Throwable)e);
            throw new UnsupportedEncodingException(((Object)((Object)e)).getClass().getName());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new UnsupportedEncodingException(e.getClass().getName());
        }
        finally {
            postMethod.releaseConnection();
            httpClient.getHttpConnectionManager().closeIdleConnections(0L);
        }
        return responseMsg;
    }

    public static final String post(String url, String params, int timeout) throws IOException {
        String responseMsg = "";
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setContentCharset("UTF-8");
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "application/json");
        if (timeout <= 0) {
            timeout = 5000;
        }
        postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        StringRequestEntity requestEntity = new StringRequestEntity(params, "application/json", "UTF-8");
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(timeout);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            responseMsg = postMethod.getResponseBodyAsString();
        }
        catch (HttpException e) {
            log.error("", (Throwable)e);
            throw new HttpException(((Object)((Object)e)).getClass().getName());
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new IOException(e.getClass().getName());
        }
        finally {
            postMethod.releaseConnection();
        }
        return responseMsg;
    }

    public static synchronized String postData(String url, Map<String, String> params, String codePage) throws IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
        PostMethod method = new PostMethod(url);
        if (params != null) {
            method.getParams().setParameter("http.protocol.content-charset", (Object)codePage);
            method.setRequestBody(HttpUtils.assembleRequestParams(params));
        }
        String result = "";
        try {
            httpClient.executeMethod((HttpMethod)method);
            result = new String(method.getResponseBody(), codePage);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    public static synchronized String postDataRequestBody(String url, String params, String codePage) throws IOException {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(5000);
        PostMethod method = new PostMethod(url);
        if (params != null) {
            method.getParams().setParameter("http.protocol.content-charset", (Object)codePage);
            method.setRequestBody(params);
        }
        String result = "";
        try {
            httpClient.executeMethod((HttpMethod)method);
            result = new String(method.getResponseBody(), codePage);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postHttp(String url, NameValuePair[] data) {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setContentCharset("utf-8");
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        postMethod.setRequestBody(data);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String str = "";
            while ((str = br.readLine()) != null) {
                stringBuffer.append(str);
            }
        }
        catch (HttpException e) {
            log.error("", (Throwable)e);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            postMethod.releaseConnection();
        }
        return stringBuffer.toString();
    }

    public static String httpClient(String url, String params, String chartSet) {
        String jsonResponse = "";
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(url);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        method.getParams().setContentCharset(chartSet);
        method.getParams().setHttpElementCharset(chartSet);
        try {
            System.out.println("\u8bf7\u6c42\u53d1\u51fa\u524d\u6d88\u606f\uff1a" + params);
            StringRequestEntity entity = null;
            entity = new StringRequestEntity(params, "application/json", "UTF-8");
            method.setRequestEntity((RequestEntity)entity);
            method.addRequestHeader("Content-Type", "application/json;charset=UTF-8");
            int statuCode = client.executeMethod((HttpMethod)method);
            jsonResponse = method.getResponseBodyAsString();
            System.out.println("\u54cd\u5e94\u6d88\u606f\uff1a" + jsonResponse);
            if (statuCode == 200) {
                System.out.println("response is ok!");
            }
        }
        catch (HttpException e) {
            log.error("", (Throwable)e);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return jsonResponse;
    }

    public static String sendPostRequest(String urlStr, String params) {
        String data = params;
        String response = "";
        try {
            String line;
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(data);
            writer.flush();
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            response = answer.toString();
            System.out.println("\u83dc\u9e1f\u5f02\u5e38\u54cd\u5e94\uff1a" + response);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJstHttpResult(String urlStr, String content) {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            url = new URL(urlStr);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(content.getBytes("utf-8"));
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGetRequest(String url, String charset) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        GetMethod getMethod = new GetMethod(url);
        getMethod.getParams().setParameter("http.socket.timeout", (Object)5000);
        getMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        String response = "";
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                System.out.println("\u8bf7\u6c42\u51fa\u9519: " + getMethod.getStatusLine());
            }
            byte[] responseBody = getMethod.getResponseBody();
            response = new String(responseBody, charset);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
        return response;
    }

    private static synchronized NameValuePair[] assembleRequestParams(Map<String, String> data) {
        ArrayList<NameValuePair> nameValueList = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            nameValueList.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        return nameValueList.toArray(new NameValuePair[nameValueList.size()]);
    }
}

