/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StringUtil
extends StringUtils {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    private static Pattern numericPattern = Pattern.compile("^[0-9\\-]+$");
    private static Pattern numericStringPattern = Pattern.compile("^[0-9\\-\\-]+$");
    private static Pattern floatNumericPattern = Pattern.compile("^[0-9\\-\\.]+$");
    private static Pattern abcPattern = Pattern.compile("^[a-z|A-Z]+$");
    public static final String splitStrPattern = ",|\uff0c|;|\uff1b|\u3001|\\.|\u3002|-|_|\\(|\\)|\\[|\\]|\\{|\\}|\\\\|/| |\u3000|\"";
    private static Log logger = LogFactory.getLog(StringUtil.class);

    public static boolean isNumeric(String src) {
        Matcher m;
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = numericPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static boolean hasNumeric(String src) {
        Pattern p;
        Matcher m;
        boolean flag = false;
        if (src != null && src.length() > 0 && (m = (p = Pattern.compile(".*\\d+.*")).matcher(src)).matches()) {
            flag = true;
        }
        return flag;
    }

    public static boolean isNumericString(String src) {
        Matcher m;
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = numericStringPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static boolean isABC(String src) {
        Matcher m;
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = abcPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static boolean isFloatNumeric(String src) {
        Matcher m;
        boolean return_value = false;
        if (src != null && src.length() > 0 && (m = floatNumericPattern.matcher(src)).find()) {
            return_value = true;
        }
        return return_value;
    }

    public static String joinString(List array, String symbol) {
        StringBuffer result = new StringBuffer();
        String out = "";
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                String temp = array.get(i).toString();
                if (temp != null && temp.trim().length() > 0) {
                    result.append(temp);
                }
                result.append(symbol);
            }
            out = result.toString();
            if (result.length() > 1) {
                out = out.substring(0, result.length() - 1);
            }
        }
        return out;
    }

    public static String subStringNotEncode(String subject, int size) {
        if (subject != null && subject.length() > size) {
            subject = subject.substring(0, size) + "...";
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLimitLengthString(String str, int len, String symbol) {
        int iLen = len * 2;
        int counterOfDoubleByte = 0;
        String strRet = "";
        try {
            if (str != null) {
                byte[] b = str.getBytes("GBK");
                if (b.length <= iLen) {
                    String string = str;
                    return string;
                }
                for (int i = 0; i < iLen; ++i) {
                    if (b[i] >= 0) continue;
                    ++counterOfDoubleByte;
                }
                if (counterOfDoubleByte % 2 == 0) {
                    String string = strRet = new String(b, 0, iLen, "GBK") + symbol;
                    return string;
                }
                String string = strRet = new String(b, 0, iLen - 1, "GBK") + symbol;
                return string;
            }
            String b = "";
            return b;
        }
        catch (Exception ex) {
            String string = str.substring(0, len);
            return string;
        }
        finally {
            strRet = null;
        }
    }

    public static String getLimitLengthString(String str, int len) {
        return StringUtil.getLimitLengthString(str, len, "...");
    }

    public static String subStrNotEncode(String subject, int size) {
        if (subject.length() > size) {
            subject = subject.substring(0, size);
        }
        return subject;
    }

    public static String joinString(String[] array, String symbol) {
        String result = "";
        if (array != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                String temp = array[i];
                if (temp != null && temp.trim().length() > 0) {
                    sb.append(temp);
                }
                sb.append(symbol);
            }
            if (sb.length() > 1) {
                result = sb.toString().substring(0, sb.toString().length() - 1);
            }
        }
        return result;
    }

    public static int getStringLen(String SrcStr) {
        int return_value = 0;
        if (SrcStr != null) {
            char[] theChars = SrcStr.toCharArray();
            for (int i = 0; i < theChars.length; ++i) {
                return_value += theChars[i] <= '\u00ff' ? 1 : 2;
            }
        }
        return return_value;
    }

    public static boolean check(String str) {
        String sIllegal = "'\"";
        int len = sIllegal.length();
        if (null == str) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (str.indexOf(sIllegal.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static String getHideEmailPrefix(String email) {
        int index;
        if (null != email && (index = email.lastIndexOf(64)) > 0) {
            email = StringUtil.repeat("*", index).concat(email.substring(index));
        }
        return email;
    }

    public static String repeat(String src, int num) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            s.append(src);
        }
        return s.toString();
    }

    public static String toString(Object str) {
        return str == null ? "" : str.toString();
    }

    public static List<String> parseString2ListByCustomerPattern(String pattern, String src) {
        if (src == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] result = src.split(pattern);
        for (int i = 0; i < result.length; ++i) {
            list.add(result[i]);
        }
        return list;
    }

    public static List<String> parseString2ListByPattern(String src) {
        String pattern = "\uff0c|,|\u3001|\u3002";
        return StringUtil.parseString2ListByCustomerPattern(pattern, src);
    }

    public static String formatFloat(float f, String format) {
        DecimalFormat df = new DecimalFormat(format);
        return df.format(f);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static List<String> splitToList(String split, String src) {
        ArrayList<String> r = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)src)) {
            int index;
            String sp = ",";
            if (split != null && split.length() == 1) {
                sp = split;
            }
            int lastIndex = -1;
            int n = index = StringUtils.isNotBlank((CharSequence)sp) ? src.indexOf(sp) : -1;
            if (-1 == index && src != null) {
                r.add(src);
                return r;
            }
            while (index >= 0) {
                if (index > lastIndex) {
                    r.add(src.substring(lastIndex + 1, index));
                } else {
                    r.add("");
                }
                lastIndex = index;
                if ((index = src.indexOf(sp, index + 1)) != -1) continue;
                r.add(src.substring(lastIndex + 1, src.length()));
            }
        }
        return r;
    }

    public static String linkedHashMapToString(LinkedHashMap<String, String> map) {
        if (map != null && map.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                sb.append(sb.length() == 0 ? "" : "&");
                sb.append(String.format("%s=%s", name, value));
            }
            return sb.toString();
        }
        return null;
    }

    public static LinkedHashMap<String, String> toLinkedHashMap(String str) {
        if (str != null && !str.equals("") && str.indexOf("=") > 0) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            String name = null;
            String value = null;
            block4: for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '=': {
                        value = "";
                        continue block4;
                    }
                    case '&': {
                        if (name != null && value != null && !name.equals("")) {
                            result.put(name, value);
                        }
                        name = null;
                        value = null;
                        continue block4;
                    }
                    default: {
                        if (value != null) {
                            value = value + c;
                            continue block4;
                        }
                        name = name != null ? name + c : "" + c;
                    }
                }
            }
            if (name != null && value != null && !name.equals("")) {
                result.put(name, value);
            }
            return result;
        }
        return null;
    }

    public static String getCaption(String captions, int index) {
        String[] ss;
        if (index > 0 && captions != null && !captions.equals("") && (ss = captions.split(",")) != null && ss.length > 0 && index < ss.length) {
            return ss[index];
        }
        return null;
    }

    public static String numberToString(Object num) {
        if (num == null) {
            return null;
        }
        if (num instanceof Integer && (Integer)num > 0) {
            return Integer.toString((Integer)num);
        }
        if (num instanceof Long && (Long)num > 0L) {
            return Long.toString((Long)num);
        }
        if (num instanceof Float && ((Float)num).floatValue() > 0.0f) {
            return Float.toString(((Float)num).floatValue());
        }
        if (num instanceof Double && (Double)num > 0.0) {
            return Double.toString((Double)num);
        }
        return "";
    }

    public static String moneyToString(Object money, String style) {
        if (money != null && style != null && (money instanceof Double || money instanceof Float)) {
            Double num = (Double)money;
            if (style.equalsIgnoreCase("default")) {
                if (num == 0.0) {
                    return "";
                }
                if (num * 10.0 % 10.0 == 0.0) {
                    return Integer.toString(num.intValue());
                }
                return num.toString();
            }
            DecimalFormat df = new DecimalFormat(style);
            return df.format(num);
        }
        return null;
    }

    public static boolean strPos(String sou, String ... finds) {
        if (sou != null && finds != null && finds.length > 0) {
            for (int i = 0; i < finds.length; ++i) {
                if (sou.indexOf(finds[i]) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean strPos(String sou, List<String> finds) {
        if (sou != null && finds != null && finds.size() > 0) {
            for (String s : finds) {
                if (sou.indexOf(s) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean strPos(String sou, String finds) {
        List<String> t = StringUtil.splitToList(",", finds);
        return StringUtil.strPos(sou, t);
    }

    public static boolean equals(String s1, String s2) {
        if (StringUtil.isEmpty(s1) && StringUtil.isEmpty(s2)) {
            return true;
        }
        if (!StringUtil.isEmpty(s1) && !StringUtil.isEmpty(s2)) {
            return s1.equals(s2);
        }
        return false;
    }

    public static int toInt(String s) {
        if (s != null && !"".equals(s.trim())) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public static double toDouble(String s) {
        if (s != null && !"".equals(s.trim())) {
            return Double.parseDouble(s);
        }
        return 0.0;
    }

    public static Object xmlToObject(String xml) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF8"));
            XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(in));
            return decoder.readObject();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static long toLong(String s) {
        try {
            if (s != null && !"".equals(s.trim())) {
                return Long.parseLong(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public static String simpleEncrypt(String str) {
        if (str != null && str.length() > 0) {
            str = str.replaceAll("1", "b");
            str = str.replaceAll("3", "d");
            str = str.replaceAll("5", "f");
            str = str.replaceAll("6", "g");
            str = str.replaceAll("7", "h");
            str = str.replaceAll("8", "i");
            str = str.replaceAll("9", "j");
        }
        return str;
    }

    public static String removeURL(String str) {
        if (str != null) {
            str = str.toLowerCase().replaceAll("(http|www|com|cn|org|\\.)+", "");
        }
        return str;
    }

    public static String numRandom(int bit) {
        if (bit == 0) {
            bit = 6;
        }
        String str = "";
        str = "0123456789";
        return RandomStringUtils.random((int)bit, (String)str);
    }

    public static String random(int bit) {
        if (bit == 0) {
            bit = 6;
        }
        String str = "";
        str = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz";
        return RandomStringUtils.random((int)bit, (String)str);
    }

    public static String replaceWapStr(String str) {
        if (str != null) {
            str = str.replaceAll("<span class=\"keyword\">", "");
            str = str.replaceAll("</span>", "");
            str = str.replaceAll("<strong class=\"keyword\">", "");
            str = str.replaceAll("<strong>", "");
            str = str.replaceAll("</strong>", "");
            str = str.replace('$', '\uff04');
            str = str.replaceAll("&amp;", "\uff06");
            str = str.replace('&', '\uff06');
            str = str.replace('<', '\uff1c');
            str = str.replace('>', '\uff1e');
        }
        return str;
    }

    public static Float toFloat(String s) {
        try {
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException e) {
            return new Float(0.0f);
        }
    }

    public static String replaceBlank(String str) {
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            str = m.replaceAll("");
        }
        return str;
    }

    public static String Q2B(String QJstr) {
        String outStr = "";
        String Tstr = "";
        byte[] b = null;
        for (int i = 0; i < QJstr.length(); ++i) {
            block6: {
                try {
                    Tstr = QJstr.substring(i, i + 1);
                    b = Tstr.getBytes("unicode");
                }
                catch (UnsupportedEncodingException e) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error((Object)e);
                }
            }
            if (b[3] == -1) {
                b[2] = (byte)(b[2] + 32);
                b[3] = 0;
                try {
                    outStr = outStr + new String(b, "unicode");
                }
                catch (UnsupportedEncodingException ex) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error((Object)ex);
                }
                continue;
            }
            outStr = outStr + Tstr;
        }
        return outStr;
    }

    public static String changCoding(String s, String fencode, String bencode) {
        try {
            String str = StringUtil.isNotEmpty((CharSequence)s) ? new String(s.getBytes(fencode), bencode) : "";
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String removeHTMLLableExe(String str) {
        str = StringUtil.stringReplace(str, ">\\s*<", "><");
        str = StringUtil.stringReplace(str, "&nbsp;", " ");
        str = StringUtil.stringReplace(str, "<br ?/?>", "\n");
        str = StringUtil.stringReplace(str, "<([^<>]+)>", "");
        str = StringUtil.stringReplace(str, "\\s\\s\\s*", " ");
        str = StringUtil.stringReplace(str, "^\\s*", "");
        str = StringUtil.stringReplace(str, "\\s*$", "");
        str = StringUtil.stringReplace(str, " +", " ");
        return str;
    }

    public static String removeHTMLLable(String str) {
        str = StringUtil.stringReplace(str, "\\s", "");
        str = StringUtil.stringReplace(str, "<br ?/?>", "\n");
        str = StringUtil.stringReplace(str, "<([^<>]+)>", "");
        str = StringUtil.stringReplace(str, "&nbsp;", " ");
        str = StringUtil.stringReplace(str, "&(\\S)(\\S?)(\\S?)(\\S?);", "");
        return str;
    }

    public static String removeOutHTMLLable(String str) {
        str = StringUtil.stringReplace(str, ">([^<>]+)<", "><");
        str = StringUtil.stringReplace(str, "^([^<>]+)<", "<");
        str = StringUtil.stringReplace(str, ">([^<>]+)$", ">");
        return str;
    }

    public static String stringReplace(String str, String sr, String sd) {
        String regEx = sr;
        Pattern p = Pattern.compile(regEx, 2);
        Matcher m = p.matcher(str);
        str = m.replaceAll(sd);
        return str;
    }

    public static String fomateToFullForm(String str, String pt) {
        String regEx = "<" + pt + "\\s+([\\S&&[^<>]]*)/>";
        Pattern p = Pattern.compile(regEx, 2);
        Matcher m = p.matcher(str);
        String[] sa = null;
        String sf = "";
        String sf2 = "";
        String sf3 = "";
        while (m.find() && (sa = p.split(str)) != null) {
            sf = str.substring(sa[0].length(), str.indexOf("/>", sa[0].length()));
            sf2 = sf + "></" + pt + ">";
            sf3 = str.substring(sa[0].length() + sf.length() + 2);
            str = sa[0] + sf2 + sf3;
            sa = null;
        }
        return str;
    }

    public static int[] getSubStringPos(String str, String sub, boolean b) {
        String[] sp = null;
        int l = sub.length();
        sp = StringUtil.splitString(str, sub);
        if (sp == null) {
            return null;
        }
        int[] ip = new int[sp.length - 1];
        for (int i = 0; i < sp.length - 1; ++i) {
            ip[i] = sp[i].length() + l;
            if (i == 0) continue;
            int n = i;
            ip[n] = ip[n] + ip[i - 1];
        }
        if (b) {
            for (int j = 0; j < ip.length; ++j) {
                ip[j] = ip[j] - l;
            }
        }
        return ip;
    }

    public static String[] splitString(String str, String ms) {
        String regEx = ms;
        Pattern p = Pattern.compile(regEx, 2);
        String[] sp = p.split(str);
        return sp;
    }

    public static String[] getStringArrayByPattern(String str, String pattern) {
        Pattern p = Pattern.compile(pattern, 2);
        Matcher matcher = p.matcher(str);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                result.add(matcher.group(i));
            }
        }
        String[] resultStr = null;
        if (result.size() > 0) {
            resultStr = new String[result.size()];
            return result.toArray(resultStr);
        }
        return resultStr;
    }

    public static String[] midString(String s, String b, String e) {
        int i = s.indexOf(b) + b.length();
        int j = s.indexOf(e, i);
        String[] sa = new String[2];
        if (i < b.length() || j < i + 1 || i > j) {
            sa[1] = s;
            sa[0] = null;
            return sa;
        }
        sa[0] = s.substring(i, j);
        sa[1] = s.substring(j);
        return sa;
    }

    public static String stringReplace(String s, String pf, String pb, int start) {
        Pattern pattern_hand = Pattern.compile(pf);
        Matcher matcher_hand = pattern_hand.matcher(s);
        int gc = matcher_hand.groupCount();
        int pos = start;
        String sf1 = "";
        String sf2 = "";
        String sf3 = "";
        int if1 = 0;
        String strr = "";
        while (matcher_hand.find(pos)) {
            sf1 = matcher_hand.group();
            if1 = s.indexOf(sf1, pos);
            if (if1 >= pos) {
                strr = strr + s.substring(pos, if1);
                pos = if1 + sf1.length();
                sf2 = pb;
                for (int i = 1; i <= gc; ++i) {
                    sf3 = "\\" + i;
                    sf2 = StringUtil.replaceAll(sf2, sf3, matcher_hand.group(i));
                }
                strr = strr + sf2;
                continue;
            }
            return s;
        }
        strr = s.substring(0, start) + strr;
        return strr;
    }

    public static String replaceAll(String s, String sf, String sb) {
        int i = 0;
        int j = 0;
        int l = sf.length();
        boolean b = true;
        boolean o = true;
        String str = "";
        do {
            if ((i = s.indexOf(sf, j = i)) > j) {
                str = str + s.substring(j, i);
                str = str + sb;
                i += l;
                o = false;
                continue;
            }
            str = str + s.substring(j);
            b = false;
        } while (b);
        if (o) {
            str = s;
        }
        return str;
    }

    public static String replace(String strSource, String strOld, String strNew) {
        if (strSource == null) {
            return null;
        }
        int i = 0;
        if ((i = strSource.indexOf(strOld, i)) >= 0) {
            char[] cSrc = strSource.toCharArray();
            char[] cTo = strNew.toCharArray();
            int len = strOld.length();
            StringBuffer buf = new StringBuffer(cSrc.length);
            buf.append(cSrc, 0, i).append(cTo);
            int j = i += len;
            while ((i = strSource.indexOf(strOld, i)) > 0) {
                buf.append(cSrc, j, i - j).append(cTo);
                j = i += len;
            }
            buf.append(cSrc, j, cSrc.length - j);
            return buf.toString();
        }
        return strSource;
    }

    public static boolean isMatch(String str, String pattern) {
        Pattern pattern_hand = Pattern.compile(pattern);
        Matcher matcher_hand = pattern_hand.matcher(str);
        boolean b = matcher_hand.matches();
        return b;
    }

    public static String subStringExe(String s, String jmp, String sb, String se) {
        if (StringUtil.isEmpty(s)) {
            return "";
        }
        int i = s.indexOf(jmp);
        if (i >= 0 && i < s.length()) {
            s = s.substring(i + 1);
        }
        if ((i = s.indexOf(sb)) >= 0 && i < s.length()) {
            s = s.substring(i + 1);
        }
        if (StringUtils.isBlank((CharSequence)se)) {
            return s;
        }
        i = s.indexOf(se);
        if (i >= 0 && i < s.length()) {
            s = s.substring(i + 1);
        }
        return s;
    }

    public static String URLEncode(String src) {
        String return_value = "";
        try {
            if (src != null) {
                return_value = URLEncoder.encode(src, "GBK");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
            return_value = src;
        }
        return return_value;
    }

    public static String getGBK(String str) {
        return StringUtil.transfer(str);
    }

    public static String transfer(String str) {
        Pattern p = Pattern.compile("&#\\d+;");
        Matcher m = p.matcher(str);
        while (m.find()) {
            String old = m.group();
            str = str.replaceAll(old, StringUtil.getChar(old));
        }
        return str;
    }

    public static String getChar(String str) {
        String dest = str.substring(2, str.length() - 1);
        char ch = (char)Integer.parseInt(dest);
        return "" + ch;
    }

    public static String subYhooString(String subject, int size) {
        subject = subject.substring(1, size);
        return subject;
    }

    public static String subYhooStringDot(String subject, int size) {
        subject = subject.substring(1, size) + "...";
        return subject;
    }

    public static <T> String listTtoString(List<T> list) {
        if (list == null || list.size() < 1) {
            return "";
        }
        Iterator<T> i = list.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            T e = i.next();
            sb.append(e);
            if (!i.hasNext()) {
                return sb.toString();
            }
            sb.append(",");
        }
    }

    public static String intArraytoString(int[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.toString();
            }
            b.append(",");
            ++i;
        }
    }

    public static boolean isContentRepeat(String content) {
        int similarNum = 0;
        int forNum = 0;
        int subNum = 0;
        int thousandNum = 0;
        String startStr = "";
        String nextStr = "";
        boolean result = false;
        float endNum = 0.0f;
        if (content != null && content.length() > 0) {
            thousandNum = content.length() % 1000 > 0 ? (int)Math.floor((double)content.length() / 1000.0 + 1.0) : (int)Math.floor((double)content.length() / 1000.0);
            subNum = thousandNum < 3 ? 100 * thousandNum : (thousandNum < 6 ? 200 * thousandNum : (thousandNum < 9 ? 300 * thousandNum : 3000));
            block0: for (int j = 1; j < subNum; ++j) {
                forNum = content.length() % j > 0 ? (int)Math.floor((double)content.length() / (double)j) + 1 : (int)Math.floor((double)content.length() / (double)j);
                if (result || j >= content.length()) break;
                for (int m = 0; m < forNum && m * j <= content.length() && (m + 1) * j <= content.length() && (m + 2) * j <= content.length(); ++m) {
                    startStr = content.substring(m * j, (m + 1) * j);
                    if (startStr.equals(nextStr = content.substring((m + 1) * j, (m + 2) * j))) {
                        if (!((double)(endNum = (float)(++similarNum) / (float)forNum) > 0.4)) continue;
                        result = true;
                        continue block0;
                    }
                    similarNum = 0;
                }
            }
        }
        return result;
    }

    public static String isEmpty(String s, String result) {
        if (s != null && !s.equals("")) {
            return s;
        }
        return result;
    }

    public static boolean isNotEmpty(Object str) {
        boolean flag = true;
        if (str != null && !str.equals("")) {
            if (str.toString().length() > 0) {
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static boolean isEmpty(Object obj) {
        return !StringUtil.isNotEmpty(obj);
    }

    public static String full2Half(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\uff01' && c < '\uff5d') {
                sb.append((char)(c - 65248));
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String replaceBracketStr(String str) {
        if (str != null && str.length() > 0) {
            str = str.replaceAll("\uff08", "(");
            str = str.replaceAll("\uff09", ")");
        }
        return str;
    }

    public static Map<String, String> parseQuery(String query, char split1, char split2, String dupLink) {
        if (!StringUtil.isEmpty(query) && query.indexOf(split2) > 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            String name = null;
            String value = null;
            String tempValue = "";
            int len = query.length();
            for (int i = 0; i < len; ++i) {
                char c = query.charAt(i);
                if (c == split2) {
                    value = "";
                    continue;
                }
                if (c == split1) {
                    if (!StringUtil.isEmpty(name) && value != null) {
                        if (dupLink != null && (tempValue = (String)result.get(name)) != null) {
                            value = value + dupLink + tempValue;
                        }
                        result.put(name, value);
                    }
                    name = null;
                    value = null;
                    continue;
                }
                if (value != null) {
                    value = value + c;
                    continue;
                }
                name = name != null ? name + c : "" + c;
            }
            if (!StringUtil.isEmpty(name) && value != null) {
                if (dupLink != null && (tempValue = (String)result.get(name)) != null) {
                    value = value + dupLink + tempValue;
                }
                result.put(name, value);
            }
            return result;
        }
        return null;
    }

    public static String listToStringSlipStr(List list, String slipStr) {
        StringBuffer returnStr = new StringBuffer();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                returnStr.append(list.get(i)).append(slipStr);
            }
        }
        if (returnStr.toString().length() > 0) {
            return returnStr.toString().substring(0, returnStr.toString().lastIndexOf(slipStr));
        }
        return "";
    }

    public static String getMaskStr(String str, int start, int len) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        if (str.length() < start) {
            return str;
        }
        String ret = str.substring(0, start);
        int strLen = str.length();
        if (strLen < start + len) {
            len = strLen - start;
        }
        for (int i = 0; i < len; ++i) {
            ret = ret + "*";
        }
        if (strLen > start + len) {
            ret = ret + str.substring(start + len);
        }
        return ret;
    }

    public static List<String> stringToStringListBySlipStr(String slipStr, String src) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isNotEmpty((CharSequence)src)) {
            String[] result = src.split(slipStr);
            for (int i = 0; i < result.length; ++i) {
                String str = result[i];
                if (!StringUtil.isNotEmpty((CharSequence)str)) continue;
                list.add(str);
            }
        }
        return list;
    }

    public static String getHtmlSubString(String str, int len, String tail) {
        int i;
        if (str == null || str.length() <= len) {
            return str;
        }
        int length = str.length();
        char c = ' ';
        String tag = null;
        String name = null;
        int size = 0;
        String result = "";
        boolean isTag = false;
        ArrayList<String> tags = new ArrayList<String>();
        int end = 0;
        int spanEnd = 0;
        for (i = 0; i < length && len > 0; ++i) {
            c = str.charAt(i);
            if (c == '<') {
                end = str.indexOf(62, i);
            }
            if (end > 0) {
                tag = str.substring(i, end + 1);
                int n = tag.length();
                if (tag.endsWith("/>")) {
                    isTag = true;
                } else if (tag.startsWith("</")) {
                    name = tag.substring(2, end - i);
                    size = tags.size() - 1;
                    if (size >= 0 && name.equals(tags.get(size))) {
                        isTag = true;
                        tags.remove(size);
                    }
                } else {
                    spanEnd = tag.indexOf(32, 0);
                    spanEnd = spanEnd > 0 ? spanEnd : n;
                    name = tag.substring(1, spanEnd);
                    if (name.trim().length() > 0 && (spanEnd = str.indexOf("</" + name + ">", end)) > 0) {
                        isTag = true;
                        tags.add(name);
                    }
                }
                if (!isTag) {
                    if (n >= len) {
                        result = result + tag.substring(0, len);
                        break;
                    }
                    len -= n;
                }
                result = result + tag;
                isTag = false;
                i = end;
                end = 0;
                continue;
            }
            --len;
            result = result + c;
        }
        for (String endTag : tags) {
            result = result + "</" + endTag + ">";
        }
        if (i < length) {
            result = result + tail;
        }
        return result;
    }

    public static String getProperty(String property) {
        if (property.contains("_")) {
            return property.replaceAll("_", "\\.");
        }
        return property;
    }

    public static String getEncodePra(String property) {
        String trem = "";
        if (StringUtil.isNotEmpty((CharSequence)property)) {
            try {
                trem = URLDecoder.decode(property, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("", (Throwable)e);
            }
        }
        return trem;
    }

    public boolean isDigit(String strNum) {
        Pattern pattern = Pattern.compile("[0-9]{1,}");
        Matcher matcher = pattern.matcher(strNum);
        return matcher.matches();
    }

    public String getNumbers(String content) {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public String splitNotNumber(String content) {
        Pattern pattern = Pattern.compile("\\D+");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public static boolean contains(String[] stringArray, String source) {
        List<String> tempList = Arrays.asList(stringArray);
        return tempList.contains(source);
    }

    public static String firstUpperCase(String realName) {
        return StringUtils.replaceChars((String)realName, (String)realName.substring(0, 1), (String)realName.substring(0, 1).toUpperCase());
    }

    public static String firstLowerCase(String realName) {
        return StringUtils.replaceChars((String)realName, (String)realName.substring(0, 1), (String)realName.substring(0, 1).toLowerCase());
    }

    public static boolean isJavaClass(Class<?> clazz) {
        boolean isBaseClass = false;
        if (clazz.isArray()) {
            isBaseClass = false;
        } else if (clazz.isPrimitive() || clazz.getPackage() == null || clazz.getPackage().getName().equals("java.lang") || clazz.getPackage().getName().equals("java.math") || clazz.getPackage().getName().equals("java.util")) {
            isBaseClass = true;
        }
        return isBaseClass;
    }

    public static String getEmptyString() {
        return "";
    }

    public static String[] wrapString(String[] str, String wrapString) {
        String[] newStr = null;
        if (str != null && str.length > 0) {
            newStr = new String[str.length];
            for (int i = 0; i < str.length; ++i) {
                newStr[i] = wrapString + str[i] + wrapString;
            }
        }
        return newStr;
    }

    public static String formatDate(Date date, String pattern) {
        if (date != null) {
            String dateString = new SimpleDateFormat(pattern).format(date);
            return dateString;
        }
        return "";
    }

    public static String underlineToCamel(String param) {
        int UNDERLINE = 95;
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getInSqlStr(List<String> lstId) {
        if (CollectionUtil.listNotEmptyNotSizeZero(lstId)) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < lstId.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("'");
                buf.append(lstId.get(i));
                buf.append("'");
            }
            return buf.toString();
        }
        return null;
    }

    public static String getInSqlStr(String ids) {
        if (StringUtil.isNotEmpty((CharSequence)ids)) {
            StringBuffer buf = new StringBuffer();
            String[] arrId = ids.split(",");
            for (int i = 0; i < arrId.length; ++i) {
                buf.append(",");
                buf.append("'");
                buf.append(arrId[i]);
                buf.append("'");
            }
            if (buf.length() > 0) {
                return buf.substring(1);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String name = "tm_customer_org";
        name = name.substring(3, name.length());
        StringBuffer sb = new StringBuffer("Name");
        name = StringUtil.underlineToCamel(name);
        System.out.println(sb.insert(0, name));
    }

    public static String strToBinstr(String str) {
        char[] strChar = str.toCharArray();
        String result = "";
        for (int i = 0; i < strChar.length; ++i) {
            result = result + Integer.toBinaryString(strChar[i]) + " ";
        }
        return result;
    }

    public static String splitStringToSqlParams(String str) {
        Assert.notNull((Object)str, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3aNull");
        StringBuilder sb = new StringBuilder();
        for (String s : str.split(",")) {
            sb.append("'");
            sb.append(s);
            sb.append("'");
            sb.append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static int getWordCount(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            int ascii = Character.codePointAt(s, i);
            if (ascii >= 0 && ascii <= 255) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }

    public static String changeTheArrToTheStr(String[] arrStr, boolean isToInStr) {
        return StringUtil.changeListStringToString(Arrays.asList(arrStr), isToInStr);
    }

    public static String changeListStringToString(List<String> list, boolean isToInStr) {
        String resultStr = list.toString().replace("[", "").replace("]", "").replace(" ", "");
        if (isToInStr) {
            resultStr = StringUtil.changeStringToSqlInString(resultStr);
        }
        return resultStr;
    }

    public static synchronized String changeStringToSqlInString(String objs) {
        if (StringUtil.isNotEmpty((CharSequence)objs)) {
            objs = objs.replace("'", "").replace(" ", "");
            objs = "'" + objs.replace(",", "','") + "'";
            objs = objs.replace(",''", "").replace("'',", "").replace("''", "");
        }
        return objs;
    }

    private static String changeValueToString(Object valueObj, String format) {
        String tempStr = "";
        tempStr = valueObj instanceof Date ? DateUtils.format((Date)valueObj, format) : String.valueOf(valueObj);
        return tempStr;
    }

    public static String returnNotNullWordValue(String obj) {
        if (obj != null && !obj.equals("") && !obj.equals("undefined") && obj.equals("null")) {
            return "";
        }
        return obj;
    }

    public static String changeNumerStrToNumber(String obj) {
        return obj.replaceAll("'([\\d]+)'", "$1");
    }
}

