/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.config;

import com.biz.eisp.annotation.ErrorNoJs;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class BaseInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BaseInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            if (!(handler instanceof HandlerMethod)) {
                return true;
            }
            HandlerMethod hm = (HandlerMethod)handler;
            Method method = hm.getMethod();
            ErrorNoJs nojs = method.getAnnotation(ErrorNoJs.class);
            boolean b1 = method.getReturnType().equals(String.class) || method.getReturnType().equals(ModelAndView.class);
            boolean b2 = !method.isAnnotationPresent(ResponseBody.class);
            boolean b3 = !hm.getBeanType().isAnnotationPresent(RestController.class);
            request.setAttribute("method_return_is_view", (Object)(b1 && b2 && b3 ? 1 : 0));
            if (nojs != null) {
                request.setAttribute("method_return_is_nojs", (Object)true);
            }
            String clickFunctionId = request.getParameter("clickFunctionId");
            request.setAttribute("clickFunctionId", (Object)clickFunctionId);
            String load = request.getParameter("load");
            request.setAttribute("load", (Object)load);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return true;
    }
}

