/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.exception;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.exception.feign.GolbalExceptionFeign;
import com.biz.eisp.service.RedisService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@ControllerAdvice
public class GlobalException {
    private static final Logger log = LoggerFactory.getLogger(GlobalException.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static GolbalExceptionFeign golbalExceptionFeign;
    private static RedisService redisService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    public static String getExceptionToString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView errorHandler(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5904\u7406--", (Throwable)ex);
        AjaxJson ajaxJson = new AjaxJson();
        ModelAndView mv = null;
        try {
            String errorMsg = "\u64cd\u4f5c\u5f02\u5e38";
            if (this.isView(request)) {
                ajaxJson.setErrMsg(errorMsg);
                mv = this.isNojsView(request) ? new ModelAndView("common/errornojs") : new ModelAndView("common/error");
                mv.addObject(ajaxJson);
                mv.addObject("errorMsg", (Object)errorMsg);
                return mv;
            }
            mv = new ModelAndView((View)new MappingJackson2JsonView());
            mv.addObject("success", (Object)false);
            mv.addObject("msg", (Object)errorMsg);
            mv.addObject("code", (Object)"\u672a\u5b9a\u4e49");
        }
        catch (Exception e) {
            mv = this.isNojsView(request) ? new ModelAndView("common/errornojs") : new ModelAndView("common/error");
        }
        return mv;
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public AjaxJson errorHandler(BusinessException ex, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setErrMsg(ex.getMessage());
        log.info(ex.getMessage());
        return ajaxJson;
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public AjaxJson methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException ex) {
        Iterator iterator = ex.getBindingResult().getFieldErrors().iterator();
        StringBuilder msg = new StringBuilder();
        while (iterator.hasNext()) {
            FieldError fieldError = (FieldError)iterator.next();
            msg.append(fieldError.getDefaultMessage()).append(";");
        }
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setErrMsg(msg.toString());
        return ajaxJson;
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public AjaxJson bindExceptionHandler(BindException ex) {
        Iterator iterator = ex.getBindingResult().getFieldErrors().iterator();
        StringBuilder msg = new StringBuilder();
        while (iterator.hasNext()) {
            FieldError fieldError = (FieldError)iterator.next();
            msg.append(fieldError.getDefaultMessage()).append(";");
        }
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setErrMsg(msg.toString());
        return ajaxJson;
    }

    private boolean isView(HttpServletRequest request) {
        Object object = request.getAttribute("method_return_is_view");
        if (object == null) {
            log.error("\u914d\u7f6e\u51fa\u9519");
            return false;
        }
        boolean isView = (Boolean)object;
        return isView;
    }

    private boolean isNojsView(HttpServletRequest request) {
        Object object = request.getAttribute("method_return_is_nojs");
        if (object == null) {
            return false;
        }
        boolean isView = (Boolean)object;
        return isView;
    }
}

