/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.utils;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.CookiesUtil;
import com.biz.eisp.base.utils.Snippet;
import com.biz.eisp.base.utils.UserAutoConfig;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.thread.ThreadLocalUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    private static final Logger log = LoggerFactory.getLogger(UserUtils.class);
    private static RedisService redisService = null;
    private static UserAutoConfig userAutoConfig = null;

    public static UserRedis getUser() {
        if (redisService == null) {
            Object object = SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
            redisService = (RedisService)object;
        }
        UserRedis userRedis = null;
        String key = AppcenterUtil.getUserKey();
        if (StringUtil.isEmpty(key)) {
            return userRedis;
        }
        Object object = redisService.get("LOGIN_SUCCESS_" + key);
        if (object == null) {
            return userRedis;
        }
        String userReidsJson = object.toString();
        if (!StringUtil.isNotEmpty((CharSequence)userReidsJson)) {
            return userRedis;
        }
        userRedis = JsonPropertyUtil.toObject(userReidsJson, UserRedis.class);
        return userRedis;
    }

    public static UserRedis getUser(String key) {
        if (redisService == null) {
            Object object = SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
            redisService = (RedisService)object;
        }
        UserRedis userRedis = null;
        if (StringUtil.isEmpty(key)) {
            return userRedis;
        }
        Object object = redisService.get("LOGIN_SUCCESS_" + key);
        if (object == null) {
            return userRedis;
        }
        String userReidsJson = object.toString();
        if (!StringUtil.isNotEmpty((CharSequence)userReidsJson)) {
            return userRedis;
        }
        userRedis = JsonPropertyUtil.toObject(userReidsJson, UserRedis.class);
        return userRedis;
    }

    public static String getCreateName(UserRedis user) {
        return user.getRealname() + "(" + user.getPosName() + ")";
    }

    public static void doTokenForNull() {
        UserUtils.initConfig();
        if (StringUtil.isEmpty(userAutoConfig.getUsername())) {
            return;
        }
        try {
            String key = Snippet.aesEncrypt(CookiesUtil.getKeyFlag(userAutoConfig.getUsername()), "1oR8uIM2O5qv65l2");
            ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
            map.put("loginUserToken", key);
            ThreadLocalUtil.stObj(map);
            UserRedis userRedis = new UserRedis();
            userRedis.setUsername(userAutoConfig.getUsername());
            userRedis.setId("admin");
            redisService.setHours("LOGIN_SUCCESS_" + key, (Object)JSONObject.toJSONString((Object)userRedis), 1L);
        }
        catch (Exception e) {
            log.error("\u9ed8\u8ba4\u8bbe\u7f6e\u6743\u9650\u9519\u8bef", (Throwable)e);
        }
    }

    private static void initConfig() {
        if (userAutoConfig == null) {
            userAutoConfig = (UserAutoConfig)SpringApplicationContextUtil.getApplicationContext().getBean(UserAutoConfig.class);
        }
    }
}

