/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.exception.BusinessException;
import java.beans.PropertyEditorSupport;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DateUtils
extends PropertyEditorSupport {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final SimpleDateFormat date_sdf_yyyy_m = new SimpleDateFormat("yyyy-M");
    public static final SimpleDateFormat date_sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat date_sdf_2 = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat yyyyM = new SimpleDateFormat("yyyyM");
    public static final SimpleDateFormat yyyy = new SimpleDateFormat("yyyy");
    public static final SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyyMM");
    public static final SimpleDateFormat MM = new SimpleDateFormat("MM");
    public static final SimpleDateFormat yyyy_MM = new SimpleDateFormat("yyyy-MM");
    public static final SimpleDateFormat date_sdf_wz = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    public static final SimpleDateFormat time_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final SimpleDateFormat yyyymmddhhmmss = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat short_time_sdf = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final long DAY_IN_MILLIS = 86400000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long SECOND_IN_MILLIS = 1000L;
    public static final int MINIMAL_DAYS_IN_FIRSTWEEK = 4;
    public static final int FIRST_DAY_OF_WEEK = 2;
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String DEFAULT_DAY_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_MONTH_PATTERN = "yyyy\u5e74MM\u6708";
    public static final String DEFAULT_MONTH_NO_CH_PATTERN = "yyyyMM";
    public static final String DEFAULT_MONTH_DAY_PATTERN = "yyyyMMdd";
    public static final String DEFAULT_MONTH_DAY_PATTERN_ = "yyyy-MM";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm";
    public static final String DEFAULT_DATE_ALL_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_TIME_ALL_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyyMMddHHmmss";
    static int[] DAYS = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    public static String getYYYYM(java.util.Date date) {
        return yyyyM.format(date);
    }

    public static String getYYYYMMDD() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new java.util.Date());
    }

    public static String getYYYYMMDD(java.util.Date date) {
        return date_sdf.format(date);
    }

    public static java.util.Date getDateYYYYMMDD(String date) {
        try {
            return date_sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static java.util.Date getDateYYYYMD(String date) throws ParseException {
        return date_sdf_2.parse(date);
    }

    public static SimpleDateFormat getSDFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static String getFormatDateStr(java.util.Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(pattern, Locale.US);
        return dtFmt.format(date);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new java.util.Date(millis));
        return cal;
    }

    public static java.util.Date getDate() {
        return new java.util.Date();
    }

    public static java.util.Date getDate(long millis) {
        return new java.util.Date(millis);
    }

    public static String timestamptoStr(Timestamp time) {
        java.util.Date date = null;
        if (null != time) {
            date = new java.util.Date(time.getTime());
        }
        return DateUtils.date2Str(date_sdf);
    }

    public static Timestamp str2Timestamp(String str) {
        java.util.Date date = DateUtils.str2Date(str, date_sdf);
        return new Timestamp(date.getTime());
    }

    public static java.util.Date str2Date(String str, SimpleDateFormat sdf) {
        if (null == str || "".equals(str)) {
            return null;
        }
        java.util.Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getMonthSpace(String date1, String date2, String format) {
        try {
            int result = 0;
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(sdf.parse(date1));
            c2.setTime(sdf.parse(date2));
            result = (c1.get(1) - c2.get(1)) * 12 + c1.get(2) - c2.get(2);
            return result == 0 ? 1 : Math.abs(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u65f6\u95f4\u5904\u7406\u5931\u8d25");
        }
    }

    public static String date2Str(SimpleDateFormat date_sdf) {
        java.util.Date date = DateUtils.getDate();
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String dateNow2Str() {
        return DateUtils.date2Str(date_sdf);
    }

    public static String dateNowStrHms() {
        return DateUtils.date2Str(datetimeFormat);
    }

    public static String dateformat(String date, String format) {
        SimpleDateFormat sformat = new SimpleDateFormat(format);
        java.util.Date _date = null;
        try {
            _date = sformat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sformat.format(_date);
    }

    public static String date2Str(java.util.Date date, SimpleDateFormat date_sdf) {
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String getDate(String format) {
        java.util.Date date = new java.util.Date();
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static java.util.Date getDate(SimpleDateFormat format) {
        java.util.Date date = new java.util.Date();
        String nowDate = format.format(date);
        try {
            return format.parse(nowDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getTimestamp(String time) {
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(new java.util.Date().getTime());
    }

    public static Timestamp getTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp getCalendarTimestamp(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp gettimestamp() {
        java.util.Date dt = new java.util.Date();
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_ALL_PATTERN);
        String nowTime = df.format(dt);
        Timestamp buydate = Timestamp.valueOf(nowTime);
        return buydate;
    }

    public static Timestamp getDateTimestamp() {
        java.util.Date dt = new java.util.Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String nowTime = df.format(dt);
        return DateUtils.str2Timestamp(nowTime);
    }

    public static long getMillis() {
        return new java.util.Date().getTime();
    }

    public static long getMillis(Calendar cal) {
        return cal.getTime().getTime();
    }

    public static long getMillis(java.util.Date date) {
        return date.getTime();
    }

    public static long getMillis(Timestamp ts) {
        return ts.getTime();
    }

    public static String formatDate() {
        return date_sdf.format(DateUtils.getCalendar().getTime());
    }

    public static String getDataString(SimpleDateFormat formatstr) {
        return formatstr.format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal) {
        return date_sdf.format(cal.getTime());
    }

    public static String formatDate(java.util.Date date) {
        return date_sdf.format(date);
    }

    public static String formatDate(long millis) {
        return date_sdf.format(new java.util.Date(millis));
    }

    public static String formatDate(String pattern) {
        return DateUtils.getSDFormat(pattern).format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal, String pattern) {
        return DateUtils.getSDFormat(pattern).format(cal.getTime());
    }

    public static String formatDate(java.util.Date date, String pattern) {
        return DateUtils.getSDFormat(pattern).format(date);
    }

    public static String formatTime() {
        return time_sdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatTime(long millis) {
        return time_sdf.format(new java.util.Date(millis));
    }

    public static String formatTime(Calendar cal) {
        return time_sdf.format(cal.getTime());
    }

    public static String formatTime(java.util.Date date) {
        return time_sdf.format(date);
    }

    public static String formatShortTime() {
        return short_time_sdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatShortTime(long millis) {
        return short_time_sdf.format(new java.util.Date(millis));
    }

    public static String formatShortTime(Calendar cal) {
        return short_time_sdf.format(cal.getTime());
    }

    public static String formatShortTime(java.util.Date date) {
        return short_time_sdf.format(date);
    }

    public static java.util.Date parseDate(String src, String pattern) {
        try {
            return DateUtils.getSDFormat(pattern).parse(src);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u65f6\u95f4\u5904\u7406\u5931\u8d25");
        }
    }

    public static Calendar parseCalendar(String src, String pattern) throws ParseException {
        java.util.Date date = DateUtils.parseDate(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String formatAddDate(String src, String pattern, int amount) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(5, amount);
        return DateUtils.formatDate(cal);
    }

    public static String formatAddMonth(String src, String pattern, int month) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(2, month);
        return DateUtils.formatDate(cal);
    }

    public static java.util.Date formatAddMonth(java.util.Date src, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static Timestamp parseTimestamp(String src, String pattern) throws ParseException {
        java.util.Date date = DateUtils.parseDate(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static int dateDiff(char flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = DateUtils.getMillis(calSrc) - DateUtils.getMillis(calDes);
        if (flag == 'y') {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == 'd') {
            return (int)(millisDiff / 86400000L);
        }
        if (flag == 'h') {
            return (int)(millisDiff / 3600000L);
        }
        if (flag == 'm') {
            return (int)(millisDiff / 60000L);
        }
        if (flag == 's') {
            return (int)(millisDiff / 1000L);
        }
        return 0;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                if (text.indexOf(":") == -1 && text.length() == 10) {
                    this.setValue(date_sdf.parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == 19) {
                    this.setValue(datetimeFormat.parse(text));
                }
                throw new IllegalArgumentException("Could not parse date, date format is error ");
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
                throw iae;
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getDate());
        return calendar.get(1);
    }

    public static long subtractDay(java.util.Date endDate, java.util.Date startDate) {
        return (endDate.getTime() - startDate.getTime()) / 86400000L;
    }

    public static java.util.Date ReturnTheDay(java.util.Date date, int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        return calendar.getTime();
    }

    public static String format(java.util.Date date, String pattern) {
        if (date != null) {
            try {
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public static String format(Object value, String pattern) {
        if (value != null) {
            try {
                java.util.Date date = null;
                return new SimpleDateFormat(pattern).format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public static java.util.Date getDateTime(String dateTime) {
        java.util.Date date = new java.util.Date();
        String datePart = DateUtils.format(date, "yyyy-MM-dd");
        String dateTimePart = datePart + " " + dateTime;
        java.util.Date newDate = DateUtils.parse(dateTimePart, DEFAULT_DATE_PATTERN);
        return newDate;
    }

    public static java.util.Date parse(String date, String pattern) {
        java.util.Date newDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            newDate = sdf.parse(date);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BusinessException("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a" + date + "\uff0c\u8f6c\u6362\u4e3a\uff1a" + pattern);
        }
        return newDate;
    }

    public static java.util.Date getYesterdayByDate(String date, String pattern) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            sdf.setLenient(false);
            java.util.Date temp = sdf.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.add(5, -1);
            return cal.getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, 1);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDaysOfQuarter(int year, int quarter) {
        int firstMonth;
        Calendar cal = Calendar.getInstance();
        int days = 0;
        for (int i = firstMonth = (quarter - 1) * 3; i < firstMonth + 3; ++i) {
            cal.set(year, i, 1);
            days += cal.getActualMaximum(5);
        }
        return days;
    }

    public static int getDaysOfYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 0, 1);
        return cal.getActualMaximum(6);
    }

    public static int getDaysOfYear(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(6);
    }

    public static java.util.Date getFirstDayOfWeek(int year, int week) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(year, 0, 1);
        int addDays = week * 7;
        if (cal.get(3) == 1) {
            addDays = (week - 1) * 7;
        }
        cal.add(5, addDays);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfWeek(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)(2 - dayOfWeek) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfLastMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setTimeInMillis(cal.getTimeInMillis() - (long)cal.get(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfNextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfNextMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        return cal.getTime();
    }

    public static java.util.Date getLastDayOfNextMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)cal.getActualMaximum(5) * 86400000L);
        cal.set(5, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() + (long)(cal.getActualMaximum(5) - 1) * 86400000L);
        return cal.getTime();
    }

    public static int getWeekOfDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.get(3);
    }

    public static int getDayOfDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        return cal.get(6);
    }

    public static java.util.Date getDate2() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date getDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date yesterday() {
        return new java.util.Date(System.currentTimeMillis() - 86400000L);
    }

    public static java.util.Date tomorrow() {
        return new java.util.Date(System.currentTimeMillis() + 86400000L);
    }

    public static java.util.Date getEndDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2099);
        cal.set(2, 11);
        cal.set(5, 31);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.util.Date parseToDate(Object value) {
        if (value instanceof Timestamp) {
            return (java.util.Date)value;
        }
        if (value instanceof Date) {
            return (java.util.Date)value;
        }
        return (java.util.Date)value;
    }

    public static java.util.Date getAppointDate(int calendarConstant, int appointNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        calendar.add(calendarConstant, appointNum);
        return calendar.getTime();
    }

    public static String calSpendTimes(String startTime, String endTime) {
        java.util.Date startTimeDateType = DateUtils.parse(startTime, DEFAULT_DATE_ALL_PATTERN);
        java.util.Date endTimeDateType = null;
        if (endTime != null) {
            endTimeDateType = DateUtils.parse(endTime, DEFAULT_DATE_ALL_PATTERN);
        }
        long totalTimes = endTime == null ? Calendar.getInstance().getTimeInMillis() - startTimeDateType.getTime() : endTimeDateType.getTime() - startTimeDateType.getTime();
        long dayCount = totalTimes / 86400000L;
        long restTimes = totalTimes % 86400000L;
        long hourCount = restTimes / 3600000L;
        long minuteCount = (restTimes %= 3600000L) / 60000L;
        String spendTimes = dayCount + "\u5929" + hourCount + "\u5c0f\u65f6" + minuteCount + "\u5206";
        return spendTimes;
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_MONTH_DAY_PATTERN_);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 2);
            Calendar curr = min;
            while (curr.before(max)) {
                result.add(sdf.format(curr.getTime()));
                curr.add(2, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isValidDateTime(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(5, 7));
            if (month <= 0 || month > 12) {
                return false;
            }
            int day = Integer.parseInt(date.substring(8, 10));
            if (day <= 0 || day > DAYS[month]) {
                return false;
            }
            if (month == 2 && day == 29 && DateUtils.isGregorianLeapYear(year)) {
                return false;
            }
            int hour = Integer.parseInt(date.substring(11, 13));
            if (hour < 0 || hour > 23) {
                return false;
            }
            int minute = Integer.parseInt(date.substring(14, 16));
            if (minute < 0 || minute > 59) {
                return false;
            }
            int second = Integer.parseInt(date.substring(17, 19));
            if (second < 0 || second > 59) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isValidMoth(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(5, 7));
            if (month <= 0 || month > 12) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isValidDate(String date) {
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            if (year <= 0) {
                return false;
            }
            int month = Integer.parseInt(date.substring(5, 7));
            if (month <= 0 || month > 12) {
                return false;
            }
            int day = Integer.parseInt(date.substring(8, 10));
            if (day <= 0 || day > DAYS[month]) {
                return false;
            }
            if (month == 2 && day == 29 && DateUtils.isGregorianLeapYear(year)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isGregorianLeapYear(int year) {
        return year % 4 != 0 || year % 100 == 0 && year % 400 != 0;
    }

    public static java.util.Date switchDate(java.util.Date fromdate, int type) {
        if (fromdate != null) {
            if (type == 0) {
                GregorianCalendar gcLast = (GregorianCalendar)Calendar.getInstance();
                gcLast.setTime(fromdate);
                gcLast.set(11, 0);
                gcLast.set(12, 0);
                gcLast.set(13, 0);
                gcLast.set(5, 1);
                return gcLast.getTime();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fromdate);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(5, calendar.getActualMaximum(5));
            return calendar.getTime();
        }
        return null;
    }

    public static String getAnyDay(String dateStr, int addYear, int addMonth, int addDate, int ymd) throws Exception {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            java.util.Date sourceDate = sdf.parse(dateStr);
            SimpleDateFormat sdf_ = new SimpleDateFormat(DEFAULT_MONTH_DAY_PATTERN_);
            java.util.Date sourceDate_ = sdf_.parse(dateStr);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTime(sourceDate);
            cal.add(1, addYear);
            cal.add(2, sourceDate_.getMonth() + addMonth);
            if (ymd == 1) {
                cal.add(5, 0);
            } else if (ymd == 2) {
                cal.set(6, 1);
            } else if (ymd == 3) {
                cal.set(5, cal.getActualMaximum(5));
                System.out.println(cal.getTime().getMonth());
            } else {
                cal.set(1, cal.getTime().getYear() + 1900);
                cal.set(6, cal.getActualMaximum(6));
            }
            cal.add(5, addDate);
            SimpleDateFormat returnSdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateTmp = returnSdf.format(cal.getTime());
            return dateTmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public static String getFirstDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_MONTH_DAY_PATTERN_);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        calendar.set(5, calendar.getMinimum(5));
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        return format2.format(calendar.getTime());
    }

    public static String getFinalDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_MONTH_DAY_PATTERN_);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        calendar.set(5, calendar.getActualMaximum(5));
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        return format2.format(calendar.getTime());
    }

    public static boolean isDate(String aDate) {
        return DateUtils.isDate(aDate, "yyyy-MM-dd");
    }

    public static boolean isDate(String aDate, String fmt) {
        if (aDate == null || aDate.trim().equals("")) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        sdf.setLenient(false);
        try {
            sdf.parse(aDate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static String getAnyDay(String dateStr, String pattern, int addYear, int addMonth, int addDay) {
        try {
            java.util.Date date = DateUtils.parseDate(dateStr, pattern);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (addYear != 0) {
                cal.add(1, addYear);
            }
            if (addMonth != 0) {
                cal.add(2, addMonth);
            }
            if (addDay != 0) {
                cal.add(5, addDay);
            }
            return DateUtils.formatDate(cal);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(e.getMessage());
        }
    }

    public static String filterChar(String date) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(date);
        return m.replaceAll("");
    }

    public static int getDayOfMonth(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String convertDateStr(long millSec) {
        SimpleDateFormat fmtDateTime = new SimpleDateFormat("yyyy-MM-dd");
        return fmtDateTime.format(new java.util.Date(millSec * 1000L));
    }

    public static java.util.Date extractionDate(long millSec) {
        java.util.Date in = new java.util.Date(millSec * 1000L);
        SimpleDateFormat fmtDateTime = new SimpleDateFormat("yyyy-MM-dd");
        String text = fmtDateTime.format(in);
        ParsePosition pos = new ParsePosition(0);
        return ((DateFormat)fmtDateTime).parse(text, pos);
    }

    public static int[] monthToYear(int month) {
        int[] ret = new int[]{0, 0};
        ret[0] = month / 12;
        if (month % 12 != 0) {
            ret[1] = month % 12;
        }
        return ret;
    }

    public static String monthToYearStr(int month) {
        int[] ret = DateUtils.monthToYear(month);
        String str = ret[0] + "\u5c81";
        if (ret[0] <= 5 && ret[1] != 0) {
            str = str + ret[1] + "\u4e2a\u6708";
        }
        return str;
    }

    public static String getDateStrByFormat(java.util.Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        return dtFmt.format(date);
    }

    public static boolean isSameDate(java.util.Date date1, java.util.Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static boolean isSameDay(java.util.Date date1, java.util.Date date2) {
        long between = Math.abs(date2.getTime() - date1.getTime());
        if (between > 86400000L) {
            return false;
        }
        if (between == 86400000L) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            if (cal1.get(11) == 0 && cal2.get(11) == 0) {
                return true;
            }
            return cal1.get(11) == 24 && cal2.get(11) == 24;
        }
        return true;
    }

    public static java.util.Date getDateByFormat(String date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        java.util.Date dateTime = null;
        try {
            dateTime = dtFmt.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateTime;
    }

    public static long getDistanceDay(long date1, long date2) {
        long newDate2;
        String dateStr1 = DateUtils.getDateStrByFormat(new java.util.Date(date1 * 1000L), "yyyy-MM-dd");
        String dateStr2 = DateUtils.getDateStrByFormat(new java.util.Date(date2 * 1000L), "yyyy-MM-dd");
        java.util.Date date3 = DateUtils.getDateByFormat(dateStr1, "yyyy-MM-dd");
        java.util.Date date4 = DateUtils.getDateByFormat(dateStr2, "yyyy-MM-dd");
        long newDate1 = DateUtils.convertTimeStamp(date3);
        long diff = newDate1 >= (newDate2 = DateUtils.convertTimeStamp(date4)) ? newDate1 - newDate2 : newDate2 - newDate1;
        return diff / 86400L;
    }

    public static long convertTimeStamp(java.util.Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime() / 1000L;
    }

    public static int getDistanceSecond(long date1, long date2) {
        long diff = date1 - date2;
        double diffDouble = diff / 1000L;
        return (int)diffDouble;
    }

    public static Integer getAge(java.util.Date birthday) {
        if (birthday == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int yearNow = calendar.get(1);
        calendar.setTime(birthday);
        int yearBirth = calendar.get(1);
        if (yearNow - yearBirth < 0) {
            return null;
        }
        return yearNow - yearBirth;
    }

    public static int getDayCount(java.util.Date startDate, java.util.Date endDate) {
        if (!startDate.before(endDate)) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int startDayCount = (int)calendar.getTimeInMillis() / 86400000;
        calendar.setTime(endDate);
        int endDayCount = (int)calendar.getTimeInMillis() / 86400000;
        return endDayCount - startDayCount;
    }

    public static String getWeekDayStr(Integer weekDay) {
        String str = "\u5468";
        switch (weekDay) {
            case 1: {
                str = str + "\u4e00";
                break;
            }
            case 2: {
                str = str + "\u4e8c";
                break;
            }
            case 3: {
                str = str + "\u4e09";
                break;
            }
            case 4: {
                str = str + "\u56db";
                break;
            }
            case 5: {
                str = str + "\u4e94";
                break;
            }
            case 6: {
                str = str + "\u516d";
                break;
            }
            case 7: {
                str = str + "\u65e5";
            }
        }
        return str;
    }

    public static String getDayTypeStr(Integer dayType) {
        String str = "";
        switch (dayType) {
            case 1: {
                str = str + "\u4e0a\u5348";
                break;
            }
            case 2: {
                str = str + "\u4e0b\u5348";
                break;
            }
            case 3: {
                str = str + "\u665a\u4e0a";
            }
        }
        return str;
    }

    public static boolean isToday(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        int startDayCount = (int)calendar.getTimeInMillis() / 86400000;
        calendar.setTime(date);
        int endDayCount = (int)calendar.getTimeInMillis() / 86400000;
        return endDayCount == startDayCount;
    }

    public static java.util.Date getDayByDateDistance(java.util.Date date, int distanceDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, distanceDay);
        java.util.Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static java.util.Date getTimeByTimeAndDiffSecond(java.util.Date date, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, second);
        java.util.Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static int getCurrentTime() {
        return Long.valueOf(new java.util.Date().getTime() / 1000L).intValue();
    }

    public static String getDateStrByTimeInt(Integer time) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Long timeLong = Long.parseLong(time + "");
        java.util.Date dt = new java.util.Date(timeLong * 1000L);
        String sDateTime = sdf.format(dt);
        return sDateTime.toString();
    }

    public static java.util.Date increaseDate(java.util.Date time, int unit, int value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(unit, calendar.get(unit) + value);
        return calendar.getTime();
    }

    public static java.util.Date increaseDate(java.util.Date time, int value) {
        return DateUtils.increaseDate(time, 12, value);
    }

    public static boolean isOverlap(java.util.Date dt1Start, java.util.Date dt1End, java.util.Date dt2Start, java.util.Date dt2End) {
        if (dt1Start == null || dt1End == null || dt2Start == null || dt2End == null) {
            throw new IllegalArgumentException("param error");
        }
        long dt1StartLong = dt1Start.getTime();
        long dt1EndLong = dt1End.getTime();
        long dt2StartLong = dt2Start.getTime();
        long dt2EndLong = dt2End.getTime();
        if (dt1StartLong >= dt1EndLong) {
            throw new IllegalArgumentException("param error,param1 must before param2");
        }
        if (dt2StartLong >= dt2EndLong) {
            throw new IllegalArgumentException("param error,param3 must before param4");
        }
        if (dt1EndLong <= dt2StartLong) {
            return false;
        }
        return dt1StartLong < dt2EndLong;
    }

    public static boolean isDateBetween(java.util.Date start, java.util.Date end, java.util.Date paramDate) {
        if (start == null || end == null || paramDate == null) {
            throw new IllegalArgumentException("param error");
        }
        long startLong = start.getTime();
        long endLong = end.getTime();
        long paramLong = paramDate.getTime();
        if (paramLong < startLong) {
            return false;
        }
        return paramLong <= endLong;
    }

    public static boolean equalIsDateMoreThanAnother(java.util.Date date1, java.util.Date date2) {
        return date1.getTime() >= date2.getTime();
    }

    public static boolean isDateExpired(java.util.Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getTime().before(new java.util.Date());
    }

    public static java.util.Date getTodayStartTime(java.util.Date date) {
        if (date == null) {
            date = new java.util.Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static java.util.Date getTodayEndTime(java.util.Date date) {
        if (date == null) {
            date = new java.util.Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static long Date2TimeStamp(String dateStr, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr).getTime() / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String dateStartStr(String start) {
        if (StringUtils.isEmpty((Object)start)) {
            return null;
        }
        return start + " 00:00:00";
    }

    public static String dateEndStr(String end) {
        if (StringUtils.isEmpty((Object)end)) {
            return null;
        }
        return end + " 23:59:59";
    }
}

