/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.tk.utils;

import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.biz.eisp.tools.DictUtil;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CompareUtils {
    private CompareUtils() {
    }

    public static String compare(Object base, Object target) {
        if (null == target || null == base) {
            return null;
        }
        Field[] fields = base.getClass().getDeclaredFields();
        StringBuilder sb = new StringBuilder("");
        int index = 1;
        for (Field field : fields) {
            ModifyNeedCompare needCompare = field.getAnnotation(ModifyNeedCompare.class);
            if (null == needCompare) continue;
            String bizName = needCompare.bizName();
            String targetFieldName = needCompare.targetFieldName();
            String fieldName = field.getName();
            if (StringUtils.isBlank((CharSequence)targetFieldName)) {
                targetFieldName = fieldName;
            }
            if (StringUtils.isBlank((CharSequence)bizName)) {
                bizName = fieldName;
            }
            if (Objects.equals(BeanCopyUtils.getProperty(base, fieldName), BeanCopyUtils.getProperty(target, targetFieldName))) continue;
            if (index != 1) {
                sb.append("\n");
            }
            String dict = needCompare.dict();
            Map<Object, Object> dictMap = null;
            if (StringUtils.isNotBlank((CharSequence)dict)) {
                dictMap = DictUtil.getDictMap(dict);
            }
            String oldProperty = BeanCopyUtils.getProperty(base, fieldName);
            String newProperty = BeanCopyUtils.getProperty(target, targetFieldName);
            if (null != dictMap && dictMap.containsKey(oldProperty)) {
                oldProperty = ((KnlDictDataEntity)dictMap.get(oldProperty)).getDictValue();
            }
            if (null != dictMap && dictMap.containsKey(newProperty)) {
                newProperty = ((KnlDictDataEntity)dictMap.get(newProperty)).getDictValue();
            }
            sb.append("[" + bizName + "]\u4ece[" + oldProperty + "]\u6539\u4e3a\u4e86[" + newProperty + "];");
            ++index;
        }
        return sb.toString();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ModifyNeedCompare {
        public String bizName() default "";

        public String dict() default "";

        public String targetFieldName() default "";
    }
}

