/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.tools;

import com.biz.eisp.api.feign.KnlDictFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.service.RedisService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DictUtil {
    private static RedisService redisService;
    private static KnlDictFeign knlDictFeign;

    public static void getKnlDictFeign() {
        if (knlDictFeign == null) {
            knlDictFeign = (KnlDictFeign)SpringApplicationContextUtil.getApplicationContext().getBean("knlDictFeign");
        }
    }

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    public static Map<Object, Object> getDictMap(String typeCode) {
        if (StringUtil.isEmpty(typeCode)) {
            return new HashMap<Object, Object>();
        }
        DictUtil.getRedisService();
        Map map = redisService.hmget("DICT_DATA_" + typeCode);
        if (map == null || map.size() == 0) {
            DictUtil.getKnlDictFeign();
            List<KnlDictDataEntity> dataEntities = ApiResultUtil.listResult(knlDictFeign.getDictByParamList(typeCode), true);
            if (CollectionUtil.listNotEmptyNotSizeZero(dataEntities)) {
                HashMap<Object, Object> map_ = new HashMap<Object, Object>();
                dataEntities.forEach(item -> map_.put(item.getDictCode(), item));
                return map_;
            }
        }
        return map;
    }

    public static KnlDictDataEntity getDicData(String typeCode, String dataCode) {
        if (StringUtil.isEmpty(typeCode) || StringUtil.isEmpty(dataCode)) {
            return null;
        }
        KnlDictDataEntity data = null;
        DictUtil.getRedisService();
        Object object = redisService.hget("DICT_DATA_" + typeCode, dataCode);
        if (object != null) {
            data = (KnlDictDataEntity)object;
        } else {
            DictUtil.getKnlDictFeign();
            KnlDictDataEntity o = ApiResultUtil.objResult(knlDictFeign.getDictByParamObj(typeCode, dataCode), false);
            if (o != null) {
                data = o;
            }
        }
        return data;
    }

    public static String getDictDataVal(String typeCode, String dataCode) {
        if (StringUtil.isEmpty(typeCode) || StringUtil.isEmpty(dataCode)) {
            return "";
        }
        KnlDictDataEntity data = null;
        DictUtil.getRedisService();
        Object object = redisService.hget("DICT_DATA_" + typeCode, dataCode);
        if (object != null) {
            data = (KnlDictDataEntity)object;
            return data.getDictValue();
        }
        data = DictUtil.getDicData(typeCode, dataCode);
        if (data != null) {
            return data.getDictValue();
        }
        return "";
    }

    public static String gettDictDataFieldCodeVal(String typeCode, String dataCode, String fieldCode) {
        if (StringUtil.isEmpty(typeCode) || StringUtil.isEmpty(dataCode)) {
            return "";
        }
        KnlDictDataEntity data = DictUtil.getDicData(typeCode, dataCode);
        if (null == data) {
            return "";
        }
        Map<String, Object> map = data.getExtendMap();
        if (map == null || map.size() == 0) {
            return "";
        }
        String fieldName = OConvertUtils.getString(map.get(fieldCode));
        return fieldName;
    }

    public static List<KnlDictDataEntity> getDictList(String dictType) {
        if (StringUtil.isEmpty(dictType)) {
            return new ArrayList<KnlDictDataEntity>();
        }
        ArrayList<KnlDictDataEntity> list = new ArrayList<KnlDictDataEntity>();
        Map<Object, Object> map = DictUtil.getDictMap(dictType);
        if (map == null || map.size() <= 0) {
            DictUtil.getKnlDictFeign();
            return ApiResultUtil.listResult(knlDictFeign.getDictByParamList(dictType));
        }
        map.forEach((k, v) -> {
            KnlDictDataEntity entity = (KnlDictDataEntity)v;
            list.add(entity);
        });
        return list;
    }

    public static List<KnlDictDataEntity> getDictListByParentId(String parentId) {
        if (StringUtil.isEmpty(parentId)) {
            return new ArrayList<KnlDictDataEntity>();
        }
        Object o = redisService.get(parentId);
        if (o == null) {
            DictUtil.getKnlDictFeign();
            AjaxJson<KnlDictDataEntity> dataEntityAjaxJson = knlDictFeign.getDictListByParentId(parentId);
            return ApiResultUtil.listResult(dataEntityAjaxJson);
        }
        return (List)o;
    }

    public static List<KnlDictDataEntity> getChildrenDictListByCode(String typeCode, String dataCode) {
        if (StringUtil.isEmpty(typeCode) || StringUtil.isEmpty(dataCode)) {
            return new ArrayList<KnlDictDataEntity>();
        }
        KnlDictDataEntity dataEntity = DictUtil.getDicData(typeCode, dataCode);
        if (dataEntity != null) {
            return DictUtil.getDictListByParentId(dataEntity.getId());
        }
        return new ArrayList<KnlDictDataEntity>();
    }

    public static KnlDictDataEntity getChildDictObjByCode(String typeCode, String dataCode, String childCode) {
        if (StringUtil.isEmpty(typeCode) || StringUtil.isEmpty(dataCode)) {
            return null;
        }
        KnlDictDataEntity dataEntity = DictUtil.getDicData(typeCode, dataCode);
        if (dataEntity != null) {
            List<KnlDictDataEntity> list = DictUtil.getDictListByParentId(dataEntity.getId());
            return DictUtil.getswitchData(list, childCode);
        }
        return new KnlDictDataEntity();
    }

    private static KnlDictDataEntity getswitchData(List<KnlDictDataEntity> list, String childCode) {
        List codeObjs;
        KnlDictDataEntity entity = new KnlDictDataEntity();
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && CollectionUtil.listNotEmptyNotSizeZero(codeObjs = list.stream().filter(dd -> dd.getDictCode().equals(childCode)).collect(Collectors.toList()))) {
            return (KnlDictDataEntity)codeObjs.get(0);
        }
        return entity;
    }
}

