/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.authInterceptor;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.authInterceptor.InterceptorConfig;
import com.biz.eisp.authInterceptor.InterceptorService;
import com.biz.eisp.authInterceptor.InterceptorUrl;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.DictUtil;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;

public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);
    @Autowired(required=false)
    private InterceptorService interceptorService;
    @Value(value="${crm.main.port:80}")
    private String port;
    @Autowired
    private InterceptorConfig interceptorConfig;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ThreadLocalUtil.clear();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis == null || StringUtil.isEmpty(userRedis.getId())) {
            String url = request.getRequestURI();
            if (StringUtil.isNotEmpty((CharSequence)url)) {
                for (String urlTemp : InterceptorUrl.urlSet) {
                    if (!url.contains(urlTemp)) continue;
                    this.setOpertion(request);
                    return true;
                }
                for (String urlTemp : this.interceptorConfig.getUrlList()) {
                    if (!url.contains(urlTemp)) continue;
                    this.setOpertion(request);
                    return true;
                }
                if (this.interceptorService != null && this.interceptorService.customerIntercept(request, response)) {
                    return true;
                }
            }
            String ip = OConvertUtils.getIpAddrByRequest(request);
            List<KnlDictDataEntity> ips = DictUtil.getDictList("sys_white_list");
            for (KnlDictDataEntity p : ips) {
                if (!p.getDictCode().equals(ip)) continue;
                this.setOpertion(request);
                return true;
            }
            log.error("\u6ca1\u6709\u767b\u5f55\u6743\u9650 -> [{}]", (Object)ip);
            if (!this.isView(request)) {
                this.loginVaild(response);
                return false;
            }
            String requestPathFirst = request.getScheme() + "://" + request.getServerName() + ":" + this.port + "?target=_parent";
            response.sendRedirect(requestPathFirst);
            return false;
        }
        this.setOpertion(request);
        return true;
    }

    private boolean isView(HttpServletRequest request) {
        Object object = request.getAttribute("method_return_is_view");
        if (object == null) {
            return false;
        }
        boolean isView = (Boolean)object;
        return isView;
    }

    private void loginVaild(HttpServletResponse response) throws Exception {
        JSONObject bean = new JSONObject();
        bean.put("code", (Object)401);
        bean.put("msg", (Object)"\u767b\u5f55\u5931\u6548");
        bean.put("success", (Object)false);
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        out.print(bean.toJSONString());
        out.flush();
    }

    private void setOpertion(HttpServletRequest request) {
        String clickFunctionIdToken = request.getParameter("clickFunctionId");
        if (StringUtil.isBlank((CharSequence)clickFunctionIdToken)) {
            clickFunctionIdToken = request.getHeader("clickFunctionId");
        }
        clickFunctionIdToken = StringUtil.isBlank((CharSequence)clickFunctionIdToken) ? "" : clickFunctionIdToken;
        ThreadLocalUtil.setVal(clickFunctionIdToken);
    }

    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI() + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        ThreadLocalUtil.clear();
    }
}

