/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlUtil.class);

    public static String listToReplaceStr(List<?> objList, String proName, boolean type) {
        ArrayList<String> strList = new ArrayList<String>();
        for (Object object : objList) {
            String proStr = null;
            try {
                if (PropertyUtils.getProperty(object, (String)proName) != null) {
                    proStr = String.valueOf(PropertyUtils.getProperty(object, (String)proName));
                }
            }
            catch (InvocationTargetException e) {
                log.error("", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            StringBuffer sb = new StringBuffer();
            if (StringUtil.isNotEmpty((CharSequence)proStr)) {
                if (type) {
                    sb.append("'");
                    sb.append(proStr);
                    sb.append("'");
                } else {
                    sb.append(proStr);
                }
            }
            if (!StringUtil.isNotEmpty((CharSequence)sb.toString())) continue;
            strList.add(sb.toString());
        }
        return StringUtils.join(strList, (String)",");
    }

    public static String arrayToInStr(String str, String splitStr) {
        String[] arry = str.split(splitStr);
        StringBuffer stringBuffer = new StringBuffer("");
        if (arry.length > 0) {
            for (int i = 0; i < arry.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)arry[i])) continue;
                stringBuffer.append("'");
                stringBuffer.append(arry[i]);
                stringBuffer.append("'");
                if (i == arry.length - 1) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String SetToReplaceStr(HashSet<?> set, boolean type) {
        ArrayList<String> strList = new ArrayList<String>();
        for (Object object : set) {
            String proStr = null;
            StringBuffer sb = new StringBuffer();
            if (type) {
                sb.append("'");
                sb.append(object);
                sb.append("'");
            } else {
                sb.append(proStr);
            }
            strList.add(sb.toString());
        }
        return StringUtils.join(strList, (String)",");
    }

    public static String setSqlIn(String[] arr, String inparam, boolean type, String othersql) {
        if (arr != null && arr.length > 0) {
            StringBuffer sqlin_ = new StringBuffer();
            StringBuffer sqlin = new StringBuffer();
            StringBuffer in = new StringBuffer();
            int sn = arr.length / 900;
            int s = arr.length % 900;
            if (s > 0) {
                ++sn;
            }
            for (int i = 0; i < sn; ++i) {
                in = new StringBuffer();
                int en = (i + 1) * 900;
                if (s > 0 && i == sn - 1) {
                    en = i * 900 + s;
                }
                for (int j = i * 900; j < en; ++j) {
                    if (!StringUtils.isNotBlank((CharSequence)arr[j])) continue;
                    if (type) {
                        in.append("'");
                        in.append(arr[j]);
                        in.append("'");
                    } else {
                        in.append(arr[j]);
                    }
                    if (j == en - 1) continue;
                    in.append(",");
                }
                if (i != 0) {
                    sqlin.append(" or " + inparam + " in (" + in.toString() + ")");
                    continue;
                }
                sqlin.append(" " + inparam + " in (" + in.toString() + ")");
            }
            sqlin_.append(" and (");
            sqlin_.append(sqlin.toString());
            if (StringUtil.isNotEmpty((CharSequence)othersql)) {
                sqlin_.append(othersql);
            }
            sqlin_.append(")");
            return sqlin_.toString();
        }
        return null;
    }

    public static String setSqlIn500(List<String> arr, String inparam, boolean type) {
        if (CollectionUtil.listNotEmptyNotSizeZero(arr)) {
            StringBuffer sqlin_ = new StringBuffer();
            StringBuffer sqlin = new StringBuffer();
            StringBuffer in = new StringBuffer();
            int sn = arr.size() / 900;
            int s = arr.size() % 900;
            if (s > 0) {
                ++sn;
            }
            for (int i = 0; i < sn; ++i) {
                in = new StringBuffer();
                int en = (i + 1) * 900;
                if (s > 0 && i == sn - 1) {
                    en = i * 900 + s;
                }
                for (int j = i * 900; j < en; ++j) {
                    if (!StringUtils.isNotBlank((CharSequence)arr.get(j))) continue;
                    if (type) {
                        in.append("'");
                        in.append(arr.get(j));
                        in.append("'");
                    } else {
                        in.append(arr.get(j));
                    }
                    if (j == en - 1) continue;
                    in.append(",");
                }
                if (i != 0) {
                    sqlin.append(" or " + inparam + " in (" + in.toString() + ")");
                    continue;
                }
                sqlin.append(" " + inparam + " in (" + in.toString() + ")");
            }
            sqlin_.append(" (");
            sqlin_.append(sqlin.toString());
            sqlin_.append(")");
            return sqlin_.toString();
        }
        return null;
    }

    public static String setlessSqlIn(String[] arr, String inparam, boolean type) {
        if (arr != null && arr.length > 0) {
            StringBuffer in = new StringBuffer();
            int sn = arr.length;
            for (int i = 0; i < sn; ++i) {
                in = new StringBuffer();
                if (StringUtils.isNotBlank((CharSequence)arr[i])) {
                    if (type) {
                        in.append("'");
                        in.append(arr[i]);
                        in.append("'");
                    } else {
                        in.append(arr[i]);
                    }
                    if (i != sn - 1) {
                        in.append(",");
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)inparam)) continue;
                in.append(inparam);
                in.append(" in (");
                in.append(in.toString());
                in.append(")");
            }
            return in.toString();
        }
        return null;
    }

    public static HashSet<String> listToReplaceSet(List<?> objList, String proName) {
        HashSet<String> targ = new HashSet<String>();
        for (Object object : objList) {
            String proStr = null;
            try {
                proStr = String.valueOf(PropertyUtils.getProperty(object, (String)proName));
            }
            catch (InvocationTargetException e) {
                log.error("", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(proStr);
            targ.add(sb.toString());
        }
        return targ;
    }

    public static String[] listToReplaceArr(List<?> objList, String proName) {
        String[] targ = new String[objList.size()];
        int len = objList.size();
        for (int i = 0; i < len; ++i) {
            String proStr = null;
            try {
                proStr = String.valueOf(PropertyUtils.getProperty(objList.get(i), (String)proName));
            }
            catch (InvocationTargetException e) {
                log.error("", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("", (Throwable)e);
            }
            targ[i] = proStr;
        }
        return targ;
    }
}

