/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.exception;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.exception.feign.GolbalExceptionFeign;
import com.biz.eisp.exception.vo.KnlExceptionVo;
import com.biz.eisp.service.RedisService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@ControllerAdvice
public class GlobalException {
    private static final Logger log = LoggerFactory.getLogger(GlobalException.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    private static GolbalExceptionFeign golbalExceptionFeign;
    private static RedisService redisService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    private static void initFein() {
        if (golbalExceptionFeign == null) {
            golbalExceptionFeign = (GolbalExceptionFeign)SpringApplicationContextUtil.getApplicationContext().getBean("golbalExceptionFeign");
        }
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
        }
    }

    public KnlExceptionVo createVo(Exception ex, UserRedis userRedis) {
        KnlExceptionVo knlExceptionVo = new KnlExceptionVo();
        String exceptionMsg = GlobalException.getExceptionToString(ex);
        if (userRedis != null) {
            knlExceptionVo.setCreateName(userRedis.getRealname());
            knlExceptionVo.setCreateBy(userRedis.getUsername());
        }
        String exceptionCode = UUID.randomUUID().toString().replace("-", "");
        try {
            exceptionCode = String.valueOf(redisService.incr("GOLBAL_EXCEPTION_CODE_", 1L));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        knlExceptionVo.setExceptionCode(exceptionCode);
        knlExceptionVo.setExceptionStatus(ConstantEnum.YesNoEnum.ZERO.getValue());
        knlExceptionVo.setApplicationName(this.applicationName);
        knlExceptionVo.setExceptionMsg(exceptionMsg);
        knlExceptionVo.setCreateDateStr(DateUtils.dateNow2Str());
        return knlExceptionVo;
    }

    public static String getExceptionToString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView errorHandler(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        GlobalException.initFein();
        log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5904\u7406--", (Throwable)ex);
        AjaxJson ajaxJson = new AjaxJson();
        ModelAndView mv = null;
        try {
            UserRedis userRedis = UserUtils.getUser();
            KnlExceptionVo knlExceptionVo = this.createVo(ex, userRedis);
            golbalExceptionFeign.saveData(knlExceptionVo);
            String langKey = userRedis == null ? "zh_cn" : userRedis.getLanguage();
            langKey = StringUtil.isNotEmpty((CharSequence)langKey) ? langKey : "zh_cn";
            String errorMsg = langKey.equalsIgnoreCase("zh_cn") ? "\u64cd\u4f5c\u5931\u8d25" : "Operation Failed";
            errorMsg = errorMsg + "<br/>\u9519\u8bef\u7f16\u7801:" + knlExceptionVo.getExceptionCode();
            if (this.isView(request)) {
                ajaxJson.setErrMsg(errorMsg);
                mv = this.isNojsView(request) ? new ModelAndView("common/errornojs") : new ModelAndView("common/error");
                mv.addObject(ajaxJson);
                mv.addObject("errorMsg", (Object)errorMsg);
                return mv;
            }
            mv = new ModelAndView((View)new MappingJackson2JsonView());
            mv.addObject("success", (Object)false);
            mv.addObject("msg", (Object)errorMsg);
            mv.addObject("code", (Object)"\u672a\u5b9a\u4e49");
            ex.printStackTrace();
        }
        catch (Exception e) {
            mv = this.isNojsView(request) ? new ModelAndView("common/errornojs") : new ModelAndView("common/error");
        }
        return mv;
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public AjaxJson errorHandler(BusinessException ex, HttpServletRequest request, HttpServletResponse response) {
        GlobalException.initFein();
        UserRedis userRedis = UserUtils.getUser();
        KnlExceptionVo knlExceptionVo = this.createVo(ex, userRedis);
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setErrMsg(ex.getMessage());
        log.info(ex.getMessage());
        ex.printStackTrace();
        return ajaxJson;
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public AjaxJson methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException ex) {
        Iterator iterator = ex.getBindingResult().getFieldErrors().iterator();
        StringBuilder msg = new StringBuilder();
        while (iterator.hasNext()) {
            FieldError fieldError = (FieldError)iterator.next();
            msg.append(fieldError.getDefaultMessage()).append(";");
        }
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setErrMsg(msg.toString());
        return ajaxJson;
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public AjaxJson bindExceptionHandler(BindException ex) {
        Iterator iterator = ex.getBindingResult().getFieldErrors().iterator();
        StringBuilder msg = new StringBuilder();
        while (iterator.hasNext()) {
            FieldError fieldError = (FieldError)iterator.next();
            msg.append(fieldError.getDefaultMessage()).append(";");
        }
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setErrMsg(msg.toString());
        return ajaxJson;
    }

    private boolean isView(HttpServletRequest request) {
        Object object = request.getAttribute("method_return_is_view");
        if (object == null) {
            log.error("\u914d\u7f6e\u51fa\u9519");
            return false;
        }
        boolean isView = (Boolean)object;
        return isView;
    }

    private boolean isNojsView(HttpServletRequest request) {
        Object object = request.getAttribute("method_return_is_nojs");
        if (object == null) {
            return false;
        }
        boolean isView = (Boolean)object;
        return isView;
    }
}

