/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.filter;

import com.biz.eisp.filter.XssFilterUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest = null;
    private boolean isIncludeRichText = false;

    public XssHttpServletRequestWrapper(HttpServletRequest request, boolean isIncludeRichText) {
        super(request);
        this.orgRequest = request;
        this.isIncludeRichText = isIncludeRichText;
    }

    public String getParameter(String name) {
        if (("content".equals(name) || name.endsWith("WithHtml")) && !this.isIncludeRichText) {
            return super.getParameter(name);
        }
        String value = super.getParameter(name = XssFilterUtil.clean(name));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = XssFilterUtil.clean(value);
            value = this.replaceBracket(value);
        }
        return value;
    }

    public String[] getParameterValues(String name) {
        String[] arr = super.getParameterValues(name);
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = XssFilterUtil.clean(arr[i]);
                arr[i] = this.replaceBracket(arr[i]);
            }
        }
        return arr;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name = XssFilterUtil.clean(name));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = XssFilterUtil.clean(value);
        }
        return value;
    }

    private String replaceBracket(String orgin) {
        return orgin.replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;");
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }
}

