/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base;

import com.alibaba.excel.metadata.BaseRowModel;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.util.ExcelProgressUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.base.vo.TemplateVo;
import com.biz.eisp.excel.ExcelUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Component
public abstract class ImpExpController {
    private static final Logger log = LoggerFactory.getLogger(ImpExpController.class);
    @Autowired
    private ThreadPoolTaskExecutor taskPoolExecutor;

    @RequestMapping(value={"/excelImportTemplate"})
    public void excelImportTemplate(TemplateVo templateVo, HttpServletResponse response) {
        try {
            if (StringUtil.isEmpty((String)templateVo.getClassPath())) {
                throw new BusinessException("\u53c2\u6570\u9519\u8bef");
            }
            Class<?> classVo = Class.forName(templateVo.getClassPath());
            Object obj = classVo.newInstance();
            ExcelUtil.writeExcel(response, new ArrayList(), templateVo.getTitle(), templateVo.getSheetName(), (BaseRowModel)obj);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("\u6a21\u677f\u751f\u6210\u5931\u8d25");
        }
    }

    @RequestMapping(value={"doImport"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson doImport(HttpServletRequest request, HttpServletResponse response, ExcelDate excelDate, MultipartFile excel) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (StringUtil.isEmpty((String)excelDate.getExcelUuid()) || StringUtil.isEmpty((String)excelDate.getClassPath())) {
                ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
                return ajaxJson;
            }
            excelDate.setUserRedis(UserUtils.getUser());
            ExcelProgressUtil.progress(false, "\u5f00\u59cb\u5904\u7406excel", excelDate.getExcelUuid(), null);
            ajaxJson = this.doBusiness(request, response, excelDate, excel);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            ExcelProgressUtil.progress(true, "EXCEL\u5bfc\u5165\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4ee3\u78012001", excelDate.getExcelUuid(), null);
            e.printStackTrace();
            ajaxJson.setErrMsg("EXCEL\u5bfc\u5165\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4ee3\u78012001");
        }
        return ajaxJson;
    }

    protected AjaxJson doBusiness(HttpServletRequest request, HttpServletResponse response, ExcelDate excelDate, MultipartFile excel) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            Class<?> classVo = Class.forName(excelDate.getClassPath());
            List<?> list = ExcelUtil.readExcel(excel, classVo);
            ExcelProgressUtil.progress(false, "\u6b63\u5728\u6821\u9a8c\u6570\u636e", excelDate.getExcelUuid(), null);
            ajaxJson = this.checkImportList(list, excelDate);
            if (!ajaxJson.isSuccess()) {
                ExcelProgressUtil.progress(true, "EXCEL\u5bfc\u5165\u7ed3\u675f", excelDate.getExcelUuid(), null);
                ajaxJson.setSuccess(true);
                return ajaxJson;
            }
            ExcelProgressUtil.progress(false, "\u5f00\u59cb\u5904\u7406\u6570\u636e", excelDate.getExcelUuid(), null);
            this.doImportList(list, excelDate);
            ExcelProgressUtil.progress(true, "EXCEL\u5bfc\u5165\u7ed3\u675f", excelDate.getExcelUuid(), null);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            ExcelProgressUtil.progress(true, "EXCEL\u5bfc\u5165\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4ee3\u78012001", excelDate.getExcelUuid(), null);
            e.printStackTrace();
            ajaxJson.setErrMsg("EXCEL\u5bfc\u5165\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4ee3\u78012001");
        }
        return ajaxJson;
    }

    protected abstract AjaxJson checkImportList(List var1, ExcelDate var2);

    protected abstract AjaxJson doImportList(List var1, ExcelDate var2);
}

