/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.utils.JsonPropertyUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.util.ExcelTempPathUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.configure.entity.KnlTableConfigEntity;
import com.biz.eisp.configure.vo.KnlTableConfigVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.kernel.KnlTableConfigFeign;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.DictUtil;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/commonExcelController"})
public class CommonExcelController {
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private KnlTableConfigFeign knlTableConfigFeign;
    @Autowired
    private ExcelTempPathUtil excelTempPathUtil;
    @Value(value="${crm.main.port:80}")
    private String port;

    private void setOpertion(HttpServletRequest request) {
        String clickFunctionIdToken = request.getParameter("clickFunctionId");
        if (StringUtil.isBlank((CharSequence)clickFunctionIdToken)) {
            clickFunctionIdToken = request.getHeader("clickFunctionIdToken");
        }
        clickFunctionIdToken = StringUtil.isBlank((CharSequence)clickFunctionIdToken) ? "" : clickFunctionIdToken;
        ThreadLocalUtil.setVal((String)clickFunctionIdToken);
    }

    @RequestMapping(value={"/excel"})
    public void excel(HttpServletRequest request, HttpServletResponse response, @RequestParam Map<String, Object> paramMap) {
        String functionId = paramMap.containsKey("clickFunctionId_") ? paramMap.get("clickFunctionId_").toString() : "";
        String controllerTarget_ = paramMap.containsKey("controllerTarget_") ? paramMap.get("controllerTarget_").toString() : "";
        String methedTarget_ = paramMap.containsKey("methedTarget_") ? paramMap.get("methedTarget_").toString() : "";
        String excelName = paramMap.containsKey("excelName_") ? paramMap.get("excelName_").toString() : UUID.randomUUID().toString().replace("-", "");
        String excelSheetName = paramMap.containsKey("excelSheetName_") ? paramMap.get("excelSheetName_").toString() : UUID.randomUUID().toString().replace("-", "");
        excelSheetName = StringUtil.isEmpty((String)excelSheetName) ? UUID.randomUUID().toString().replace("-", "") : excelSheetName;
        String string = excelName = StringUtil.isEmpty((String)excelName) ? UUID.randomUUID().toString().replace("-", "") : excelName;
        if (StringUtil.isBlank((CharSequence)functionId) || StringUtil.isBlank((CharSequence)controllerTarget_) || StringUtil.isBlank((CharSequence)methedTarget_)) {
            return;
        }
        this.setOpertion(request);
        try {
            Object obj = SpringApplicationContextUtil.getApplicationContext().getBean(controllerTarget_);
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            Method[] methods = obj.getClass().getDeclaredMethods();
            DataGrid dataGrid = null;
            for (Method method : methods) {
                if (!StringUtil.equals((String)method.getName(), (String)methedTarget_)) continue;
                String[] params = u.getParameterNames(method);
                Class<?>[] paramTypes = method.getParameterTypes();
                Object[] paramVals = new Object[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    Object objVal;
                    paramVals[i] = objVal = this.checkData(paramTypes[i], request, response, paramMap, params[i]);
                }
                dataGrid = (DataGrid)method.invoke(obj, paramVals);
                break;
            }
            if (dataGrid != null) {
                ArrayList<String> headname = new ArrayList<String>();
                HashMap<String, String> headMap = new HashMap<String, String>();
                List<String> head = this.getExcelHead(functionId, headname, headMap);
                List<List<String>> headnames = this.createHeads(headname);
                if (CollectionUtil.listEmpty(head)) {
                    return;
                }
                List<List<String>> vals = this.getVal(head, dataGrid, headMap);
                this.writeExcel(request, response, excelName, headnames, vals, excelSheetName);
            }
        }
        catch (Exception e) {
            String requestPathFirst = request.getScheme() + "://" + request.getServerName() + ":" + this.port + "/page/commonExcelExceptionController/excelException?1=1";
            try {
                response.sendRedirect(requestPathFirst);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private List<List<String>> createHeads(List<String> head) {
        ArrayList<List<String>> heads = new ArrayList<List<String>>();
        head.forEach(item -> {
            ArrayList<String> headTmep = new ArrayList<String>();
            headTmep.add((String)item);
            heads.add(headTmep);
        });
        return heads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExcel(HttpServletRequest request, HttpServletResponse response, String fileName, List<List<String>> heads, List<List<String>> vals, String sheetName) {
        String createExcelPath = this.excelTempPathUtil.getPath();
        OutputStream out = null;
        InputStream inStream = null;
        try {
            int len;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String outName = fileName + sdf.format(new Date()) + ExcelTypeEnum.XLSX.getValue();
            fileName = createExcelPath + fileName + sdf.format(new Date());
            String filePath = fileName + ExcelTypeEnum.XLSX.getValue();
            outName = new String(outName.getBytes(), "ISO-8859-1");
            EasyExcel.write((String)filePath).head(heads).sheet(sheetName).doWrite(vals);
            inStream = new FileInputStream(filePath);
            response.reset();
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=" + outName);
            out = response.getOutputStream();
            byte[] b = new byte[1024];
            while ((len = inStream.read(b)) > 0) {
                response.getOutputStream().write(b, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<List<String>> getVal(List<String> heads, DataGrid dataGrid, Map<String, String> headMap) {
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)dataGrid.getRows())) {
            HashMap map = new HashMap();
            for (Map.Entry<String, String> entry : headMap.entrySet()) {
                String mapKey = entry.getKey();
                String mapValue = entry.getValue();
                Map objectMap = new HashMap();
                if (StringUtil.isNotEmpty((CharSequence)mapValue)) {
                    objectMap = DictUtil.getDictMap((String)mapValue);
                }
                map.put(mapKey, objectMap);
            }
            for (Map.Entry<String, String> obj : dataGrid.getRows()) {
                ArrayList<String> vals = new ArrayList<String>();
                Class<?> clazz = obj.getClass();
                Field[] fieldArray = clazz.getDeclaredFields();
                ArrayList<Field> fieldsAll = new ArrayList<Field>();
                fieldsAll.addAll(Arrays.asList(fieldArray));
                Class<?> superClazz = clazz.getSuperclass();
                if (superClazz != null) {
                    Field[] fieldArrayTemp = superClazz.getDeclaredFields();
                    fieldsAll.addAll(Arrays.asList(fieldArrayTemp));
                }
                List fields = fieldsAll.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Field>(Comparator.comparing(Field::getName))), ArrayList::new));
                HashMap<String, Field> mapFile = new HashMap<String, Field>();
                for (Field field : fields) {
                    mapFile.put(field.getName(), field);
                }
                for (String head : heads) {
                    String val = "";
                    Field field = (Field)mapFile.get(head);
                    if (field != null) {
                        try {
                            KnlDictDataEntity knlDictDataEntity;
                            Map objectMap;
                            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                            Method getMethod = pd.getReadMethod();
                            Object o = getMethod.invoke(obj, new Object[0]);
                            if (o != null) {
                                val = o.toString();
                            }
                            if (!(objectMap = (Map)map.get(head)).isEmpty() && null != (knlDictDataEntity = (KnlDictDataEntity)objectMap.get(val))) {
                                val = knlDictDataEntity.getDictValue();
                            }
                        }
                        catch (Exception e) {
                            val = "";
                            e.printStackTrace();
                        }
                    }
                    vals.add(val);
                }
                lists.add(vals);
            }
        }
        return lists;
    }

    private List<String> getExcelHead(String functionId, List<String> names, Map<String, String> headMap) {
        List<String> head = new ArrayList<String>();
        List<Object> userSet = new ArrayList();
        String userName = UserUtils.getUser().getUsername();
        userSet = this.getUserSet(userName, functionId);
        if (!CollectionUtil.listNotEmptyNotSizeZero(userSet)) {
            userSet = this.getBaseSet(functionId);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(userSet)) {
            userSet.forEach(item -> {
                if (item.getShowOrder() == null) {
                    item.setShowOrder(Integer.valueOf(0));
                }
            });
            Collections.sort(userSet, Comparator.comparing(KnlTableConfigEntity::getShowOrder));
            for (int i = 0; i < userSet.size(); ++i) {
                if (CommonExcelController.checkExcelFieldStatus(((KnlTableConfigEntity)userSet.get(i)).getIsHide(), ((KnlTableConfigEntity)userSet.get(i)).getIsExcel())) continue;
                userSet.remove(i);
                --i;
            }
            head = userSet.stream().map(KnlTableConfigEntity::getField).collect(Collectors.toList());
            userSet.forEach(item -> {
                names.add(item.getTitle());
                headMap.put(item.getField(), item.getDictionary());
            });
        }
        return head;
    }

    private static boolean checkExcelFieldStatus(String isHide, String isExcel) {
        return !(StringUtils.isBlank((CharSequence)isExcel) || ConstantEnum.YesNoEnum.TWO.getValue().equals(isExcel) ? ConstantEnum.YesNoEnum.ONE.getValue().equals(isHide) : ConstantEnum.YesNoEnum.ZERO.getValue().equals(isExcel));
    }

    private List<KnlTableConfigEntity> getBaseSet(String functionId) {
        ArrayList<KnlTableConfigEntity> returnList = new ArrayList<KnlTableConfigEntity>();
        Map confMap = this.redisService.hmget("TABLE_CONFIG_" + functionId);
        if (confMap != null && !confMap.isEmpty()) {
            confMap.forEach((k, v) -> returnList.add((KnlTableConfigEntity)v));
        } else {
            KnlTableConfigVo vo = new KnlTableConfigVo();
            vo.setFunctionId(functionId);
            vo.setIsInit(Boolean.valueOf(true));
            List configs = ApiResultUtil.listResult((AjaxJson)this.knlTableConfigFeign.getTableConfigByParam(vo));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)configs)) {
                returnList.addAll(configs);
            }
        }
        return returnList;
    }

    private List<KnlTableConfigEntity> getUserSet(String userName, String functionId) {
        ArrayList<KnlTableConfigEntity> returnList = new ArrayList<KnlTableConfigEntity>();
        Map map = this.redisService.hmget("TABLE_CONFIG_" + userName + "_" + functionId);
        if (map != null && !map.isEmpty()) {
            map.forEach((k, v) -> returnList.add((KnlTableConfigEntity)v));
        } else {
            KnlTableConfigVo tableConfigVo = new KnlTableConfigVo();
            tableConfigVo.setFunctionId(functionId);
            tableConfigVo.setUserName(userName);
            List list = ApiResultUtil.listResult((AjaxJson)this.knlTableConfigFeign.getTableConfigByParam(tableConfigVo));
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                list.forEach(item -> returnList.add((KnlTableConfigEntity)item));
            }
        }
        return returnList;
    }

    private Object checkData(Class clazz, HttpServletRequest request, HttpServletResponse response, Map<String, Object> paramMap, String name) {
        String className;
        Object objVal = null;
        switch (className = clazz.getName()) {
            case "java.lang.String": {
                objVal = paramMap.get(name);
                break;
            }
            case "java.lang.Integer": {
                objVal = paramMap.get(name);
                break;
            }
            case "javax.servlet.http.HttpServletRequest": {
                objVal = request;
                break;
            }
            case "javax.servlet.http.HttpServletResponse": {
                objVal = response;
                break;
            }
            default: {
                String json = JSON.toJSONString(paramMap);
                objVal = JsonPropertyUtil.toObject((String)json, (Class)clazz);
            }
        }
        return objVal;
    }
}

