/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.excel;

import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.eisp.excel.ExcelException;
import com.biz.eisp.excel.ExcelListener;
import com.biz.eisp.excel.ExcelWriterFactroy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    public static <T extends BaseRowModel> List<T> readExcel(MultipartFile excel, Class<T> clazz) {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = ExcelUtil.getReader(excel, excelListener);
        if (reader == null) {
            return null;
        }
        for (Sheet sheet : reader.getSheets()) {
            sheet.setClazz(clazz);
            reader.read(sheet);
        }
        return excelListener.getDatas();
    }

    public static <T extends BaseRowModel> List<T> readExcel(MultipartFile excel, Class<T> clazz, int sheetNo) {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader reader = ExcelUtil.getReader(excel, excelListener);
        if (reader == null) {
            return null;
        }
        Sheet sheet = new Sheet(sheetNo);
        sheet.setClazz(clazz);
        reader.read(sheet);
        return excelListener.getDatas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExcel(HttpServletResponse response, List<? extends BaseRowModel> list, String fileName, String sheetName, BaseRowModel object) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String filePath = (fileName = fileName + sdf.format(new Date())) + ExcelTypeEnum.XLSX.getValue();
        File dbfFile = new File(filePath);
        if (!dbfFile.exists() || dbfFile.isDirectory()) {
            dbfFile.createNewFile();
        }
        fileName = new String(filePath.getBytes(), "ISO-8859-1");
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Disposition", "filename=" + fileName);
        ServletOutputStream out = response.getOutputStream();
        try {
            ExcelWriter writer = new ExcelWriter((OutputStream)out, ExcelTypeEnum.XLSX);
            Sheet sheet = new Sheet(1, 0, object.getClass());
            sheet.setSheetName(sheetName);
            writer.write(list, sheet);
            writer.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ExcelWriterFactroy writeExcelWithSheets(HttpServletResponse response, List<? extends BaseRowModel> list, String fileName, String sheetName, BaseRowModel object) throws IOException {
        String filePath = fileName + ".xlsx";
        File dbfFile = new File(filePath);
        if (!dbfFile.exists() || dbfFile.isDirectory()) {
            dbfFile.createNewFile();
        }
        fileName = new String(filePath.getBytes(), "ISO-8859-1");
        response.addHeader("Content-Disposition", "filename=" + fileName);
        ServletOutputStream out = response.getOutputStream();
        ExcelWriterFactroy writer = new ExcelWriterFactroy((OutputStream)out, ExcelTypeEnum.XLSX);
        try {
            Sheet sheet = new Sheet(1, 0, object.getClass());
            sheet.setSheetName(sheetName);
            writer.write(list, sheet);
            return writer;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return writer;
        }
    }

    private static ExcelReader getReader(MultipartFile excel, ExcelListener excelListener) {
        String filename = excel.getOriginalFilename();
        if (filename == null || !filename.toLowerCase().endsWith(".xls") && !filename.toLowerCase().endsWith(".xlsx")) {
            throw new ExcelException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01");
        }
        ExcelTypeEnum excelTypeEnum = ExcelTypeEnum.XLSX;
        if (filename.toLowerCase().endsWith(".xls")) {
            excelTypeEnum = ExcelTypeEnum.XLS;
        }
        try {
            InputStream inputStream = excel.getInputStream();
            return new ExcelReader(inputStream, excelTypeEnum, null, (AnalysisEventListener)excelListener);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

