/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.util;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.vo.ProgressVo;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.websocket.ExcelFeign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExcelProgressUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelProgressUtil.class);
    private static RedisService redisService;
    private static ExcelFeign excelFeign;

    public static void progress(boolean isEnd, String content, String excelUuid, String extendMsg) {
        if (StringUtil.isEmpty((String)excelUuid)) {
            throw new BusinessException("excel\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProgressVo vo = new ProgressVo(isEnd, content, excelUuid, extendMsg);
        String key = "GLOBAL_EXCEL_" + excelUuid;
        try {
            if (redisService == null) {
                redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
            }
            redisService.setHours(key, (Object)vo, 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (excelFeign == null) {
                excelFeign = (ExcelFeign)SpringApplicationContextUtil.getApplicationContext().getBean("excelFeign");
            }
            excelFeign.pushExcelMessage(vo);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25:{}{}", (Object)excelUuid, (Object)content);
            log.error("cause", (Throwable)e);
            e.printStackTrace();
        }
    }
}

