/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.Interceptor;

import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.kernel.KnlOperateLogFeign;
import com.biz.eisp.knlLog.entity.KnlOperatelog;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.biz.eisp.tk.utils.CompareUtils;
import com.biz.eisp.tkmybatis.CommonMapper;
import com.biz.eisp.util.ClientUtil;
import com.biz.eisp.util.ModifyLog;
import com.biz.eisp.util.SpringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Transactional
public class ModifyLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ModifyLogAspect.class);
    private static final String MODIFY_LOG_PROCESS_ID = UUIDGenerator.generate();
    private static final String CREATE = "CREATE";
    @Autowired
    private RedisService redisService;
    @Autowired
    private KnlOperateLogFeign knlOperateLogFeign;

    @Before(value="@annotation(modifyLog)")
    public void doBefore(JoinPoint joinPoint, ModifyLog modifyLog) {
        Object oldObject;
        Object info = joinPoint.getArgs()[0];
        String redisKey = Thread.currentThread().getId() + "_" + MODIFY_LOG_PROCESS_ID;
        String id = BeanCopyUtils.getProperty((Object)info, (String)"id");
        if (StringUtils.isBlank((CharSequence)id)) {
            id = CREATE;
            this.redisService.setMinutes(redisKey, (Object)id, 15L);
        }
        if (null != (oldObject = this.getBizData(id, modifyLog))) {
            this.redisService.setMinutes(redisKey, oldObject, 15L);
        }
    }

    private Object getBizData(String id, ModifyLog modifyLog) {
        CommonMapper mapper = SpringUtil.getBean(modifyLog.mapperBeanName(), CommonMapper.class);
        if (null != mapper) {
            return mapper.selectByPrimaryKey((Object)id);
        }
        return null;
    }

    @AfterReturning(pointcut="@annotation(modifyLog)", returning="object")
    public void doAfterReturing(Object object, ModifyLog modifyLog) {
        String redisKey = Thread.currentThread().getId() + "_" + MODIFY_LOG_PROCESS_ID;
        Object oldData = this.redisService.get(redisKey);
        if (null == oldData) {
            return;
        }
        KnlOperatelog operateLog = this.buildLogEntity(modifyLog);
        if (oldData instanceof String && CREATE.equals(oldData)) {
            String id = BeanCopyUtils.getProperty((Object)object, (String)"id");
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            operateLog.setModifycontent("--\u521b\u5efa\u6570\u636e--");
            operateLog.setBusinessKey(id);
        } else {
            String id = BeanCopyUtils.getProperty((Object)oldData, (String)"id");
            Object newObject = this.getBizData(id, modifyLog);
            String content = CompareUtils.compare((Object)oldData, (Object)newObject);
            operateLog.setModifycontent(content);
            operateLog.setBusinessKey(id);
        }
        this.knlOperateLogFeign.saveLog(operateLog);
        this.redisService.del(new String[]{redisKey});
    }

    private KnlOperatelog buildLogEntity(ModifyLog modifyLog) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        UserRedis user = UserUtils.getUser();
        KnlOperatelog operateLog = new KnlOperatelog();
        operateLog.setUserName(user.getUsername());
        operateLog.setRealName(user.getRealname());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        operateLog.setModifyip(ClientUtil.getClientIp(request));
        operateLog.setModifydate(sdf.format(new Date()));
        String handelName = modifyLog.handleName();
        String module = modifyLog.module();
        if (StringUtils.isBlank((CharSequence)handelName)) {
            operateLog.setModifyobject(request.getRequestURL().toString());
        } else {
            operateLog.setModifyobject(handelName);
        }
        if (StringUtils.isBlank((CharSequence)module)) {
            operateLog.setModule(request.getContextPath());
        } else {
            operateLog.setModule(module);
        }
        return operateLog;
    }
}

