/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.tools;

import com.biz.eisp.api.feign.KnlCodeRuleFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.RedisUtils;
import com.biz.eisp.code.entity.KnlCodingRulesEntity;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.service.RedisService;
import java.util.Date;

public class CodeRuleUtil {
    private static RedisService redisService;
    private static KnlCodeRuleFeign knlCodeRuleFeign;

    public static void getKnlCodeRuleFeign() {
        String[] beanTypes;
        if (knlCodeRuleFeign == null && (beanTypes = SpringApplicationContextUtil.getApplicationContext().getBeanNamesForType(KnlCodeRuleFeign.class)).length > 0) {
            knlCodeRuleFeign = (KnlCodeRuleFeign)SpringApplicationContextUtil.getApplicationContext().getBean(KnlCodeRuleFeign.class);
        }
    }

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
    }

    public static String getKnlCodingRulesString(String codingRuleCode) {
        StringBuffer stringBuffer = new StringBuffer();
        KnlCodingRulesEntity data = new KnlCodingRulesEntity();
        CodeRuleUtil.getRedisService();
        Object object = redisService.get("CODE_RULE_" + codingRuleCode);
        if (object != null) {
            data = (KnlCodingRulesEntity)object;
            String prefix = data.getPrefix();
            int codeLength = data.getCodeLength();
            stringBuffer.append(prefix);
            long currenValue = redisService.incr("CODE_RULE_INIT_" + codingRuleCode, 1L);
            int plength = prefix.length() + new Long(currenValue).toString().length();
            int fillLength = codeLength - plength;
            for (int i = 0; i < fillLength; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(currenValue);
            data.setCurrentValue(Integer.valueOf((int)currenValue));
        } else {
            CodeRuleUtil.getKnlCodeRuleFeign();
            AjaxJson ajaxJson = knlCodeRuleFeign.getCodeRuleObj(codingRuleCode);
            if (ajaxJson != null) {
                data = (KnlCodingRulesEntity)ajaxJson.getObj();
            }
            String prefix = data.getPrefix();
            int codeLength = data.getCodeLength();
            stringBuffer.append(prefix);
            long currenValue = redisService.incr("CODE_RULE_INIT_" + codingRuleCode, 1L);
            int plength = prefix.length() + new Long(currenValue).toString().length();
            int fillLength = codeLength - plength;
            for (int i = 0; i < fillLength; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(currenValue);
            data.setCurrentValue(Integer.valueOf((int)currenValue));
        }
        data.setGenerationTime(new Date());
        redisService.setDays("CODE_RULE_" + codingRuleCode, (Object)data, 3650L);
        return stringBuffer.toString();
    }
}

