/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dao;

import com.github.pagehelper.PageInfo;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class MongoBaseDao<T> {
    private static final int DEFAULT_SKIP = 0;
    private static final int DEFAULT_LIMIT = 200;
    @Autowired
    protected MongoTemplate mongoTemplate;
    protected String collection;

    public List<T> find(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    public List<T> find(Query query, String collectionName) {
        return this.mongoTemplate.find(query, this.getEntityClass(), collectionName);
    }

    public T findOne(Query query) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    public T findOne(Query query, String collectionName) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass(), collectionName);
    }

    public void update(Query query, Update update) {
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass());
    }

    public void update(Query query, Update update, String collectionName) {
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass(), collectionName);
    }

    public void removeById(String id, String collectionName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        this.mongoTemplate.remove(query, collectionName);
    }

    public T save(T entity) {
        this.mongoTemplate.insert(entity);
        return entity;
    }

    public T save(T entity, String collectionName) {
        this.mongoTemplate.insert(entity, collectionName);
        return entity;
    }

    public T findById(String id) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass());
    }

    public T findById(String id, String collectionName) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass(), collectionName);
    }

    public PageInfo<T> findPage(int pageNum, int pageSize, Query query) {
        long count = this.count(query);
        query.skip((long)((pageNum - 1) * pageSize)).limit(pageSize);
        List<T> rows = this.find(query);
        PageInfo result = new PageInfo(rows);
        result.setTotal(count);
        result.setPageNum(pageNum);
        result.setPageSize(pageSize);
        return result;
    }

    public PageInfo<T> findPage(int pageNum, int pageSize, Query query, String collectionName) {
        long count = this.count(query, collectionName);
        query.skip((long)((pageNum - 1) * pageSize)).limit(pageSize);
        List<T> rows = this.find(query, collectionName);
        PageInfo result = new PageInfo(rows);
        result.setTotal(count);
        result.setPageNum(pageNum);
        result.setPageSize(pageSize);
        return result;
    }

    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    public long count(Query query, String collectionName) {
        return this.mongoTemplate.count(query, this.getEntityClass(), collectionName);
    }

    private Class<T> getEntityClass() {
        Type superclass = this.getClass().getGenericSuperclass();
        Type[] actualTypeArguments = ((ParameterizedType)superclass).getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }
}

